/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jtransc.io.JTranscSyncIO;

public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private final JTranscSyncIO.ImplStream stream;
    private final String path;
    private volatile boolean closed = false;
    private byte[] buffer = new byte[]{0};

    public FileInputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String name;
        String string = name = file != null ? file.getPath() : null;
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.path = name;
        this.stream = JTranscSyncIO.impl.open(name, 1);
    }

    public FileInputStream(FileDescriptor fdObj) {
        if (fdObj == null) {
            throw new NullPointerException();
        }
        this.fd = fdObj;
        this.path = null;
        this.stream = null;
    }

    @Override
    public int read() throws IOException {
        int read = this.stream.read(this.buffer, 0, 1);
        if (read != 1) {
            return -1;
        }
        return this.buffer[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.stream.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        return this.stream.read(data, offset, length);
    }

    @Override
    public long skip(long n) throws IOException {
        this.stream.setPosition(this.stream.getPosition() + n);
        return this.stream.getPosition();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.stream.getLength() - this.stream.getPosition());
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stream.close();
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            this.close();
        }
    }
}

