/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jtransc.annotation.JTranscKeep;
import jtransc.internal.JTranscCType;

public final class Long
extends Number
implements Comparable<Long> {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = Class.getPrimitiveClass("long");
    private final long value;
    public static final int SIZE = 64;
    public static final int BYTES = 8;

    public static String toString(long i, int radix) {
        boolean negative;
        if (i == 0L) {
            return "0";
        }
        if (i == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        StringBuilder out = new StringBuilder();
        boolean bl = negative = i < 0L;
        if (negative) {
            i = -i;
        }
        while (i != 0L) {
            out.append(JTranscCType.encodeDigit((int)((i % (long)radix + (long)radix) % (long)radix)));
            i /= (long)radix;
        }
        if (negative) {
            out.append("-");
        }
        out.reverse();
        return out.toString();
    }

    public static String toUnsignedString(long i, int radix) {
        if (i == 0L) {
            return "0";
        }
        StringBuilder out = new StringBuilder();
        while (i != 0L) {
            out.append(JTranscCType.encodeDigit((int)Long.remainderUnsigned(i, radix)));
            i = Long.divideUnsigned(i, radix);
        }
        out.reverse();
        return out.toString();
    }

    public static String toHexString(long i) {
        return Long.toString(i, 16);
    }

    public static String toOctalString(long i) {
        return Long.toString(i, 8);
    }

    public static String toBinaryString(long i) {
        return Long.toString(i, 2);
    }

    public static String toString(long i) {
        return Long.toString(i, 10);
    }

    public static String toUnsignedString(long i) {
        return Long.toUnsignedString(i, 10);
    }

    public static long parseLong(String s, int radix) throws NumberFormatException {
        int n;
        long result = 0L;
        int len = s.length();
        boolean negative = s.charAt(0) == '-';
        int sign = negative ? -1 : 1;
        int n2 = n = negative ? 1 : 0;
        while (n < len) {
            result *= (long)radix;
            result += (long)JTranscCType.decodeDigit(s.charAt(n));
            ++n;
        }
        return result * (long)sign;
    }

    public static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        return Long.parseLong(s, radix);
    }

    public static Long valueOf(String s, int radix) throws NumberFormatException {
        return Long.parseLong(s, radix);
    }

    public static long parseLong(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    public static long parseUnsignedLong(String s) throws NumberFormatException {
        return Long.parseUnsignedLong(s, 10);
    }

    public static Long valueOf(String s) throws NumberFormatException {
        return Long.valueOf(s, 10);
    }

    @JTranscKeep
    public static Long valueOf(long l) {
        return new Long(l);
    }

    public static Long decode(String nm) throws NumberFormatException {
        if (nm.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        if (nm.startsWith("-")) {
            return -Long.decode(nm.substring(1)).longValue();
        }
        if (nm.startsWith("+")) {
            return Long.decode(nm.substring(1));
        }
        if (nm.startsWith("0x")) {
            return Long.parseLong(nm.substring(2), 16);
        }
        if (nm.startsWith("0X")) {
            return Long.parseLong(nm.substring(2), 16);
        }
        if (nm.startsWith("#")) {
            return Long.parseLong(nm.substring(1), 16);
        }
        if (nm.startsWith("0")) {
            return Long.parseLong(nm.substring(1), 8);
        }
        return Long.parseLong(nm, 10);
    }

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) throws NumberFormatException {
        this.value = Long.parseLong(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Long)) {
            return false;
        }
        return this.value == (Long)obj;
    }

    public static Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        return Long.getLong(nm, (Long)val);
    }

    public static Long getLong(String nm, Long val) {
        String out = System.getProperty(nm);
        if (out == null) {
            return val;
        }
        try {
            return Long.decode(nm);
        }
        catch (NumberFormatException e) {
            return val;
        }
    }

    @Override
    public int compareTo(Long anotherLong) {
        return Long.compare(this.value, anotherLong.value);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareUnsigned(long x, long y) {
        return Long.compare(x ^ Long.MIN_VALUE, y ^ Long.MIN_VALUE);
    }

    public static long divideUnsigned(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            return Long.compareUnsigned(dividend, divisor) < 0 ? 0L : 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(Long.compareUnsigned(rem, divisor) >= 0 ? 1 : 0);
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            return Long.compareUnsigned(dividend, divisor) < 0 ? dividend : dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (Long.compareUnsigned(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    public static long highestOneBit(long v) {
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        v |= v >> 32;
        return v - (v >>> 1);
    }

    public static long lowestOneBit(long v) {
        return v & -v;
    }

    public static int numberOfLeadingZeros(long v) {
        if (v == 0L) {
            return 64;
        }
        int n = 1;
        int x = (int)(v >>> 32);
        if (x == 0) {
            n += 32;
            x = (int)v;
        }
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    public static int numberOfTrailingZeros(long value) {
        int x;
        if (value == 0L) {
            return 64;
        }
        int n = 63;
        int y = (int)value;
        if (y != 0) {
            n -= 32;
            x = y;
        } else {
            x = (int)(value >>> 32);
        }
        y = x << 16;
        if (y != 0) {
            n -= 16;
            x = y;
        }
        if ((y = x << 8) != 0) {
            n -= 8;
            x = y;
        }
        if ((y = x << 4) != 0) {
            n -= 4;
            x = y;
        }
        if ((y = x << 2) != 0) {
            n -= 2;
            x = y;
        }
        return n - (x << 1 >>> 31);
    }

    public static int bitCount(long v) {
        v -= v >>> 1 & 0x5555555555555555L;
        v = (v & 0x3333333333333333L) + (v >>> 2 & 0x3333333333333333L);
        v = v + (v >>> 4) & 0xF0F0F0F0F0F0F0FL;
        v += v >>> 8;
        v += v >>> 16;
        v += v >>> 32;
        return (int)v & 0x7F;
    }

    public static long rotateLeft(long value, int distance) {
        return value << distance | value >>> -distance;
    }

    public static long rotateRight(long value, int distance) {
        return value >>> distance | value << -distance;
    }

    public static long reverse(long v) {
        v = (v & 0x5555555555555555L) << 1 | v >>> 1 & 0x5555555555555555L;
        v = (v & 0x3333333333333333L) << 2 | v >>> 2 & 0x3333333333333333L;
        v = (v & 0xF0F0F0F0F0F0F0FL) << 4 | v >>> 4 & 0xF0F0F0F0F0F0F0FL;
        v = (v & 0xFF00FF00FF00FFL) << 8 | v >>> 8 & 0xFF00FF00FF00FFL;
        v = v << 48 | (v & 0xFFFF0000L) << 16 | v >>> 16 & 0xFFFF0000L | v >>> 48;
        return v;
    }

    public static int signum(long v) {
        return (int)(v >> 63 | -v >>> 63);
    }

    public static long reverseBytes(long v) {
        v = (v & 0xFF00FF00FF00FFL) << 8 | v >>> 8 & 0xFF00FF00FF00FFL;
        return v << 48 | (v & 0xFFFF0000L) << 16 | v >>> 16 & 0xFFFF0000L | v >>> 48;
    }

    public static long sum(long l, long r) {
        return l + r;
    }

    public static long max(long l, long r) {
        return Math.max(l, r);
    }

    public static long min(long l, long r) {
        return Math.min(l, r);
    }
}

