/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.Type;
import jtransc.annotation.haxe.HaxeMethodBody;

public final class Array {
    private Array() {
    }

    @HaxeMethodBody(value="return new HaxeBoolArray(p0);")
    private static native Object newBoolInstance(int var0) throws NegativeArraySizeException;

    @HaxeMethodBody(value="return new HaxeByteArray(p0);")
    private static native Object newByteInstance(int var0) throws NegativeArraySizeException;

    @HaxeMethodBody(value="return new HaxeCharArray(p0);")
    private static native Object newCharInstance(int var0) throws NegativeArraySizeException;

    @HaxeMethodBody(value="return new HaxeShortArray(p0);")
    private static native Object newShortInstance(int var0) throws NegativeArraySizeException;

    @HaxeMethodBody(value="return new HaxeIntArray(p0);")
    private static native Object newIntInstance(int var0) throws NegativeArraySizeException;

    @HaxeMethodBody(value="return new HaxeLongArray(p0);")
    private static native Object newLongInstance(int var0) throws NegativeArraySizeException;

    @HaxeMethodBody(value="return new HaxeFloatArray(p0);")
    private static native Object newFloatInstance(int var0) throws NegativeArraySizeException;

    @HaxeMethodBody(value="return new HaxeDoubleArray(p0);")
    private static native Object newDoubleInstance(int var0) throws NegativeArraySizeException;

    @HaxeMethodBody(value="return new HaxeArray(p0, p1._str);")
    private static native Object newObjectInstance(int var0, String var1) throws NegativeArraySizeException;

    public static Object newInstance(Class<?> type, int length) throws NegativeArraySizeException {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Array.newBoolInstance(length);
            }
            if (type == Byte.TYPE) {
                return Array.newByteInstance(length);
            }
            if (type == Short.TYPE) {
                return Array.newShortInstance(length);
            }
            if (type == Character.TYPE) {
                return Array.newCharInstance(length);
            }
            if (type == Integer.TYPE) {
                return Array.newIntInstance(length);
            }
            if (type == Long.TYPE) {
                return Array.newLongInstance(length);
            }
            if (type == Float.TYPE) {
                return Array.newFloatInstance(length);
            }
            if (type == Double.TYPE) {
                return Array.newDoubleInstance(length);
            }
            if (type == Void.TYPE) {
                // empty if block
            }
        } else {
            return Array.newObjectInstance(length, "[" + type.getName());
        }
        throw new RuntimeException("Invalid Array.newInstance with " + type);
    }

    public static Object newInstance(Class<?> componentType, int ... dimensions) throws IllegalArgumentException, NegativeArraySizeException {
        if (dimensions.length == 1) {
            return Array.newInstance(componentType, dimensions[0]);
        }
        throw new RuntimeException("Not implemented dynamically creating multidimensional arrays!");
    }

    @HaxeMethodBody(value="return cast(p0, HaxeBaseArray).length;")
    public static native int getLength(Object var0) throws IllegalArgumentException;

    @HaxeMethodBody(value="return cast(p0, HaxeArray).getDynamic(p1);")
    private static native Object getInstance(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static Object get(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Type elementType = Array.getArrayElementType(array.getClass());
        if (elementType == Boolean.TYPE) {
            return Array.getBoolean(array, index);
        }
        if (elementType == Byte.TYPE) {
            return Array.getByte(array, index);
        }
        if (elementType == Character.TYPE) {
            return Character.valueOf(Array.getChar(array, index));
        }
        if (elementType == Short.TYPE) {
            return Array.getShort(array, index);
        }
        if (elementType == Integer.TYPE) {
            return Array.getInt(array, index);
        }
        if (elementType == Long.TYPE) {
            return Array.getLong(array, index);
        }
        if (elementType == Float.TYPE) {
            return Float.valueOf(Array.getFloat(array, index));
        }
        if (elementType == Double.TYPE) {
            return Array.getDouble(array, index);
        }
        return Array.getInstance(array, index);
    }

    @HaxeMethodBody(value="return cast(p0, HaxeBoolArray).get(p1);")
    public static native boolean getBoolean(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="return cast(p0, HaxeByteArray).get(p1);")
    public static native byte getByte(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="return cast(p0, HaxeCharArray).get(p1);")
    public static native char getChar(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="return cast(p0, HaxeShortArray).get(p1);")
    public static native short getShort(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="return cast(p0, HaxeIntArray).get(p1);")
    public static native int getInt(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="return cast(p0, HaxeLongArray).get(p1);")
    public static native long getLong(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="return cast(p0, HaxeFloatArray).get(p1);")
    public static native float getFloat(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="return cast(p0, HaxeDoubleArray).get(p1);")
    public static native double getDouble(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="cast(p0, HaxeArray).setDynamic(p1, p2);")
    private static native void setInstance(Object var0, int var1, Object var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Type elementType = Array.getArrayElementType(array.getClass());
        if (elementType == Boolean.TYPE) {
            Array.setBoolean(array, index, (Boolean)value);
        } else if (elementType == Byte.TYPE) {
            Array.setByte(array, index, (Byte)value);
        } else if (elementType == Character.TYPE) {
            Array.setChar(array, index, ((Character)value).charValue());
        } else if (elementType == Short.TYPE) {
            Array.setShort(array, index, (Short)value);
        } else if (elementType == Integer.TYPE) {
            Array.setInt(array, index, (Integer)value);
        } else if (elementType == Long.TYPE) {
            Array.setLong(array, index, (Long)value);
        } else if (elementType == Float.TYPE) {
            Array.setFloat(array, index, ((Float)value).floatValue());
        } else if (elementType == Double.TYPE) {
            Array.setDouble(array, index, (Double)value);
        } else {
            Array.setInstance(array, index, value);
        }
    }

    @HaxeMethodBody(value="cast(p0, HaxeBoolArray).set(p1, p2);")
    public static native void setBoolean(Object var0, int var1, boolean var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="cast(p0, HaxeByteArray).set(p1, p2);")
    public static native void setByte(Object var0, int var1, byte var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="cast(p0, HaxeCharArray).set(p1, p2);")
    public static native void setChar(Object var0, int var1, char var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="cast(p0, HaxeShortArray).set(p1, p2);")
    public static native void setShort(Object var0, int var1, short var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="cast(p0, HaxeIntArray).set(p1, p2);")
    public static native void setInt(Object var0, int var1, int var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="cast(p0, HaxeLongArray).set(p1, p2);")
    public static native void setLong(Object var0, int var1, long var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="cast(p0, HaxeFloatArray).set(p1, p2);")
    public static native void setFloat(Object var0, int var1, float var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    @HaxeMethodBody(value="cast(p0, HaxeDoubleArray).set(p1, p2);")
    public static native void setDouble(Object var0, int var1, double var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    private static Type getArrayElementType(Class<?> clazz) {
        String name = clazz.getName();
        if (name.charAt(0) != '[') {
            throw new RuntimeException("Not an array");
        }
        try {
            return Class.forName(name.substring(1));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

