/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ComparableComparator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import jtransc.annotation.haxe.HaxeMethodBody;
import jtransc.internal.JTranscSorter;

public class Arrays {
    public static native int binarySearch(long[] var0, int var1, int var2, long var3);

    public static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        return JTranscSorter.binarySearch(new JTranscSorter.IntArrayWrapped(a, key), 0, a.length);
    }

    public static native int binarySearch(short[] var0, int var1, int var2, short var3);

    public static native int binarySearch(char[] var0, int var1, int var2, char var3);

    public static native int binarySearch(byte[] var0, int var1, int var2, byte var3);

    public static native int binarySearch(double[] var0, int var1, int var2, double var3);

    public static native int binarySearch(float[] var0, int var1, int var2, float var3);

    public static native int binarySearch(Object[] var0, int var1, int var2, Object var3);

    public static native <T> int binarySearch(T[] var0, int var1, int var2, T var3, Comparator<? super T> var4);

    public static native void sort(int[] var0, int var1, int var2);

    public static native void sort(long[] var0, int var1, int var2);

    public static native void sort(short[] var0, int var1, int var2);

    public static native void sort(char[] var0, int var1, int var2);

    public static native void sort(byte[] var0, int var1, int var2);

    public static native void sort(float[] var0, int var1, int var2);

    public static native void sort(double[] var0, int var1, int var2);

    public static void sort(Object[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex, ComparableComparator.INSTANCE);
    }

    @HaxeMethodBody(value="var array = cast(p0, HaxeArray);\nvar start = p1;\nvar end = p2;\nvar comparator = p3;\nvar slice = array.toArray().slice(start, end);\nhaxe.ds.ArraySort.sort(slice, function(a, b) {\n\treturn comparator.compare_Ljava_lang_Object_Ljava_lang_Object__I(cast a, cast b);\n});\nfor (n in 0 ... slice.length) {\n\tarray.set(start + n, slice[n]);\n}")
    public static native <T> void sort(T[] var0, int var1, int var2, Comparator<? super T> var3);

    public static native int deepHashCode(Object[] var0);

    public static native boolean deepEquals(Object[] var0, Object[] var1);

    static native boolean deepEquals0(Object var0, Object var1);

    public static native String deepToString(Object[] var0);

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<Object[]> newType) {
        int length = to - from;
        if (length < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] out = newType == Object[].class ? new Object[length] : (Object[])Array.newInstance(newType.getComponentType(), length);
        System.arraycopy(original, from, out, 0, Math.min(original.length - from, length));
        return out;
    }

    public static void sort(int[] a) {
        Arrays.sort(a, 0, a.length);
    }

    public static void sort(long[] a) {
        Arrays.sort(a, 0, a.length);
    }

    public static void sort(short[] a) {
        Arrays.sort(a, 0, a.length);
    }

    public static void sort(char[] a) {
        Arrays.sort(a, 0, a.length);
    }

    public static void sort(byte[] a) {
        Arrays.sort(a, 0, a.length);
    }

    public static void sort(float[] a) {
        Arrays.sort(a, 0, a.length);
    }

    public static void sort(double[] a) {
        Arrays.sort(a, 0, a.length);
    }

    public static void sort(Object[] a) {
        Arrays.sort(a, 0, a.length);
    }

    public static <T> void sort(T[] a, Comparator<? super T> c) {
        Arrays.sort(a, 0, a.length, c);
    }

    public static void parallelSort(byte[] a) {
        Arrays.sort(a);
    }

    public static void parallelSort(byte[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
    }

    public static void parallelSort(char[] a) {
        Arrays.sort(a);
    }

    public static void parallelSort(char[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
    }

    public static void parallelSort(short[] a) {
        Arrays.sort(a);
    }

    public static void parallelSort(short[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
    }

    public static void parallelSort(int[] a) {
        Arrays.sort(a);
    }

    public static void parallelSort(int[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
    }

    public static void parallelSort(long[] a) {
        Arrays.sort(a);
    }

    public static void parallelSort(long[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
    }

    public static void parallelSort(float[] a) {
        Arrays.sort(a);
    }

    public static void parallelSort(float[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
    }

    public static void parallelSort(double[] a) {
        Arrays.sort(a);
    }

    public static void parallelSort(double[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] a) {
        Arrays.sort(a);
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
    }

    public static <T> void parallelSort(T[] a, Comparator<? super T> cmp) {
        Arrays.sort(a, cmp);
    }

    public static <T> void parallelSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> cmp) {
        Arrays.sort(a, fromIndex, toIndex, cmp);
    }

    public static int binarySearch(long[] a, long key) {
        return Arrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(int[] a, int key) {
        return Arrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(short[] a, short key) {
        return Arrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(char[] a, char key) {
        return Arrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(byte[] a, byte key) {
        return Arrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(double[] a, double key) {
        return Arrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(float[] a, float key) {
        return Arrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(Object[] a, Object key) {
        return Arrays.binarySearch(a, 0, a.length, key);
    }

    public static <T> int binarySearch(T[] a, T key, Comparator<? super T> c) {
        return Arrays.binarySearch(a, 0, a.length, c);
    }

    public static boolean equals(long[] a, long[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a.length; ++n) {
            if (a[n] == a2[n]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] a, int[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a.length; ++n) {
            if (a[n] == a2[n]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] a, short[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a.length; ++n) {
            if (a[n] == a2[n]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a, char[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a.length; ++n) {
            if (a[n] == a2[n]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] a, byte[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a.length; ++n) {
            if (a[n] == a2[n]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] a, boolean[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a.length; ++n) {
            if (a[n] == a2[n]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] a, double[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a.length; ++n) {
            if (a[n] == a2[n]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] a, float[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a.length; ++n) {
            if (a[n] == a2[n]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] a, Object[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a.length; ++n) {
            if (Objects.equals(a[n], a2[n])) continue;
            return false;
        }
        return true;
    }

    public static void fill(long[] a, long val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        for (int n = fromIndex; n < toIndex; ++n) {
            a[n] = val;
        }
    }

    public static void fill(int[] a, int val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        for (int n = fromIndex; n < toIndex; ++n) {
            a[n] = val;
        }
    }

    public static void fill(short[] a, short val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        for (int n = fromIndex; n < toIndex; ++n) {
            a[n] = val;
        }
    }

    public static void fill(char[] a, char val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        for (int n = fromIndex; n < toIndex; ++n) {
            a[n] = val;
        }
    }

    public static void fill(byte[] a, byte val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        for (int n = fromIndex; n < toIndex; ++n) {
            a[n] = val;
        }
    }

    public static void fill(boolean[] a, boolean val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        for (int n = fromIndex; n < toIndex; ++n) {
            a[n] = val;
        }
    }

    public static void fill(double[] a, double val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        for (int n = fromIndex; n < toIndex; ++n) {
            a[n] = val;
        }
    }

    public static void fill(float[] a, float val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        for (int n = fromIndex; n < toIndex; ++n) {
            a[n] = val;
        }
    }

    public static void fill(Object[] a, Object val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        for (int n = fromIndex; n < toIndex; ++n) {
            a[n] = val;
        }
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        Object[] copy = new Object[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = new Object[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static short[] copyOf(short[] original, int newLength) {
        short[] copy = new short[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static long[] copyOf(long[] original, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static float[] copyOf(float[] original, int newLength) {
        float[] copy = new float[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        boolean[] copy = new boolean[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static int rangeLength(int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        return newLength;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        byte[] out = new byte[Arrays.rangeLength(from, to)];
        for (int n = 0; n < out.length; ++n) {
            out[n] = original[from + n];
        }
        return out;
    }

    public static short[] copyOfRange(short[] original, int from, int to) {
        short[] out = new short[Arrays.rangeLength(from, to)];
        for (int n = 0; n < out.length; ++n) {
            out[n] = original[from + n];
        }
        return out;
    }

    public static int[] copyOfRange(int[] original, int from, int to) {
        int[] out = new int[Arrays.rangeLength(from, to)];
        for (int n = 0; n < out.length; ++n) {
            out[n] = original[from + n];
        }
        return out;
    }

    public static long[] copyOfRange(long[] original, int from, int to) {
        long[] out = new long[Arrays.rangeLength(from, to)];
        for (int n = 0; n < out.length; ++n) {
            out[n] = original[from + n];
        }
        return out;
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        char[] out = new char[Arrays.rangeLength(from, to)];
        for (int n = 0; n < out.length; ++n) {
            out[n] = original[from + n];
        }
        return out;
    }

    public static float[] copyOfRange(float[] original, int from, int to) {
        float[] out = new float[Arrays.rangeLength(from, to)];
        for (int n = 0; n < out.length; ++n) {
            out[n] = original[from + n];
        }
        return out;
    }

    public static double[] copyOfRange(double[] original, int from, int to) {
        double[] out = new double[Arrays.rangeLength(from, to)];
        for (int n = 0; n < out.length; ++n) {
            out[n] = original[from + n];
        }
        return out;
    }

    public static boolean[] copyOfRange(boolean[] original, int from, int to) {
        boolean[] out = new boolean[Arrays.rangeLength(from, to)];
        for (int n = 0; n < out.length; ++n) {
            out[n] = original[from + n];
        }
        return out;
    }

    public static <T> List<T> asList(T ... array) {
        ArrayList<T> out = new ArrayList<T>(array.length);
        int length = array.length;
        for (T it : array) {
            out.add(it);
        }
        return out;
    }

    public static int hashCode(long[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (long e : a) {
            result = 31 * result + (int)(e ^ e >>> 32);
        }
        return result;
    }

    public static int hashCode(int[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int e : a) {
            result = 31 * result + e;
        }
        return result;
    }

    public static int hashCode(short[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (short e : a) {
            result = 31 * result + e;
        }
        return result;
    }

    public static int hashCode(char[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (char e : a) {
            result = 31 * result + e;
        }
        return result;
    }

    public static int hashCode(byte[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (byte e : a) {
            result = 31 * result + e;
        }
        return result;
    }

    public static int hashCode(boolean[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (boolean e : a) {
            result = 31 * result + (e ? 1231 : 1237);
        }
        return result;
    }

    public static int hashCode(float[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (float e : a) {
            result = 31 * result + Float.floatToIntBits(e);
        }
        return result;
    }

    public static int hashCode(double[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (double e : a) {
            long bits = Double.doubleToLongBits(e);
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    public static int hashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (Object element : a) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public static String toString(long[] a) {
        return Arrays._toString(a);
    }

    public static String toString(int[] a) {
        return Arrays._toString(a);
    }

    public static String toString(short[] a) {
        return Arrays._toString(a);
    }

    public static String toString(char[] a) {
        return Arrays._toString(a);
    }

    public static String toString(byte[] a) {
        return Arrays._toString(a);
    }

    public static String toString(boolean[] a) {
        return Arrays._toString(a);
    }

    public static String toString(float[] a) {
        return Arrays._toString(a);
    }

    public static String toString(double[] a) {
        return Arrays._toString(a);
    }

    public static String toString(Object[] a) {
        return Arrays._toString(a);
    }

    private static String _toString(Object a) {
        if (a == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int length = Array.getLength(a);
        for (int i = 0; i < length; ++i) {
            if (i >= 1) {
                b.append(", ");
            }
            b.append(Array.get(a, i));
        }
        return b.append(']').toString();
    }
}

