/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import jtransc.internal.JTranscSorter;

public class Collections {
    private static List<Object> empty = new ArrayList<Object>();
    public static final Set EMPTY_SET = new HashSet();
    public static final List EMPTY_LIST = new ArrayList();
    public static final Map EMPTY_MAP = new HashMap();

    private Collections() {
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        Collections.sort(list, JTranscSorter.getComparator(list));
    }

    public static <T> void sort(List<T> list, Comparator<? super T> c) {
        Object[] array = new Object[list.size()];
        list.toArray(array);
        Arrays.sort(array, 0, array.length, c);
        list.clear();
        for (Object o : array) {
            list.add(o);
        }
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T key) {
        JTranscSorter.ListWrapper<? extends Comparable<? super T>> listWrapper = new JTranscSorter.ListWrapper<Comparable<? super T>>(list, JTranscSorter.getComparator(list), key);
        return JTranscSorter.binarySearch(listWrapper, 0, list.size());
    }

    public static native <T> int binarySearch(List<? extends T> var0, T var1, Comparator<? super T> var2);

    public static void reverse(List<?> list) {
        int size = list.size();
        int i = 0;
        int mid = size >> 1;
        int j = size - 1;
        while (i < mid) {
            Collections.swap(list, i, j);
            ++i;
            --j;
        }
    }

    public static native void shuffle(List<?> var0);

    public static native void shuffle(List<?> var0, Random var1);

    public static void swap(List<?> list, int i, int j) {
        List<?> l = list;
        l.set(i, l.set(j, l.get(i)));
    }

    public static <T> void fill(List<? super T> list, T obj) {
        int length = list.size();
        for (int n = 0; n < length; ++n) {
            list.set(n, obj);
        }
    }

    public static native <T> void copy(List<? super T> var0, List<? extends T> var1);

    public static native <T> T min(Collection<? extends T> var0);

    public static native <T> T min(Collection<? extends T> var0, Comparator<? super T> var1);

    public static native <T> T max(Collection<? extends T> var0);

    public static native <T> T max(Collection<? extends T> var0, Comparator<? super T> var1);

    public static void rotate(List<?> list, int distance) {
        int length = list.size();
        for (int n = 0; n < length; ++n) {
            Collections.swap(list, n, (n + distance) % length);
        }
    }

    public static <T> boolean replaceAll(List<T> list, T oldVal, T newVal) {
        int length = list.size();
        int count = 0;
        for (int n = 0; n < length; ++n) {
            if (!Objects.equals(list.get(n), oldVal)) continue;
            list.set(n, newVal);
            ++count;
        }
        return count > 0;
    }

    public static native int indexOfSubList(List<?> var0, List<?> var1);

    public static native int lastIndexOfSubList(List<?> var0, List<?> var1);

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> c) {
        return c;
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> s) {
        return s;
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> s) {
        return s;
    }

    public static <T> NavigableSet<T> unmodifiableNavigableSet(NavigableSet<T> s) {
        return s;
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return list;
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> m) {
        return m;
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> m) {
        return m;
    }

    public static <K, V> NavigableMap<K, V> unmodifiableNavigableMap(NavigableMap<K, ? extends V> m) {
        return m;
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> c) {
        return c;
    }

    public static <T> Set<T> synchronizedSet(Set<T> s) {
        return s;
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> s) {
        return s;
    }

    public static <T> NavigableSet<T> synchronizedNavigableSet(NavigableSet<T> s) {
        return s;
    }

    static <T> List<T> synchronizedList(List<T> list, Object mutex) {
        return list instanceof RandomAccess ? list : list;
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> m) {
        return m;
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> m) {
        return m;
    }

    public static <K, V> NavigableMap<K, V> synchronizedNavigableMap(NavigableMap<K, V> m) {
        return m;
    }

    public static native <E> Collection<E> checkedCollection(Collection<E> var0, Class<E> var1);

    public static native <E> Queue<E> checkedQueue(Queue<E> var0, Class<E> var1);

    public static native <E> Set<E> checkedSet(Set<E> var0, Class<E> var1);

    public static native <E> SortedSet<E> checkedSortedSet(SortedSet<E> var0, Class<E> var1);

    public static native <E> NavigableSet<E> checkedNavigableSet(NavigableSet<E> var0, Class<E> var1);

    public static native <E> List<E> checkedList(List<E> var0, Class<E> var1);

    public static native <K, V> Map<K, V> checkedMap(Map<K, V> var0, Class<K> var1, Class<V> var2);

    public static native <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> var0, Class<K> var1, Class<V> var2);

    public static native <K, V> NavigableMap<K, V> checkedNavigableMap(NavigableMap<K, V> var0, Class<K> var1, Class<V> var2);

    public static <T> Iterator<T> emptyIterator() {
        return empty.iterator();
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return empty.listIterator();
    }

    public static native <T> Enumeration<T> emptyEnumeration();

    public static final <T> Set<T> emptySet() {
        return new HashSet();
    }

    public static <E> SortedSet<E> emptySortedSet() {
        return new TreeSet();
    }

    public static <E> NavigableSet<E> emptyNavigableSet() {
        return new TreeSet();
    }

    public static final <T> List<T> emptyList() {
        return new ArrayList();
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return new HashMap();
    }

    public static final <K, V> SortedMap<K, V> emptySortedMap() {
        return new TreeMap();
    }

    public static final <K, V> NavigableMap<K, V> emptyNavigableMap() {
        return new TreeMap();
    }

    public static <T> Set<T> singleton(T o) {
        HashSet<T> set = new HashSet<T>();
        set.add(o);
        return set;
    }

    static native <E> Iterator<E> singletonIterator(E var0);

    public static <T> List<T> singletonList(T o) {
        return Collections.nCopies(1, o);
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        HashMap<K, V> ts = new HashMap<K, V>(1);
        ts.put(key, value);
        return ts;
    }

    public static <T> List<T> nCopies(int count, T o) {
        ArrayList<T> ts = new ArrayList<T>(count);
        for (int n = 0; n < count; ++n) {
            ts.add(o);
        }
        return ts;
    }

    public static native <T> Comparator<T> reverseOrder();

    public static native <T> Comparator<T> reverseOrder(Comparator<T> var0);

    public static <T> Enumeration<T> enumeration(Collection<T> c) {
        final Iterator<T> iterator = c.iterator();
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T> ArrayList<T> list(Enumeration<T> e) {
        ArrayList<T> ts = new ArrayList<T>();
        while (e.hasMoreElements()) {
            ts.add(e.nextElement());
        }
        return ts;
    }

    public static int frequency(Collection<?> c, Object o) {
        int count = 0;
        for (Object o1 : c) {
            if (!Objects.equals(o1, o)) continue;
            ++count;
        }
        return count;
    }

    public static boolean disjoint(Collection<?> c1, Collection<?> c2) {
        HashSet c2set = new HashSet(c2);
        for (Object o : c1) {
            if (!c2set.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean addAll(Collection<? super T> c, T ... elements) {
        boolean out = false;
        for (T e : elements) {
            out |= c.add(e);
        }
        return out;
    }

    public static native <E> Set<E> newSetFromMap(Map<E, Boolean> var0);

    public static native <T> Queue<T> asLifoQueue(Deque<T> var0);
}

