/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jtransc.JTranscBits;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;
    private static byte[] temp = new byte[8];

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public synchronized void write(int value) throws IOException {
        this.out.write(value);
        ++this.written;
    }

    @Override
    public synchronized void write(byte[] value, int offset, int length) throws IOException {
        this.out.write(value, offset, length);
        this.written += length;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    private void _writeByte(int value) throws IOException {
        this.out.write(value);
        ++this.written;
    }

    @Override
    public final void writeBoolean(boolean value) throws IOException {
        this._writeByte(value ? 1 : 0);
    }

    @Override
    public final void writeByte(int value) throws IOException {
        this._writeByte(value);
    }

    @Override
    public final void writeShort(int value) throws IOException {
        JTranscBits.writeShort((byte[])temp, (short)((short)value));
        this.out.write(temp, 0, 2);
        this.written += 2;
    }

    @Override
    public final void writeChar(int value) throws IOException {
        JTranscBits.writeShort((byte[])temp, (short)((short)value));
        this.out.write(temp, 0, 2);
        this.written += 2;
    }

    @Override
    public final void writeInt(int value) throws IOException {
        JTranscBits.writeInt((byte[])temp, (int)value);
        this.out.write(temp, 0, 4);
        this.written += 4;
    }

    @Override
    public final void writeLong(long value) throws IOException {
        JTranscBits.writeLong((byte[])temp, (long)value);
        this.out.write(temp, 0, 8);
        this.written += 8;
    }

    @Override
    public final void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public final void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public final void writeBytes(String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            this.writeByte((byte)value.charAt(i));
        }
    }

    @Override
    public final void writeChars(String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            this.writeChar(value.charAt(i));
        }
    }

    @Override
    public final void writeUTF(String value) throws IOException {
        DataOutputStream.writeUTF(value, this);
    }

    static int writeUTF(String value, DataOutput out) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        out.write(bytes);
        return bytes.length;
    }

    public final int size() {
        return this.written;
    }
}

