/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsFloatBuffer;
import java.nio.ByteBufferAsIntBuffer;
import java.nio.ByteBufferAsShortBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

class HeapByteBuffer
extends ByteBuffer {
    HeapByteBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new byte[cap], 0);
    }

    HeapByteBuffer(byte[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapByteBuffer(byte[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    @Override
    public ByteBuffer slice() {
        return new HeapByteBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public ByteBuffer duplicate() {
        return new HeapByteBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return this;
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public byte get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public byte get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public ByteBuffer get(byte[] dst, int offset, int length) {
        HeapByteBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuffer put(byte x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public ByteBuffer put(int i, byte x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int offset, int length) {
        HeapByteBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public ByteBuffer put(ByteBuffer src) {
        if (src instanceof HeapByteBuffer) {
            if (src == this) {
                throw new IllegalArgumentException();
            }
            HeapByteBuffer sb = (HeapByteBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(sb.hb, sb.ix(sb.position()), this.hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public ByteBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    byte _get(int i) {
        return this.hb[i];
    }

    @Override
    void _put(int i, byte b) {
        this.hb[i] = b;
    }

    @Override
    public char getChar() {
        return Bits.getChar(this, this.ix(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public char getChar(int i) {
        return Bits.getChar(this, this.ix(this.checkIndex(i, 2)), this.bigEndian);
    }

    @Override
    public ByteBuffer putChar(char x) {
        Bits.putChar(this, this.ix(this.nextPutIndex(2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putChar(int i, char x) {
        Bits.putChar(this, this.ix(this.checkIndex(i, 2)), x, this.bigEndian);
        return this;
    }

    @Override
    public native CharBuffer asCharBuffer();

    @Override
    public short getShort() {
        return Bits.getShort(this, this.ix(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public short getShort(int i) {
        return Bits.getShort(this, this.ix(this.checkIndex(i, 2)), this.bigEndian);
    }

    @Override
    public ByteBuffer putShort(short x) {
        Bits.putShort(this, this.ix(this.nextPutIndex(2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putShort(int i, short x) {
        Bits.putShort(this, this.ix(this.checkIndex(i, 2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int size = this.remaining() >> 1;
        int off = this.offset + this.position();
        return new ByteBufferAsShortBuffer(this.bigEndian, this, -1, 0, size, size, off);
    }

    @Override
    public int getInt() {
        return Bits.getInt(this, this.ix(this.nextGetIndex(4)), this.bigEndian);
    }

    @Override
    public int getInt(int i) {
        return Bits.getInt(this, this.ix(this.checkIndex(i, 4)), this.bigEndian);
    }

    @Override
    public ByteBuffer putInt(int x) {
        Bits.putInt(this, this.ix(this.nextPutIndex(4)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putInt(int i, int x) {
        Bits.putInt(this, this.ix(this.checkIndex(i, 4)), x, this.bigEndian);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        int size = this.remaining() >> 2;
        int off = this.offset + this.position();
        return new ByteBufferAsIntBuffer(this.bigEndian, this, -1, 0, size, size, off);
    }

    @Override
    public long getLong() {
        return Bits.getLong(this, this.ix(this.nextGetIndex(8)), this.bigEndian);
    }

    @Override
    public long getLong(int i) {
        return Bits.getLong(this, this.ix(this.checkIndex(i, 8)), this.bigEndian);
    }

    @Override
    public ByteBuffer putLong(long x) {
        Bits.putLong(this, this.ix(this.nextPutIndex(8)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putLong(int i, long x) {
        Bits.putLong(this, this.ix(this.checkIndex(i, 8)), x, this.bigEndian);
        return this;
    }

    @Override
    public native LongBuffer asLongBuffer();

    @Override
    public float getFloat() {
        return Bits.getFloat(this, this.ix(this.nextGetIndex(4)), this.bigEndian);
    }

    @Override
    public float getFloat(int i) {
        return Bits.getFloat(this, this.ix(this.checkIndex(i, 4)), this.bigEndian);
    }

    @Override
    public ByteBuffer putFloat(float x) {
        Bits.putFloat(this, this.ix(this.nextPutIndex(4)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putFloat(int i, float x) {
        Bits.putFloat(this, this.ix(this.checkIndex(i, 4)), x, this.bigEndian);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int size = this.remaining() >> 2;
        int off = this.offset + this.position();
        return new ByteBufferAsFloatBuffer(this.bigEndian, this, -1, 0, size, size, off);
    }

    @Override
    public double getDouble() {
        return Bits.getDouble(this, this.ix(this.nextGetIndex(8)), this.bigEndian);
    }

    @Override
    public double getDouble(int i) {
        return Bits.getDouble(this, this.ix(this.checkIndex(i, 8)), this.bigEndian);
    }

    @Override
    public ByteBuffer putDouble(double x) {
        Bits.putDouble(this, this.ix(this.nextPutIndex(8)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putDouble(int i, double x) {
        Bits.putDouble(this, this.ix(this.checkIndex(i, 8)), x, this.bigEndian);
        return this;
    }

    @Override
    public native DoubleBuffer asDoubleBuffer();
}

