/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

public class ExecutorCompletionService<V>
implements CompletionService<V> {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue<Future<V>> completionQueue;

    private RunnableFuture<V> newTaskFor(Callable<V> task) {
        return this.aes != null ? this.aes.newTaskFor(task) : new FutureTask<V>(task);
    }

    private RunnableFuture<V> newTaskFor(Runnable task, V result) {
        return this.aes != null ? this.aes.newTaskFor(task, result) : new FutureTask<V>(task, result);
    }

    public ExecutorCompletionService(Executor executor) {
        Objects.requireNonNull(executor);
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = new LinkedBlockingQueue<Future<V>>();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue<Future<V>> completionQueue) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(completionQueue);
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = completionQueue;
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        Objects.requireNonNull(task);
        RunnableFuture<V> f = this.newTaskFor(task);
        this.executor.execute(new QueueingFuture(f));
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        Objects.requireNonNull(task);
        RunnableFuture<V> f = this.newTaskFor(task, result);
        this.executor.execute(new QueueingFuture(f));
        return f;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    private class QueueingFuture
    extends FutureTask<Void> {
        private final Future<V> task;

        QueueingFuture(RunnableFuture<V> task) {
            super(task, null);
            this.task = task;
        }

        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this.task);
        }
    }
}

