/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.ZipEntry;
import jtransc.annotation.JTranscInline;
import jtransc.annotation.haxe.HaxeMethodBody;
import jtransc.internal.Inflater;

public class ZipFile
implements Closeable {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private File file;
    private int mode;
    private Charset charset;
    private RandomAccessFile dis;
    private String comment = null;
    private ArrayList<ZipEntry> entries = new ArrayList();
    private HashMap<String, ZipEntry> entriesByName = new HashMap();
    private HashMap<String, ZipExtra> extrasByName = new HashMap();
    private static final int METHOD_STORED = 0;
    private static final int METHOD_DEFLATED = 8;
    private static final int FLAG_Encrypted = 1;
    private static final int FLAG_CompressionFlagBit1 = 2;
    private static final int FLAG_CompressionFlagBit2 = 4;
    private static final int FLAG_DescriptorUsedMask = 8;
    private static final int FLAG_Reserved1 = 16;
    private static final int FLAG_Reserved2 = 32;
    private static final int FLAG_StrongEncrypted = 64;
    private static final int FLAG_CurrentlyUnused1 = 128;
    private static final int FLAG_CurrentlyUnused2 = 256;
    private static final int FLAG_CurrentlyUnused3 = 512;
    private static final int FLAG_CurrentlyUnused4 = 1024;
    private static final int FLAG_Utf8 = 2048;
    private static final int FLAG_ReservedPKWARE1 = 4096;
    private static final int FLAG_CDEncrypted = 8192;
    private static final int FLAG_ReservedPKWARE2 = 16384;
    private static final int FLAG_ReservedPKWARE3 = 32768;

    public ZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    public ZipFile(File file, int mode) throws IOException {
        this(file, mode, Charset.forName("UTF-8"));
    }

    public ZipFile(File file) throws IOException {
        this(file, 1);
    }

    public ZipFile(String name, Charset charset) throws IOException {
        this(new File(name), 1, charset);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    public ZipFile(File file, int mode, Charset charset) throws IOException {
        this.file = file;
        this.mode = mode;
        this.charset = charset;
        this.dis = new RandomAccessFile(file, "r");
        this.openZip(file);
    }

    private boolean hasMore() throws IOException {
        return this.dis.getFilePointer() < this.dis.length();
    }

    private short readShort() throws IOException {
        return Short.reverseBytes(this.dis.readShort());
    }

    private int readUnsignedShort() throws IOException {
        return Short.reverseBytes(this.dis.readShort()) & 0xFFFF;
    }

    private int readInt() throws IOException {
        return Integer.reverseBytes(this.dis.readInt());
    }

    private byte[] readBytes(int count) throws IOException {
        byte[] out = new byte[count];
        this.dis.read(out);
        return out;
    }

    private String readString(int count) throws IOException {
        if (count == 0) {
            return null;
        }
        return new String(this.readBytes(count), "UTF-8");
    }

    private static long dosToJavaTime(int dtime) {
        return new Date((dtime >>> 25 & 0x7F) + 80, (dtime >>> 21 & 0xF) - 1, dtime >>> 16 & 0x1F, dtime >>> 11 & 0x1F, dtime >>> 5 & 0x3F, dtime << 1 & 0x3E).getTime();
    }

    private boolean readUntil32bit(int expectedValue) throws IOException {
        expectedValue = Integer.reverseBytes(expectedValue);
        int value = 0;
        while (this.hasMore()) {
            value <<= 8;
            if ((value |= this.dis.readUnsignedByte() & 0xFF) != expectedValue) continue;
            return true;
        }
        return false;
    }

    private void openZip(File file) throws IOException {
        int chunkCount = 0;
        String defaultEncoding = "utf-8";
        while (this.hasMore()) {
            int MAGIC = this.readUnsignedShort();
            if (MAGIC != 19280) {
                throw new RuntimeException(String.format("Not a ZIP file (%s). Magic found: %04X at offset %d, chunks:%d", file.getAbsolutePath(), MAGIC, this.dis.getFilePointer(), chunkCount));
            }
            ++chunkCount;
            switch (this.readUnsignedShort()) {
                case 513: {
                    int version = this.readUnsignedShort();
                    int minVer = this.readUnsignedShort();
                    int flags = this.readUnsignedShort();
                    int compressionMethod = this.readUnsignedShort();
                    int lastModDateTime = this.readInt();
                    int crc32 = this.readInt();
                    int compressedSize = this.readInt();
                    int uncompressedSize = this.readInt();
                    int fileNameLength = this.readUnsignedShort();
                    int extraLength = this.readUnsignedShort();
                    int fileCommentLength = this.readUnsignedShort();
                    int diskStart = this.readUnsignedShort();
                    int internalAttributes = this.readUnsignedShort();
                    int externalAttributes = this.readInt();
                    int relativeOffsetOfLocalFileHeader = this.readInt();
                    String fileName = this.readString(fileNameLength);
                    byte[] extraBytes = this.readBytes(extraLength);
                    String fileComment = this.readString(extraLength);
                    ZipEntry entry = new ZipEntry();
                    entry.name = fileName;
                    entry.csize = compressedSize;
                    entry.size = uncompressedSize;
                    entry.crc = crc32;
                    entry.extra = extraBytes;
                    entry.method = compressionMethod;
                    entry.flag = flags;
                    entry.comment = fileComment;
                    this.entries.add(entry);
                    this.entriesByName.put(entry.getName(), entry);
                    break;
                }
                case 1027: {
                    int minVer = this.readUnsignedShort();
                    int flags = this.readUnsignedShort();
                    int compressionMethod = this.readUnsignedShort();
                    int lastModTime = this.readUnsignedShort();
                    int lastModDate = this.readUnsignedShort();
                    int crc32 = this.readInt();
                    int compressedSize = this.readInt();
                    int uncompressedSize = this.readInt();
                    int fileNameLength = this.readUnsignedShort();
                    int extraLength = this.readUnsignedShort();
                    String fileName = this.readString(fileNameLength);
                    byte[] extraBytes = this.readBytes(extraLength);
                    if (compressedSize == 0 && (flags & 8) != 0) {
                        if (!this.readUntil32bit(134695760)) {
                            throw new IOException("Can't find descriptor");
                        }
                        crc32 = this.readInt();
                        compressedSize = this.readInt();
                        uncompressedSize = this.readInt();
                    }
                    long dataPos = this.dis.getFilePointer();
                    this.dis.skipBytes(compressedSize);
                    ZipExtra extra = new ZipExtra();
                    extra.offset = dataPos;
                    this.extrasByName.put(fileName, extra);
                    break;
                }
                case 1541: {
                    int numberOfThisDisk = this.readUnsignedShort();
                    int diskCentralDirectory = this.readUnsignedShort();
                    int centralDirectoryRecordCount = this.readUnsignedShort();
                    int totalNumberOfCentralDirectoryRecords = this.readUnsignedShort();
                    int sizeOfCentralDirectoryBytes = this.readInt();
                    int offsetOfStartOfCentralDirectoryRelativeToStartOfArchive = this.readInt();
                    int commentLength = this.readUnsignedShort();
                    byte[] comment = this.readBytes(commentLength);
                    this.comment = commentLength > 0 ? new String(comment, "UTF-8") : null;
                    break;
                }
                case 2055: {
                    int crc32 = this.readInt();
                    int compressedSize = this.readInt();
                    int uncompressedSize = this.readInt();
                }
            }
        }
    }

    public String getComment() {
        return this.comment;
    }

    public ZipEntry getEntry(String name) {
        return this.entriesByName.get(name);
    }

    private byte[] getCompressedBytes(ZipEntry entry) throws IOException {
        ZipExtra extra = this.extrasByName.get(entry.getName());
        byte[] compressedData = new byte[(int)entry.csize];
        this.dis.seek(extra.offset);
        this.dis.read(compressedData);
        return compressedData;
    }

    private InputStream getCompressedInputStream(ZipEntry entry) throws IOException {
        return new ByteArrayInputStream(this.getCompressedBytes(entry));
    }

    @HaxeMethodBody(value="#if sys\nvar u = new haxe.zip.Uncompress(-15);\nvar src = p0.getBytes();\nvar dst = haxe.io.Bytes.alloc(p1);\nu.execute(src, 0, dst, 0);\nu.close();\nreturn HaxeByteArray.fromBytes(dst);\n#else\nreturn null;\n#end\n")
    private static native byte[] nativeDeflate(byte[] var0, int var1);

    @HaxeMethodBody(value="#if sys return true; #else return false; #end")
    @JTranscInline
    private static native boolean hasNativeDeflate();

    private static byte[] deflate(byte[] data, int outputSize) throws IOException, DataFormatException {
        if (ZipFile.hasNativeDeflate()) {
            return ZipFile.nativeDeflate(data, outputSize);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(outputSize);
        Inflater inflater = new Inflater(bis, bos);
        return bos.toByteArray();
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        try {
            switch (entry.method) {
                case 0: {
                    return this.getCompressedInputStream(entry);
                }
                case 8: {
                    return new ByteArrayInputStream(ZipFile.deflate(this.getCompressedBytes(entry), (int)entry.size));
                }
            }
        }
        catch (DataFormatException dfe) {
            throw new IOException(dfe);
        }
        throw new RuntimeException("Not supported method " + entry.method + "!");
    }

    public String getName() {
        return this.file.getAbsolutePath();
    }

    public Enumeration<? extends ZipEntry> entries() {
        return new Vector<ZipEntry>(this.entries).elements();
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public void close() throws IOException {
        this.dis.close();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private class ZipExtra {
        long offset;

        private ZipExtra() {
        }
    }
}

