/*
 * Decompiled with CFR 0.152.
 */
package jtransc.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;

public final class Inflater {
    private InputStream input;
    private OutputStream output;
    private static final int INPUT_BUFFER_SIZE = 16384;
    private byte[] inputBuffer;
    private int inputBufferFilled;
    private int inputBufferIndex;
    private long inputNextBits;
    private int inputNextBitsLength;
    private static final int DICTIONARY_SIZE = 32768;
    private static final int DICTIONARY_SIZE_MASK = Short.MAX_VALUE;
    private byte[] dictionary;
    private int dictionaryIndex;
    private static final int OUTPUT_BUFFER_SIZE = 65536;
    private byte[] tempOutputBuffer;
    private long outputLength;
    private int outputCrc32;
    private static final int CODE_TABLE_BITS = 9;
    private static final int[] CODE_LENGTH_CODE_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final short[] FIXED_LITERAL_LENGTH_CODE_TREE;
    private static final short[] FIXED_DISTANCE_CODE_TREE;
    private static final int[] CRC32_XOR_TABLE;

    public Inflater(InputStream in, OutputStream out) throws IOException, DataFormatException {
        if (in == null || out == null) {
            throw new NullPointerException();
        }
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream needs to be markable");
        }
        this.input = in;
        this.output = out;
        this.inputBuffer = new byte[16384];
        this.inputBufferFilled = 0;
        this.inputBufferIndex = 0;
        this.inputNextBits = 0L;
        this.inputNextBitsLength = 0;
        assert (Integer.bitCount(32768) == 1);
        this.dictionary = new byte[32768];
        this.dictionaryIndex = 0;
        this.tempOutputBuffer = new byte[65536];
        this.outputLength = 0L;
        this.outputCrc32 = -1;
        this.decompressStream();
    }

    public long getLength() {
        return this.outputLength;
    }

    public int getCrc32() {
        return ~this.outputCrc32;
    }

    private void decompressStream() throws IOException, DataFormatException {
        boolean isFinal;
        do {
            isFinal = this.readBits(1) == 1;
            int type = this.readBits(2);
            if (type == 0) {
                this.decompressUncompressedBlock();
                continue;
            }
            if (type == 1) {
                this.decompressHuffmanBlock(FIXED_LITERAL_LENGTH_CODE_TREE, FIXED_DISTANCE_CODE_TREE);
                continue;
            }
            if (type == 2) {
                short[][] codeTrees = this.decodeHuffmanCodes();
                this.decompressHuffmanBlock(codeTrees[0], codeTrees[1]);
                continue;
            }
            throw new DataFormatException("Invalid block type");
        } while (!isFinal);
        this.input.reset();
        int skip = this.inputBufferIndex - this.inputNextBitsLength / 8;
        assert (skip >= 0);
        while (skip > 0) {
            long n = this.input.skip(skip);
            if (n <= 0L) {
                throw new EOFException();
            }
            skip = (int)((long)skip - n);
        }
        this.input = null;
        this.output = null;
        this.inputBuffer = null;
        this.inputBufferFilled = 0;
        this.inputBufferIndex = 0;
        this.inputNextBits = 0L;
        this.inputNextBitsLength = 0;
        this.dictionary = null;
        this.dictionaryIndex = 0;
        this.tempOutputBuffer = null;
    }

    private void decompressUncompressedBlock() throws IOException, DataFormatException {
        int n;
        byte[] buf = this.tempOutputBuffer;
        this.readBytes(buf, 4);
        int len = buf[0] & 0xFF | (buf[1] & 0xFF) << 8;
        int nlen = buf[2] & 0xFF | (buf[3] & 0xFF) << 8;
        if ((len ^ 0xFFFF) != nlen) {
            throw new DataFormatException("Invalid length in uncompressed block");
        }
        assert (0 <= len && len <= 65535);
        assert (0 <= this.dictionaryIndex && this.dictionaryIndex < 32768);
        this.readBytes(buf, len);
        for (int off = 0; off < len; off += n) {
            n = Math.min(32768 - this.dictionaryIndex, len - off);
            System.arraycopy(buf, off, this.dictionary, this.dictionaryIndex, n);
            this.dictionaryIndex = this.dictionaryIndex + n & Short.MAX_VALUE;
        }
        this.writeOutputBuffer(len);
    }

    /*
     * Unable to fully structure code
     */
    private void decompressHuffmanBlock(short[] litLenCodeTree, short[] distCodeTree) throws IOException, DataFormatException {
        if (!Inflater.$assertionsDisabled && litLenCodeTree == null) {
            throw new AssertionError();
        }
        buf = this.tempOutputBuffer;
        bufIndex = 0;
        dict = this.dictionary;
        dictIndex = this.dictionaryIndex;
        if (!(Inflater.$assertionsDisabled || 0 <= dictIndex && dictIndex < 32768)) {
            throw new AssertionError();
        }
        litLenCodeTable = Inflater.codeTreeToCodeTable(litLenCodeTree);
        block0: while (true) {
            bits = (int)this.inputNextBits;
            count = this.inputNextBitsLength;
            node = 0;
            if (count < 9) ** GOTO lbl-1000
            temp = litLenCodeTable[bits & 511];
            if (!Inflater.$assertionsDisabled && temp < 0) {
                throw new AssertionError();
            }
            consumed = temp >>> 11;
            bits >>>= consumed;
            count -= consumed;
            node = temp << 21 >> 21;
            if (node < 0) {
                this.inputNextBits >>>= this.inputNextBitsLength - count;
                this.inputNextBitsLength = count;
            } else lbl-1000:
            // 3 sources

            {
                while (count > 0) {
                    node = litLenCodeTree[node + (bits & 1)];
                    bits >>>= 1;
                    --count;
                    if (node >= 0) continue;
                }
                this.inputNextBits >>>= this.inputNextBitsLength - count;
                this.inputNextBitsLength = count;
                while (node >= 0) {
                    node = litLenCodeTree[node + this.readBits(1)];
                }
            }
            sym = ~node;
            if (!(Inflater.$assertionsDisabled || 0 <= sym && sym <= 285)) {
                throw new AssertionError();
            }
            if (sym < 256) {
                dict[dictIndex] = buf[bufIndex] = (byte)sym;
                dictIndex = dictIndex + 1 & 32767;
                if (++bufIndex != 65536) continue;
                this.dictionaryIndex = dictIndex;
                this.writeOutputBuffer(bufIndex);
                bufIndex = 0;
                continue;
            }
            if (sym <= 256) break;
            len = this.decodeRunLength(sym);
            if (!(Inflater.$assertionsDisabled || 3 <= len && len <= 258)) {
                throw new AssertionError();
            }
            if (distCodeTree == null) {
                throw new DataFormatException("Length symbol encountered with empty distance code");
            }
            distSym = this.decodeSymbol(distCodeTree);
            if (!(Inflater.$assertionsDisabled || 0 <= distSym && distSym <= 29)) {
                throw new AssertionError();
            }
            dist = this.decodeDistance(distSym);
            if (!(Inflater.$assertionsDisabled || 1 <= dist && dist <= 32768)) {
                throw new AssertionError();
            }
            if (bufIndex + len > 65536) {
                this.dictionaryIndex = dictIndex;
                this.writeOutputBuffer(bufIndex);
                bufIndex = 0;
            }
            dictReadIndex = dictIndex - dist & 32767;
            bufEnd = bufIndex + len;
            while (true) {
                if (bufIndex < bufEnd) ** break;
                continue block0;
                dict[dictIndex] = buf[bufIndex] = dict[dictReadIndex];
                dictIndex = dictIndex + 1 & 32767;
                dictReadIndex = dictReadIndex + 1 & 32767;
                ++bufIndex;
            }
            break;
        }
        this.dictionaryIndex = dictIndex;
        this.writeOutputBuffer(bufIndex);
    }

    private short[][] decodeHuffmanCodes() throws IOException, DataFormatException {
        short[] distCodeTree;
        int numLitLenCodes = this.readBits(5) + 257;
        int numDistCodes = this.readBits(5) + 1;
        int numCodeLenCodes = this.readBits(4) + 4;
        byte[] codeLenCodeLen = new byte[19];
        for (int i = 0; i < numCodeLenCodes; ++i) {
            codeLenCodeLen[Inflater.CODE_LENGTH_CODE_ORDER[i]] = (byte)this.readBits(3);
        }
        short[] codeLenCodeTree = Inflater.codeLengthsToCodeTree(codeLenCodeLen);
        byte[] codeLens = new byte[numLitLenCodes + numDistCodes];
        int runVal = -1;
        int runLen = 0;
        int i = 0;
        while (i < codeLens.length) {
            if (runLen > 0) {
                assert (runVal != -1);
                codeLens[i] = runVal;
                --runLen;
                ++i;
                continue;
            }
            int sym = this.decodeSymbol(codeLenCodeTree);
            assert (0 <= sym && sym <= 18);
            if (sym < 16) {
                codeLens[i] = (byte)sym;
                runVal = codeLens[i];
                ++i;
                continue;
            }
            if (sym == 16) {
                if (runVal == -1) {
                    throw new DataFormatException("No code length value to copy");
                }
                runLen = this.readBits(2) + 3;
                continue;
            }
            if (sym == 17) {
                runVal = 0;
                runLen = this.readBits(3) + 3;
                continue;
            }
            runVal = 0;
            runLen = this.readBits(7) + 11;
        }
        if (runLen > 0) {
            throw new DataFormatException("Run exceeds number of codes");
        }
        byte[] litLenCodeLen = Arrays.copyOf(codeLens, numLitLenCodes);
        short[] litLenCodeTree = Inflater.codeLengthsToCodeTree(litLenCodeLen);
        byte[] distCodeLen = Arrays.copyOfRange(codeLens, numLitLenCodes, codeLens.length);
        if (distCodeLen.length == 1 && distCodeLen[0] == 0) {
            distCodeTree = null;
        } else {
            int oneCount = 0;
            int otherPositiveCount = 0;
            for (byte x : distCodeLen) {
                if (x == 1) {
                    ++oneCount;
                    continue;
                }
                if (x <= 1) continue;
                ++otherPositiveCount;
            }
            if (oneCount == 1 && otherPositiveCount == 0) {
                distCodeLen = Arrays.copyOf(distCodeLen, 32);
                distCodeLen[31] = 1;
            }
            distCodeTree = Inflater.codeLengthsToCodeTree(distCodeLen);
        }
        return new short[][]{litLenCodeTree, distCodeTree};
    }

    private int decodeSymbol(short[] codeTree) throws IOException {
        int node = 0;
        int count = this.inputNextBitsLength;
        if (count > 0) {
            int bits = (int)this.inputNextBits;
            do {
                node = codeTree[node + (bits & 1)];
                bits >>>= 1;
            } while (--count > 0 && node >= 0);
            this.inputNextBits >>>= this.inputNextBitsLength - count;
            this.inputNextBitsLength = count;
        }
        while (node >= 0) {
            node = codeTree[node + this.readBits(1)];
        }
        return ~node;
    }

    private int decodeRunLength(int sym) throws IOException, DataFormatException {
        assert (257 <= sym && sym <= 287);
        if (sym <= 264) {
            return sym - 254;
        }
        if (sym <= 284) {
            int n = sym - 261 >>> 2;
            return ((sym - 1 & 3 | 4) << n) + 3 + this.readBits(n);
        }
        if (sym == 285) {
            return 258;
        }
        throw new DataFormatException("Invalid run length symbol: " + sym);
    }

    private int decodeDistance(int sym) throws IOException, DataFormatException {
        assert (0 <= sym && sym < 32);
        if (sym <= 3) {
            return sym + 1;
        }
        if (sym <= 29) {
            int n = (sym >>> 1) - 1;
            return ((sym & 1 | 2) << n) + 1 + this.readBits(n);
        }
        throw new DataFormatException("Invalid distance symbol: " + sym);
    }

    private static short[] codeLengthsToCodeTree(byte[] codeLengths) throws DataFormatException {
        int UNUSED = 28672;
        int OPENING = 28673;
        int OPEN = 28674;
        short[] result = new short[(codeLengths.length - 1) * 2];
        Arrays.fill(result, (short)28672);
        result[0] = 28674;
        result[1] = 28674;
        int allocated = 2;
        int maxCodeLen = 0;
        for (byte x : codeLengths) {
            maxCodeLen = Math.max(x, maxCodeLen);
        }
        assert (maxCodeLen <= 15);
        for (int curCodeLen = 1; curCodeLen <= maxCodeLen; ++curCodeLen) {
            int resultIndex = 0;
            int symbol = 0;
            while (true) {
                if (symbol < codeLengths.length && codeLengths[symbol] != curCodeLen) {
                    assert (codeLengths[symbol] >= 0);
                    ++symbol;
                    continue;
                }
                if (symbol == codeLengths.length) break;
                while (resultIndex < result.length && result[resultIndex] != 28674) {
                    ++resultIndex;
                }
                if (resultIndex == result.length) {
                    throw new DataFormatException("This canonical code does not represent a Huffman code tree");
                }
                result[resultIndex] = (short)(~symbol);
                ++resultIndex;
                ++symbol;
            }
            while (resultIndex < result.length) {
                if (result[resultIndex] == 28674) {
                    assert (allocated + 2 <= result.length);
                    result[resultIndex] = (short)allocated;
                    result[allocated + 0] = 28673;
                    result[allocated + 1] = 28673;
                    allocated += 2;
                }
                ++resultIndex;
            }
            for (resultIndex = 0; resultIndex < result.length; ++resultIndex) {
                if (result[resultIndex] != 28673) continue;
                result[resultIndex] = 28674;
            }
        }
        for (int i = 0; i < allocated; ++i) {
            if (result[i] != 28674) continue;
            throw new DataFormatException("This canonical code does not represent a Huffman code tree");
        }
        return result;
    }

    private static short[] codeTreeToCodeTable(short[] codeTree) {
        short[] result = new short[512];
        for (int i = 0; i < result.length; ++i) {
            int node = 0;
            int consumed = 0;
            while ((node = codeTree[node + (i >>> consumed & 1)]) >= 0 && ++consumed < 9) {
            }
            assert (1 <= consumed && consumed <= 15);
            assert (-1024 <= node && node <= 1023);
            result[i] = (short)(consumed << 11 | node & 0x7FF);
            assert (result[i] >= 0);
        }
        return result;
    }

    private int readBits(int n) throws IOException {
        assert (1 <= n && n <= 13);
        assert (0 <= this.inputNextBitsLength && this.inputNextBitsLength <= 63);
        assert (this.inputNextBits >>> this.inputNextBitsLength == 0L);
        while (this.inputNextBitsLength < n) {
            long temp;
            int i = this.inputBufferIndex;
            byte[] buf = this.inputBuffer;
            int bytes = Math.min(64 - this.inputNextBitsLength >>> 3, this.inputBufferFilled - i);
            if (bytes == 8) {
                temp = (long)(buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | buf[i + 3] << 24) & 0xFFFFFFFFL | (long)(buf[i + 4] & 0xFF | (buf[i + 5] & 0xFF) << 8 | (buf[i + 6] & 0xFF) << 16 | buf[i + 7] << 24) << 32;
            } else if (bytes == 7) {
                temp = (long)(buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | buf[i + 3] << 24) & 0xFFFFFFFFL | (long)(buf[i + 4] & 0xFF | (buf[i + 5] & 0xFF) << 8 | (buf[i + 6] & 0xFF) << 16) << 32;
            } else if (bytes == 6) {
                temp = (long)(buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | buf[i + 3] << 24) & 0xFFFFFFFFL | (long)(buf[i + 4] & 0xFF | (buf[i + 5] & 0xFF) << 8) << 32;
            } else if (bytes > 0) {
                temp = 0L;
                for (int j = 0; j < bytes; ++j) {
                    temp |= ((long)buf[i] & 0xFFL) << (j << 3);
                    ++i;
                }
            } else {
                if (bytes == 0) {
                    this.fillInputBuffer();
                    continue;
                }
                if (bytes == -1 && this.inputBufferFilled == -1) {
                    throw new EOFException();
                }
                throw new AssertionError();
            }
            this.inputNextBits |= temp << this.inputNextBitsLength;
            this.inputNextBitsLength += bytes << 3;
            this.inputBufferIndex += bytes;
        }
        int result = (int)this.inputNextBits & (1 << n) - 1;
        this.inputNextBits >>>= n;
        this.inputNextBitsLength -= n;
        assert (0 <= this.inputNextBitsLength && this.inputNextBitsLength <= 63);
        assert (this.inputNextBits >>> this.inputNextBitsLength == 0L);
        return result;
    }

    private void readBytes(byte[] b, int len) throws IOException {
        int off;
        assert (b.length >= len);
        assert (0 <= this.inputNextBitsLength && this.inputNextBitsLength <= 63);
        assert (this.inputNextBits >>> this.inputNextBitsLength == 0L);
        int n = this.inputNextBitsLength & 7;
        this.inputNextBits >>>= n;
        this.inputNextBitsLength -= n;
        assert (this.inputNextBitsLength % 8 == 0);
        for (off = 0; this.inputNextBitsLength >= 8 && off < len; ++off) {
            b[off] = (byte)this.inputNextBits;
            this.inputNextBits >>>= 8;
            this.inputNextBitsLength -= 8;
        }
        assert (0 <= this.inputBufferIndex && this.inputBufferIndex <= Math.max(this.inputBufferFilled, 0));
        while (off < len) {
            if (this.inputBufferIndex >= this.inputBufferFilled) {
                this.fillInputBuffer();
            }
            if (this.inputBufferFilled == -1) {
                throw new EOFException();
            }
            n = Math.min(len - off, this.inputBufferFilled - this.inputBufferIndex);
            System.arraycopy(this.inputBuffer, this.inputBufferIndex, b, off, n);
            this.inputBufferIndex += n;
            off += n;
        }
    }

    private void fillInputBuffer() throws IOException {
        if (this.inputBufferFilled == -1) {
            throw new EOFException();
        }
        if (this.inputBufferIndex < this.inputBufferFilled) {
            throw new AssertionError("Input buffer not fully consumed yet");
        }
        this.input.mark(this.inputBuffer.length);
        this.inputBufferFilled = this.input.read(this.inputBuffer);
        this.inputBufferIndex = 0;
    }

    private void writeOutputBuffer(int len) throws IOException {
        byte[] b = this.tempOutputBuffer;
        this.output.write(b, 0, len);
        this.outputLength += (long)len;
        assert ((this.outputLength & 0x7FFFL) == (long)this.dictionaryIndex);
        int crc = this.outputCrc32;
        for (int i = 0; i < len; ++i) {
            crc = crc >>> 8 ^ CRC32_XOR_TABLE[(crc ^ b[i]) & 0xFF];
        }
        this.outputCrc32 = crc;
    }

    static {
        try {
            byte[] llcodelens = new byte[288];
            Arrays.fill(llcodelens, 0, 144, (byte)8);
            Arrays.fill(llcodelens, 144, 256, (byte)9);
            Arrays.fill(llcodelens, 256, 280, (byte)7);
            Arrays.fill(llcodelens, 280, 288, (byte)8);
            FIXED_LITERAL_LENGTH_CODE_TREE = Inflater.codeLengthsToCodeTree(llcodelens);
            byte[] distcodelens = new byte[32];
            Arrays.fill(distcodelens, (byte)5);
            FIXED_DISTANCE_CODE_TREE = Inflater.codeLengthsToCodeTree(distcodelens);
        }
        catch (DataFormatException e) {
            throw new AssertionError(e);
        }
        CRC32_XOR_TABLE = new int[256];
        int POLYNOMIAL = -306674912;
        for (int i = 0; i < 256; ++i) {
            int reg = i;
            for (int j = 0; j < 8; ++j) {
                reg = reg >>> 1 ^ (reg & 1) * -306674912;
            }
            Inflater.CRC32_XOR_TABLE[i] = reg;
        }
        try {
            assert (false);
        }
        catch (AssertionError e) {
            System.err.println("Assertions are enabled :)");
        }
    }
}

