/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class InputStreamReader
extends Reader {
    private InputStream in;
    private Charset cs;

    public InputStreamReader(InputStream in) {
        this(in, Charset.forName("UTF-8"));
    }

    public InputStreamReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
        this(in, Charset.forName(charsetName));
    }

    public InputStreamReader(InputStream in, Charset cs) {
        super(in);
        this.in = in;
        this.cs = cs;
    }

    public InputStreamReader(InputStream in, CharsetDecoder dec) {
        super(in);
        this.in = in;
        this.cs = dec.charset();
    }

    public String getEncoding() {
        return this.cs.displayName();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        for (int n = 0; n < length; ++n) {
            int ch = this.read();
            if (ch < 0) {
                return n == 0 ? -1 : n;
            }
            cbuf[offset + n] = (char)ch;
        }
        return length;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

