/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.io.JTranscConsolePrintStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;

public class System {
    public static final InputStream in = new InputStream(){

        @Override
        public int read() throws IOException {
            throw new Error("Not implemented!");
        }
    };
    public static final PrintStream out = new JTranscConsolePrintStream(false);
    public static final PrintStream err = new JTranscConsolePrintStream(true);
    private static Properties _props;

    public static native void setIn(InputStream var0);

    public static native void setOut(PrintStream var0);

    public static native void setErr(PrintStream var0);

    @HaxeMethodBody(value="#if js return HaxeNatives.floatToLong(untyped __js__('Date.now()'));\n#elseif sys return HaxeNatives.floatToLong(Sys.time() * 1000);\n#else return HaxeNatives.floatToLong(Date.now().getTime());\n#end\n")
    public static native long currentTimeMillis();

    public static long nanoTime() {
        return System.currentTimeMillis() * 1000000L;
    }

    @HaxeMethodBody(value="HaxeNatives.arraycopy(p0, p1, p2, p3, p4);")
    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    @HaxeMethodBody(value="return p0.__ID__ | 0;")
    public static native int identityHashCode(Object var0);

    public static Properties getProperties() {
        return System.getProps();
    }

    public static void setProperties(Properties props) {
        Properties myprops = System.getProps();
        for (Map.Entry entry : props.entrySet()) {
            myprops.put(entry.getKey(), entry.getValue());
        }
    }

    public static String getProperty(String prop) {
        return System.getProps().getProperty(prop);
    }

    public static String getProperty(String key, String def) {
        return System.getProps().getProperty(key, def);
    }

    private static void _setProperty(String key, String value) {
        _props.put(key, value);
    }

    private static Properties getProps() {
        if (_props == null) {
            _props = new Properties();
            System._setProperty("os.arch", JTranscSystem.getArch());
            System._setProperty("os.name", JTranscSystem.getOS());
            System._setProperty("os.version", "0.1");
            System._setProperty("java.runtime.name", "jtransc-haxe");
            System._setProperty("java.vm.version", "1.7.0");
            System._setProperty("java.runtime.version", "1.7.0");
            System._setProperty("file.separator", JTranscSystem.fileSeparator());
            System._setProperty("line.separator", JTranscSystem.lineSeparator());
            System._setProperty("path.separator", JTranscSystem.pathSeparator());
            System._setProperty("file.encoding", "UTF-8");
            System._setProperty("java.home", "/jtransc-haxe");
            System._setProperty("java.specification.name", "jtransc-haxe");
            System._setProperty("java.specification.vendor", "jtransc");
            System._setProperty("java.specification.version", "1.7");
            System._setProperty("java.vendor", "jtransc");
            System._setProperty("java.vendor.url", "http://github.com/jtransc/jtransc");
            System._setProperty("java.vn.name", "haxe");
            System._setProperty("java.vm.specification.name", "Jtransc/Haxe JVM emulator");
            System._setProperty("java.vm.specification.vendor", "jtransc-haxe");
            System._setProperty("java.vm.specification.version", "0.1");
            System._setProperty("java.io.tmpdir", System.getenvs(new String[]{"TMPDIR", "TEMP", "TMP"}, "/tmp"));
            System._setProperty("user.home", System.getenvs(new String[]{"HOME"}, "/tmp"));
            System._setProperty("user.dir", System.getenvs(new String[]{"HOME"}, "/tmp"));
            System._setProperty("user.name", System.getenvs(new String[]{"USERNAME", "USER"}, "username"));
        }
        return _props;
    }

    public static String setProperty(String key, String value) {
        return (String)System.getProps().setProperty(key, value);
    }

    public static String clearProperty(String key) {
        String old = System.getProperty(key);
        System.getProps().remove(key);
        return old;
    }

    @HaxeMethodBody(value="var key = p0._str;\n#if sys return HaxeNatives.str(Sys.getEnv(key));\n#elseif js return HaxeNatives.str(untyped __js__(\"(typeof process != 'undefined') ? process.env[key] : null\"));\n#else return HaxeNatives.str(null);\n#end\n")
    public static native String getenv(String var0);

    private static String getenvs(String[] names, String defaultValue) {
        for (String name : names) {
            String out = System.getenv(name);
            if (out == null) continue;
            return out;
        }
        return defaultValue;
    }

    @HaxeMethodBody(value="#if sys return HaxeNatives.hashMap(Sys.environment());\n#elseif js return HaxeNatives.hashMap(untyped __js__(\"(typeof process != 'undefined') ? process.env : {}\"));\n#else return HaxeNatives.hashMap({});\n#end\n")
    public static native Map<String, String> getenv();

    @HaxeMethodBody(value="#if sys Sys.exit(p0);\n#elseif js untyped __js__(\"if (typeof process != 'undefined') process.exit(p0);\");\n#else throw 'EXIT!';\n#end\n")
    public static native void exit(int var0);

    @HaxeMethodBody(value="")
    public static native void gc();

    public static native void runFinalization();

    @Deprecated
    public static native void runFinalizersOnExit(boolean var0);

    public static void load(String filename) {
    }

    public static void loadLibrary(String libname) {
    }

    public static String mapLibraryName(String libname) {
        return libname;
    }

    public static SecurityManager getSecurityManager() {
        return null;
    }
}

