/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

class ByteBufferAsFloatBuffer
extends FloatBuffer {
    protected final ByteBuffer bb;
    protected final int offset;
    private boolean bigEndian;

    ByteBufferAsFloatBuffer(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 2, bb.remaining() >> 2);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.offset = pos;
    }

    ByteBufferAsFloatBuffer(boolean bigEndian, ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.bigEndian = bigEndian;
        this.bb = bb;
        this.offset = off;
    }

    @Override
    public FloatBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 2) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsFloatBuffer(this.bigEndian, this.bb, -1, 0, rem, rem, off);
    }

    @Override
    public FloatBuffer duplicate() {
        return new ByteBufferAsFloatBuffer(this.bigEndian, this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return this;
    }

    protected int ix(int i) {
        return (i << 2) + this.offset;
    }

    @Override
    public float get() {
        return this.get(this.nextGetIndex());
    }

    @Override
    public float get(int i) {
        return Bits.getFloat(this.bb, this.ix(this.checkIndex(i)), this.bigEndian);
    }

    @Override
    public FloatBuffer put(float x) {
        return this.put(this.nextPutIndex(), x);
    }

    @Override
    public FloatBuffer put(int i, float x) {
        Bits.putFloat(this.bb, this.ix(this.checkIndex(i)), x, this.bigEndian);
        return this;
    }

    @Override
    public FloatBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 2);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }
}

