/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Checksum;
import java.util.zip.Tables;

public class CRC32
implements Checksum {
    private int crc = 0;
    private static byte[] temp = new byte[1];

    @Override
    public void update(int b) {
        CRC32.temp[0] = (byte)b;
        this.update(temp, 0, 1);
    }

    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.crc ^= 0xFFFFFFFF;
        for (int n = 0; n < len; ++n) {
            this.crc = Tables.crc32_tab[(this.crc ^ b[off + n]) & 0xFF] ^ this.crc >>> 8;
        }
        this.crc ^= 0xFFFFFFFF;
    }

    @Override
    public void reset() {
        this.crc = 0;
    }

    @Override
    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }
}

