/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.internal;

import java.util.List;
import java.util.ListIterator;

public class GenericListIterator<T>
implements ListIterator<T> {
    private List<T> list;
    private int index = 0;

    public GenericListIterator(List<T> list, int index) {
        this.list = list;
        this.index = index;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size();
    }

    @Override
    public T next() {
        return this.list.get(this.index++);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public T previous() {
        return this.list.get(this.index - 1);
    }

    @Override
    public int nextIndex() {
        return this.index + 1;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() {
        this.list.remove(--this.index);
    }

    @Override
    public void set(T t) {
        this.list.set(this.index, t);
    }

    @Override
    public void add(T t) {
        this.list.add(this.index, t);
    }
}

