/*
 * Copyright 2016 Carlos Ballesteros Velasco
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.util;

public class Stack<E> extends Vector<E> {
	public Stack() {
	}

	public E push(E item) {
		addElement(item);
		return item;
	}

	public synchronized E pop() {
		E obj;
		int len = size();
		obj = peek();
		removeElementAt(len - 1);
		return obj;
	}

	public synchronized E peek() {
		int len = size();
		if (len == 0) throw new EmptyStackException();
		return elementAt(len - 1);
	}

	public boolean empty() {
		return size() == 0;
	}

	public synchronized int search(Object o) {
		int i = lastIndexOf(o);
		if (i >= 0) return size() - i;
		return -1;
	}
}
