/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class Throwable
implements Serializable {
    private String message;
    private Throwable cause;
    private boolean enableSuppression = false;
    private boolean writableStackTrace = false;
    private StackTraceElement[] stackTrace;

    public Throwable() {
        this.fillInStackTrace();
        this.t_init(null, null, false, false);
    }

    public Throwable(String message) {
        this.fillInStackTrace();
        this.t_init(message, null, false, false);
    }

    public Throwable(String message, Throwable cause) {
        this.fillInStackTrace();
        this.t_init(message, cause, false, false);
    }

    public Throwable(Throwable cause) {
        this.fillInStackTrace();
        this.t_init(null, cause, false, false);
    }

    protected Throwable(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        this.fillInStackTrace();
        this.t_init(message, cause, enableSuppression, writableStackTrace);
    }

    private void t_init(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        this.message = message;
        this.cause = cause;
        this.enableSuppression = enableSuppression;
        this.writableStackTrace = writableStackTrace;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocalizedMessage() {
        return this.message;
    }

    public synchronized Throwable getCause() {
        return this.cause;
    }

    public synchronized Throwable initCause(Throwable cause) {
        this.cause = cause;
        return this.cause;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.message;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        StackTraceElement[] trace;
        s.println(this);
        for (StackTraceElement traceElement : trace = this.stackTrace) {
            s.println("\tat " + traceElement);
        }
    }

    public native void printStackTrace(PrintWriter var1);

    public synchronized Throwable fillInStackTrace() {
        this.fillInStackTrace(0);
        return this;
    }

    private void fillInStackTrace(int dummy) {
        this.setStackTrace(this.getStackTraceInternal());
    }

    @HaxeMethodBody(value="return HaxeNatives.getStackTrace(1);")
    private native StackTraceElement[] getStackTraceInternal();

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.stackTrace.clone();
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public final synchronized native void addSuppressed(Throwable var1);

    public final synchronized native Throwable[] getSuppressed();
}

