/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;

public abstract class AbstractCollection<E>
implements Collection<E> {
    protected AbstractCollection() {
    }

    @Override
    @JTranscKeep
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (E obj : this) {
            if (obj == null) continue;
            h += obj.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        Collection c = (Collection)o;
        return c.size() == this.size() && this.containsAll(c);
    }

    @Override
    public boolean contains(Object o) {
        for (E i : this) {
            if (!Objects.equals(i, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    @JTranscKeep
    public Object[] toArray() {
        Object[] r = new Object[this.size()];
        int i = 0;
        for (E e : this) {
            r[i++] = e;
        }
        return r;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(o, it.next())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        HashSet set = new HashSet(this);
        for (Object item : collection) {
            if (set.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        for (E item : collection) {
            if (!this.add(item)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int modifiedCount = 0;
        for (Object i : new ArrayList(c)) {
            if (!this.remove(i)) continue;
            ++modifiedCount;
        }
        return modifiedCount > 0;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        HashSet cSet = new HashSet(c);
        int modifiedCount = 0;
        for (Object i : new ArrayList(this)) {
            if (cSet.contains(i)) continue;
            this.remove(i);
            ++modifiedCount;
        }
        return modifiedCount > 0;
    }

    @Override
    public void clear() {
        this.removeAll(this);
    }

    @HaxeMethodBody(value="return HaxeNatives.str('[' + this.{% METHOD java.util.AbstractCollection:toArray:()[Ljava/lang/Object; %}().join(', ') + ']');")
    public native String toString();
}

