/*
 * Copyright 2016 Carlos Ballesteros Velasco
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.io;

//public abstract class Reader implements Readable, Closeable {
public abstract class Reader implements Closeable {
	protected Object lock;

	protected Reader() {
		this.lock = this;
	}

	protected Reader(Object lock) {
		if (lock == null) {
			throw new NullPointerException();
		}
		this.lock = lock;
	}

    /*
    public int read(java.nio.CharBuffer target) throws IOException {
        int len = target.remaining();
        char[] cbuf = new char[len];
        int n = read(cbuf, 0, len);
        if (n > 0)
            target.put(cbuf, 0, n);
        return n;
    }
    */

	public int read() throws IOException {
		char cb[] = new char[1];
		if (read(cb, 0, 1) == -1)
			return -1;
		else
			return cb[0];
	}

	public int read(char cbuf[]) throws IOException {
		return read(cbuf, 0, cbuf.length);
	}

	abstract public int read(char cbuf[], int off, int len) throws IOException;

	private static final int maxSkipBufferSize = 8192;

	private char skipBuffer[] = null;

	public long skip(long n) throws IOException {
		if (n < 0L) throw new IllegalArgumentException("skip value is negative");
		int nn = (int) Math.min(n, maxSkipBufferSize);
		if ((skipBuffer == null) || (skipBuffer.length < nn)) skipBuffer = new char[nn];
		long r = n;
		while (r > 0) {
			int nc = read(skipBuffer, 0, (int) Math.min(r, nn));
			if (nc == -1) break;
			r -= nc;
		}
		return n - r;
	}

	public boolean ready() throws IOException {
		return false;
	}

	public boolean markSupported() {
		return false;
	}

	public void mark(int readAheadLimit) throws IOException {
		throw new IOException("mark() not supported");
	}

	public void reset() throws IOException {
		throw new IOException("reset() not supported");
	}

	abstract public void close() throws IOException;

}
