/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class OutputStreamWriter
extends Writer {
    private OutputStream os;
    private final CharsetEncoder se;
    private StringBuilder sb = new StringBuilder();

    public OutputStreamWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        this(out, Charset.forName(charsetName).newEncoder());
    }

    public OutputStreamWriter(OutputStream out) {
        this(out, Charset.forName("UTF-8").newEncoder());
    }

    public OutputStreamWriter(OutputStream out, Charset cs) {
        this(out, cs.newEncoder());
    }

    public OutputStreamWriter(OutputStream out, CharsetEncoder enc) {
        super(out);
        if (enc == null) {
            throw new NullPointerException("charset encoder");
        }
        this.os = out;
        this.se = enc;
    }

    public String getEncoding() {
        return this.se.charset().name();
    }

    void flushBuffer() throws IOException {
        ByteBuffer data = this.se.encode(CharBuffer.wrap(this.sb));
        this.os.write(data.array(), 0, data.limit());
        this.os.flush();
        this.sb.setLength(0);
    }

    private void checkBuffer() throws IOException {
        if (this.sb.length() >= 16) {
            this.flushBuffer();
        }
    }

    @Override
    public void write(int value) throws IOException {
        this.sb.append(value);
        this.checkBuffer();
    }

    @Override
    public void write(char[] value, int offset, int length) throws IOException {
        this.sb.append(value, offset, length);
        this.checkBuffer();
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.sb.append(str, off, len);
        this.checkBuffer();
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.os.close();
    }
}

