/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscSystem;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;

public class PrintStream
extends FilterOutputStream
implements Appendable,
Closeable {
    private final boolean autoFlush;
    private boolean trouble = false;
    private Charset charset;
    private static String lineSeparator = JTranscSystem.lineSeparator();
    private boolean closing = false;

    private static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    private static Charset toCharset(String csn) throws UnsupportedEncodingException {
        PrintStream.requireNonNull(csn, "charsetName");
        try {
            return Charset.forName(csn);
        }
        catch (IllegalArgumentException unused) {
            throw new UnsupportedEncodingException(csn);
        }
    }

    private PrintStream(boolean autoFlush, OutputStream out) {
        super(out);
        this.autoFlush = autoFlush;
        this.charset = Charset.defaultCharset();
    }

    private PrintStream(boolean autoFlush, OutputStream out, Charset charset) {
        super(out);
        this.autoFlush = autoFlush;
        this.charset = charset;
    }

    private PrintStream(boolean autoFlush, Charset charset, OutputStream out) throws UnsupportedEncodingException {
        this(autoFlush, out, charset);
    }

    public PrintStream(OutputStream out) {
        this(out, false);
    }

    public PrintStream(OutputStream out, boolean autoFlush) {
        this(autoFlush, PrintStream.requireNonNull(out, "Null output stream"));
    }

    public PrintStream(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        this(autoFlush, PrintStream.requireNonNull(out, "Null output stream"), PrintStream.toCharset(encoding));
    }

    public PrintStream(String fileName) throws FileNotFoundException {
        this(false, new FileOutputStream(fileName));
    }

    public PrintStream(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(false, PrintStream.toCharset(csn), new FileOutputStream(fileName));
    }

    public PrintStream(File file) throws FileNotFoundException {
        this(false, new FileOutputStream(file));
    }

    public PrintStream(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(false, PrintStream.toCharset(csn), new FileOutputStream(file));
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void flush() {
        try {
            this.ensureOpen();
            this.out.flush();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        try {
            this.out.close();
        }
        catch (IOException x) {
            this.trouble = true;
        }
        this.out = null;
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        if (this.out instanceof PrintStream) {
            PrintStream ps = (PrintStream)this.out;
            return ps.checkError();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    protected void clearError() {
        this.trouble = false;
    }

    @Override
    public void write(int value) {
        try {
            this.ensureOpen();
            this.out.write(value);
            if (value == 10 && this.autoFlush) {
                this.out.flush();
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void write(byte[] value, int offset, int length) {
        this.write(new String(value, offset, length));
    }

    private void write(char[] buf) {
        this.write(new String(buf));
    }

    private void write(String s) {
        try {
            this.ensureOpen();
            this.out.write(s.getBytes(this.charset));
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    private void newLine() {
        this.write(lineSeparator);
    }

    public void print(boolean b) {
        this.write(String.valueOf(b));
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(s);
    }

    public void print(String s) {
        this.write(s != null ? s : "null");
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println() {
        this.newLine();
    }

    public void println(boolean v) {
        this.println(String.valueOf(v));
    }

    public void println(char v) {
        this.println(String.valueOf(v));
    }

    public void println(int v) {
        this.println(String.valueOf(v));
    }

    public void println(long v) {
        this.println(String.valueOf(v));
    }

    public void println(float v) {
        this.println(String.valueOf(v));
    }

    public void println(double v) {
        this.println(String.valueOf(v));
    }

    public void println(char[] v) {
        this.println(String.valueOf(v));
    }

    public void println(String x) {
        this.print(x);
        this.newLine();
    }

    public void println(Object x) {
        this.println(String.valueOf(x));
    }

    public PrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    public PrintStream format(String format, Object ... args) {
        return this.format(Locale.getDefault(), format, args);
    }

    public PrintStream format(Locale l, String format, Object ... args) {
        this.write(String.format(l, format, args));
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.write(csq != null ? csq.toString() : "null");
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.write(c);
        return this;
    }
}

