/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class StringWriter
extends Writer {
    private StringBuffer buffer;

    public StringWriter() {
        this.buffer = new StringBuffer();
        this.lock = this.buffer;
    }

    public StringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buffer = new StringBuffer(initialSize);
        this.lock = this.buffer;
    }

    @Override
    public void write(int value) {
        this.buffer.append((char)value);
    }

    @Override
    public void write(char[] value, int offset, int length) {
        if (offset < 0 || offset > value.length || length < 0 || offset + length > value.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        this.buffer.append(value, offset, length);
    }

    @Override
    public void write(String str) {
        this.buffer.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buffer.append(str.substring(off, off + len));
    }

    @Override
    public StringWriter append(CharSequence csq) {
        this.write(csq != null ? csq.toString() : "null");
        return this;
    }

    @Override
    public StringWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public StringWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

