/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public abstract class ClassLoader {
    private ClassLoader parent;

    protected ClassLoader(ClassLoader parent) {
        this.parent = parent;
    }

    protected ClassLoader() {
        this(null);
    }

    public final ClassLoader getParent() {
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        return _ClassInternalUtils.getSystemClassLoader();
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        System.out.println("ClassLoader.loadClass('" + name + "');");
        return Class.forName(name);
    }

    protected native Class<?> loadClass(String var1, boolean var2) throws ClassNotFoundException;

    protected native Object getClassLoadingLock(String var1);

    protected native Class<?> findClass(String var1) throws ClassNotFoundException;

    @Deprecated
    protected final native Class<?> defineClass(byte[] var1, int var2, int var3) throws ClassFormatError;

    protected final native Class<?> defineClass(String var1, byte[] var2, int var3, int var4) throws ClassFormatError;

    protected final native void resolveClass(Class<?> var1);

    protected final native Class<?> findSystemClass(String var1) throws ClassNotFoundException;

    protected final native Class<?> findLoadedClass(String var1);

    protected final native void setSigners(Class<?> var1, Object[] var2);

    public native URL getResource(String var1);

    public native Enumeration<URL> getResources(String var1) throws IOException;

    protected native URL findResource(String var1);

    protected native Enumeration<URL> findResources(String var1) throws IOException;

    protected static native boolean registerAsParallelCapable();

    public static native URL getSystemResource(String var0);

    public static native Enumeration<URL> getSystemResources(String var0) throws IOException;

    public InputStream getResourceAsStream(String name) {
        try {
            return new FileInputStream(name);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static native InputStream getSystemResourceAsStream(String var0);

    protected native Package definePackage(String var1, String var2, String var3, String var4, String var5, String var6, String var7, URL var8) throws IllegalArgumentException;

    protected native Package getPackage(String var1);

    protected native Package[] getPackages();

    protected native String findLibrary(String var1);

    public native void setDefaultAssertionStatus(boolean var1);

    public native void setPackageAssertionStatus(String var1, boolean var2);

    public native void setClassAssertionStatus(String var1, boolean var2);

    public native void clearAssertionStatus();
}

