/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class Runtime {
    private static Runtime currentRuntime = new Runtime();

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    private Runtime() {
    }

    public native void exit(int var1);

    public native void addShutdownHook(Thread var1);

    public native boolean removeShutdownHook(Thread var1);

    public native void halt(int var1);

    @Deprecated
    public static native void runFinalizersOnExit(boolean var0);

    public Process exec(String command) throws IOException {
        return this.exec(command, null, null);
    }

    public Process exec(String command, String[] envp) throws IOException {
        return this.exec(command, envp, null);
    }

    public Process exec(String command, String[] envp, File dir) throws IOException {
        if (command.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return this.exec(cmdarray, envp, dir);
    }

    public Process exec(String[] cmdarray) throws IOException {
        return this.exec(cmdarray, null, null);
    }

    public Process exec(String[] cmdarray, String[] envp) throws IOException {
        return this.exec(cmdarray, envp, null);
    }

    public Process exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        return new ProcessBuilder(cmdarray).environment(envp).directory(dir).start();
    }

    public native int availableProcessors();

    public native long freeMemory();

    public native long totalMemory();

    public native long maxMemory();

    public native void gc();

    public native void runFinalization();

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);

    public native void load(String var1);

    synchronized native void load0(Class<?> var1, String var2);

    public native void loadLibrary(String var1);

    synchronized native void loadLibrary0(Class<?> var1, String var2);

    @Deprecated
    public InputStream getLocalizedInputStream(InputStream in) {
        return in;
    }

    @Deprecated
    public OutputStream getLocalizedOutputStream(OutputStream out) {
        return out;
    }
}

