/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect._InternalUtils;

@HaxeAddMembers(value={"private function _getClass() { var clazz = this.{% FIELD java.lang.reflect.Field:clazz %}._hxClass; var SI = Reflect.field(clazz, 'SI'); if (SI != null) Reflect.callMethod(clazz, SI, []); return clazz; }", "private function _getObjectOrClass(obj:Dynamic):Dynamic { return (obj != null) ? obj : _getClass(); }"})
public final class Field
extends AccessibleObject
implements Member {
    @JTranscKeep
    private Class<?> clazz;
    @JTranscKeep
    private String name;
    @JTranscKeep
    protected int modifiers;
    @JTranscKeep
    private int slot;
    @JTranscKeep
    private transient String signature;
    @JTranscKeep
    private transient String genericSignature;
    @JTranscKeep
    private byte[] annotations;
    private Type genericType;

    @Override
    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(_annotations, '[Ljava.lang.Annotation;');")
    public native Annotation[] getDeclaredAnnotations();

    private Field() {
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public Class<?> getType() {
        try {
            return Class.forName(this.signature);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Type getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.genericSignature != null ? _InternalUtils.parseType(this.genericSignature, null) : this.getType();
        }
        return this.genericType;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Field) {
            Field other = (Field)obj;
            return this.getDeclaringClass() == other.getDeclaringClass() && this.getName().equals(other.getName()) && this.getType() == other.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int mod = this.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + _InternalUtils.getTypeName(this.getType()) + " " + _InternalUtils.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = this.getType();
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                return null;
            }
            if (type == Boolean.TYPE) {
                return this.getBoolean(obj);
            }
            if (type == Byte.TYPE) {
                return this.getByte(obj);
            }
            if (type == Short.TYPE) {
                return this.getShort(obj);
            }
            if (type == Character.TYPE) {
                return Character.valueOf(this.getChar(obj));
            }
            if (type == Integer.TYPE) {
                return this.getInt(obj);
            }
            if (type == Long.TYPE) {
                return this.getLong(obj);
            }
            if (type == Float.TYPE) {
                return Float.valueOf(this.getFloat(obj));
            }
            if (type == Double.TYPE) {
                return this.getDouble(obj);
            }
            return null;
        }
        return this._getObject(obj);
    }

    @HaxeMethodBody(value="return Reflect.field(_getObjectOrClass(p0), this._internalName);")
    public native Object _getObject(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="return Reflect.field(_getObjectOrClass(p0), this._internalName);")
    public native boolean getBoolean(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="return Reflect.field(_getObjectOrClass(p0), this._internalName);")
    public native byte getByte(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="return Reflect.field(_getObjectOrClass(p0), this._internalName);")
    public native char getChar(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="return Reflect.field(_getObjectOrClass(p0), this._internalName);")
    public native short getShort(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="return Reflect.field(_getObjectOrClass(p0), this._internalName);")
    public native int getInt(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="return Reflect.field(_getObjectOrClass(p0), this._internalName);")
    public native long getLong(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="return Reflect.field(_getObjectOrClass(p0), this._internalName);")
    public native float getFloat(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="return Reflect.field(_getObjectOrClass(p0), this._internalName);")
    public native double getDouble(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="Reflect.setField(_getObjectOrClass(p0), this._internalName, p1);")
    private native void _setObject(Object var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="return HaxeNatives.str(this._internalName);")
    native String getInternalName();

    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = this.getType();
        if (type != null) {
            if (type.isPrimitive()) {
                if (type != Void.TYPE) {
                    if (type == Boolean.TYPE) {
                        this.setBoolean(obj, (Boolean)value);
                    } else if (type == Byte.TYPE) {
                        this.setByte(obj, (Byte)value);
                    } else if (type == Short.TYPE) {
                        this.setShort(obj, (Short)value);
                    } else if (type == Character.TYPE) {
                        this.setChar(obj, ((Character)value).charValue());
                    } else if (type == Integer.TYPE) {
                        this.setInt(obj, (Integer)value);
                    } else if (type == Long.TYPE) {
                        this.setLong(obj, (Long)value);
                    } else if (type == Float.TYPE) {
                        this.setFloat(obj, ((Float)value).floatValue());
                    } else if (type == Double.TYPE) {
                        this.setDouble(obj, (Double)value);
                    }
                }
            } else {
                this._setObject(obj, value);
            }
        }
    }

    @HaxeMethodBody(value="Reflect.setField(_getObjectOrClass(p0), this._internalName, p1);")
    public native void setBoolean(Object var1, boolean var2) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="Reflect.setField(_getObjectOrClass(p0), this._internalName, p1);")
    public native void setByte(Object var1, byte var2) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="Reflect.setField(_getObjectOrClass(p0), this._internalName, p1);")
    public native void setChar(Object var1, char var2) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="Reflect.setField(_getObjectOrClass(p0), this._internalName, p1);")
    public native void setShort(Object var1, short var2) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="Reflect.setField(_getObjectOrClass(p0), this._internalName, p1);")
    public native void setInt(Object var1, int var2) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="Reflect.setField(_getObjectOrClass(p0), this._internalName, p1);")
    public native void setLong(Object var1, long var2) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="Reflect.setField(_getObjectOrClass(p0), this._internalName, p1);")
    public native void setFloat(Object var1, float var2) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="Reflect.setField(_getObjectOrClass(p0), this._internalName, p1);")
    public native void setDouble(Object var1, double var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return super.getAnnotation(annotationClass);
    }
}

