/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.jtransc.JTranscBits;
import java.nio.ByteBuffer;

class Bits {
    private static int pageSize = 4096;
    private static volatile long maxMemory = 4096L;
    private static volatile long reservedMemory;
    private static volatile long totalCapacity;
    private static volatile long count;
    private static boolean memoryLimitSet;

    private Bits() {
    }

    static char getCharL(ByteBuffer bb, int bi) {
        return JTranscBits.makeChar((byte)bb._get(bi + 1), (byte)bb._get(bi));
    }

    static char getCharB(ByteBuffer bb, int bi) {
        return JTranscBits.makeChar((byte)bb._get(bi), (byte)bb._get(bi + 1));
    }

    static char getChar(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getCharB(bb, bi) : Bits.getCharL(bb, bi);
    }

    private static byte char1(char x) {
        return (byte)(x >> 8);
    }

    private static byte char0(char x) {
        return (byte)x;
    }

    static void putCharL(ByteBuffer bb, int bi, char x) {
        bb._put(bi, Bits.char0(x));
        bb._put(bi + 1, Bits.char1(x));
    }

    static void putCharB(ByteBuffer bb, int bi, char x) {
        bb._put(bi, Bits.char1(x));
        bb._put(bi + 1, Bits.char0(x));
    }

    static void putChar(ByteBuffer bb, int bi, char x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putCharB(bb, bi, x);
        } else {
            Bits.putCharL(bb, bi, x);
        }
    }

    static short getShortL(ByteBuffer bb, int bi) {
        return JTranscBits.makeShort((byte)bb._get(bi + 1), (byte)bb._get(bi));
    }

    static short getShortB(ByteBuffer bb, int bi) {
        return JTranscBits.makeShort((byte)bb._get(bi), (byte)bb._get(bi + 1));
    }

    static short getShort(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getShortB(bb, bi) : Bits.getShortL(bb, bi);
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }

    static void putShortL(ByteBuffer bb, int bi, short x) {
        bb._put(bi, Bits.short0(x));
        bb._put(bi + 1, Bits.short1(x));
    }

    static void putShortB(ByteBuffer bb, int bi, short x) {
        bb._put(bi, Bits.short1(x));
        bb._put(bi + 1, Bits.short0(x));
    }

    static void putShort(ByteBuffer bb, int bi, short x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putShortB(bb, bi, x);
        } else {
            Bits.putShortL(bb, bi, x);
        }
    }

    static int getIntL(ByteBuffer bb, int bi) {
        return JTranscBits.makeInt((byte)bb._get(bi + 3), (byte)bb._get(bi + 2), (byte)bb._get(bi + 1), (byte)bb._get(bi));
    }

    static int getIntB(ByteBuffer bb, int bi) {
        return JTranscBits.makeInt((byte)bb._get(bi), (byte)bb._get(bi + 1), (byte)bb._get(bi + 2), (byte)bb._get(bi + 3));
    }

    static int getInt(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getIntB(bb, bi) : Bits.getIntL(bb, bi);
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    static void putIntL(ByteBuffer bb, int bi, int x) {
        bb._put(bi + 3, Bits.int3(x));
        bb._put(bi + 2, Bits.int2(x));
        bb._put(bi + 1, Bits.int1(x));
        bb._put(bi, Bits.int0(x));
    }

    static void putIntB(ByteBuffer bb, int bi, int x) {
        bb._put(bi, Bits.int3(x));
        bb._put(bi + 1, Bits.int2(x));
        bb._put(bi + 2, Bits.int1(x));
        bb._put(bi + 3, Bits.int0(x));
    }

    static void putInt(ByteBuffer bb, int bi, int x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putIntB(bb, bi, x);
        } else {
            Bits.putIntL(bb, bi, x);
        }
    }

    static long getLongL(ByteBuffer bb, int bi) {
        return JTranscBits.makeLong((byte)bb._get(bi + 7), (byte)bb._get(bi + 6), (byte)bb._get(bi + 5), (byte)bb._get(bi + 4), (byte)bb._get(bi + 3), (byte)bb._get(bi + 2), (byte)bb._get(bi + 1), (byte)bb._get(bi));
    }

    static long getLongB(ByteBuffer bb, int bi) {
        return JTranscBits.makeLong((byte)bb._get(bi), (byte)bb._get(bi + 1), (byte)bb._get(bi + 2), (byte)bb._get(bi + 3), (byte)bb._get(bi + 4), (byte)bb._get(bi + 5), (byte)bb._get(bi + 6), (byte)bb._get(bi + 7));
    }

    static long getLong(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getLongB(bb, bi) : Bits.getLongL(bb, bi);
    }

    static void putLongL(ByteBuffer bb, int bi, long x) {
        bb._put(bi + 7, JTranscBits.long7((long)x));
        bb._put(bi + 6, JTranscBits.long6((long)x));
        bb._put(bi + 5, JTranscBits.long5((long)x));
        bb._put(bi + 4, JTranscBits.long4((long)x));
        bb._put(bi + 3, JTranscBits.long3((long)x));
        bb._put(bi + 2, JTranscBits.long2((long)x));
        bb._put(bi + 1, JTranscBits.long1((long)x));
        bb._put(bi + 0, JTranscBits.long0((long)x));
    }

    static void putLongB(ByteBuffer bb, int bi, long x) {
        bb._put(bi + 0, JTranscBits.long7((long)x));
        bb._put(bi + 1, JTranscBits.long6((long)x));
        bb._put(bi + 2, JTranscBits.long5((long)x));
        bb._put(bi + 3, JTranscBits.long4((long)x));
        bb._put(bi + 4, JTranscBits.long3((long)x));
        bb._put(bi + 5, JTranscBits.long2((long)x));
        bb._put(bi + 6, JTranscBits.long1((long)x));
        bb._put(bi + 7, JTranscBits.long0((long)x));
    }

    static void putLong(ByteBuffer bb, int bi, long x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putLongB(bb, bi, x);
        } else {
            Bits.putLongL(bb, bi, x);
        }
    }

    static float getFloatL(ByteBuffer bb, int bi) {
        return Float.intBitsToFloat(Bits.getIntL(bb, bi));
    }

    static float getFloatB(ByteBuffer bb, int bi) {
        return Float.intBitsToFloat(Bits.getIntB(bb, bi));
    }

    static float getFloat(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getFloatB(bb, bi) : Bits.getFloatL(bb, bi);
    }

    static void putFloatL(ByteBuffer bb, int bi, float x) {
        Bits.putIntL(bb, bi, Float.floatToRawIntBits(x));
    }

    static void putFloatB(ByteBuffer bb, int bi, float x) {
        Bits.putIntB(bb, bi, Float.floatToRawIntBits(x));
    }

    static void putFloat(ByteBuffer bb, int bi, float x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putFloatB(bb, bi, x);
        } else {
            Bits.putFloatL(bb, bi, x);
        }
    }

    static double getDoubleL(ByteBuffer bb, int bi) {
        return Double.longBitsToDouble(Bits.getLongL(bb, bi));
    }

    static double getDoubleB(ByteBuffer bb, int bi) {
        return Double.longBitsToDouble(Bits.getLongB(bb, bi));
    }

    static double getDouble(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getDoubleB(bb, bi) : Bits.getDoubleL(bb, bi);
    }

    static void putDoubleL(ByteBuffer bb, int bi, double x) {
        Bits.putLongL(bb, bi, Double.doubleToRawLongBits(x));
    }

    static void putDoubleB(ByteBuffer bb, int bi, double x) {
        Bits.putLongB(bb, bi, Double.doubleToRawLongBits(x));
    }

    static void putDouble(ByteBuffer bb, int bi, double x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putDoubleB(bb, bi, x);
        } else {
            Bits.putDoubleL(bb, bi, x);
        }
    }

    static int pageSize() {
        return pageSize;
    }

    static int pageCount(long size) {
        return (int)(size + (long)Bits.pageSize() - 1L) / Bits.pageSize();
    }

    static boolean unaligned() {
        return false;
    }

    static void unreserveMemory(long size, int cap) {
        if (reservedMemory > 0L) {
            totalCapacity -= (long)cap;
            --count;
            assert ((reservedMemory -= size) > -1L);
        }
    }

    static void copyFromCharArray(Object src, long srcPos, long dstAddr, long length) {
        Bits.copyFromShortArray(src, srcPos, dstAddr, length);
    }

    static native void copyFromShortArray(Object var0, long var1, long var3, long var5);

    static native void copyFromIntArray(Object var0, long var1, long var3, long var5);

    static native void copyFromLongArray(Object var0, long var1, long var3, long var5);

    static {
        memoryLimitSet = false;
    }
}

