/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

class ByteBufferAsShortBuffer
extends ShortBuffer {
    private final boolean bigEndian;
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsShortBuffer(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 1, bb.remaining() >> 1);
        this.bb = bb;
        this.bigEndian = true;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.offset = pos;
    }

    ByteBufferAsShortBuffer(boolean bigEndian, ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.bigEndian = bigEndian;
        this.bb = bb;
        this.offset = off;
    }

    @Override
    public ShortBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 1) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsShortBuffer(this.bigEndian, this.bb, -1, 0, rem, rem, off);
    }

    @Override
    public ShortBuffer duplicate() {
        return new ByteBufferAsShortBuffer(this.bigEndian, this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return this;
    }

    protected int ix(int i) {
        return (i << 1) + this.offset;
    }

    @Override
    public short get() {
        return Bits.getShort(this.bb, this.ix(this.nextGetIndex()), this.bigEndian);
    }

    @Override
    public short get(int i) {
        return Bits.getShort(this.bb, this.ix(this.checkIndex(i)), this.bigEndian);
    }

    @Override
    public ShortBuffer put(short x) {
        Bits.putShort(this.bb, this.ix(this.nextPutIndex()), x, this.bigEndian);
        return this;
    }

    @Override
    public ShortBuffer put(int i, short x) {
        Bits.putShort(this.bb, this.ix(this.checkIndex(i)), x, this.bigEndian);
        return this;
    }

    @Override
    public ShortBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 1);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }
}

