/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;

public abstract class AbstractQueue<E>
extends AbstractCollection<E>
implements Queue<E> {
    protected AbstractQueue() {
    }

    @Override
    public boolean add(E e) {
        if (!this.offer(e)) {
            throw new IllegalStateException("Queue full");
        }
        return true;
    }

    @Override
    public E remove() {
        Object x = this.poll();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E element() {
        Object x = this.peek();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }
}

