/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.jtransc.internal.GenericListIterator;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class SubList<E>
extends AbstractList<E> {
    private AbstractList<E> parent;
    private int offset;
    private int size;

    SubList(AbstractList<E> parent, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > parent.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.parent = parent;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        return this.parent.set(this.offset + index, element);
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.parent.get(this.offset + index);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, E element) {
        this.rangeCheck(index);
        this.parent.add(this.offset + index, element);
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        return this.parent.remove(this.offset + index);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.rangeCheck(index);
        return this.parent.addAll(this.offset + index, c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new GenericListIterator(this, 0);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }
}

