/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.internal;

import java.util.Comparator;
import java.util.List;

public class JTranscSorter {
    public static <T> Comparator<T> getComparator(List<? extends Comparable<? super T>> list) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        };
    }

    public static void sort(ComparableArrayLike a) {
    }

    public static int binarySearch(BinarySearchArrayLike bs, int fromIndex, int toIndex) {
        int min = fromIndex;
        int max = toIndex;
        int current = max / 2;
        while (min != max) {
            int result = bs.compare(current);
            if (result < 0) {
                max = current;
            } else if (result < 0) {
                min = current;
            } else {
                return current;
            }
            current = (max + min) / 2;
        }
        return -1;
    }

    public static class ListWrapper<T>
    implements ArrayLikeWrapper {
        private List<T> data;
        private Comparator<T> comparator;
        private T compareValue;

        public ListWrapper(List<T> data, Comparator<T> comparator, T compareValue) {
            this.data = data;
            this.comparator = comparator;
            this.compareValue = compareValue;
        }

        @Override
        public void swap(int index1, int index2) {
            T temp = this.data.get(index1);
            this.data.set(index1, this.data.get(index2));
            this.data.set(index2, temp);
        }

        @Override
        public int compare(int index1, int index2) {
            return this.comparator.compare(this.data.get(index1), this.data.get(index2));
        }

        @Override
        public int length() {
            return this.data.size();
        }

        @Override
        public int compare(int index) {
            return this.comparator.compare(this.data.get(index), this.compareValue);
        }
    }

    public static class IntArrayWrapped
    implements ArrayLikeWrapper {
        private int[] data;
        private int compareValue;

        public IntArrayWrapped(int[] data, int compareValue) {
            this.data = data;
            this.compareValue = compareValue;
        }

        @Override
        public int compare(int index) {
            return Integer.compare(this.data[index], this.compareValue);
        }

        @Override
        public void swap(int index1, int index2) {
            int temp = this.data[index1];
            this.data[index1] = this.data[index2];
            this.data[index2] = temp;
        }

        @Override
        public int compare(int index1, int index2) {
            return Integer.compare(this.data[index1], this.data[index2]);
        }

        @Override
        public int length() {
            return this.data.length;
        }
    }

    public static interface ArrayLikeWrapper
    extends ComparableArrayLike,
    BinarySearchArrayLike {
    }

    public static interface BinarySearchArrayLike {
        public int compare(int var1);
    }

    public static interface ComparableArrayLike {
        public void swap(int var1, int var2);

        public int compare(int var1, int var2);

        public int length();
    }
}

