/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscSystem;
import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private Writer out;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;
    private String lineSeparator;

    public BufferedWriter(Writer out) {
        this(out, defaultCharBufferSize);
    }

    public BufferedWriter(Writer out, int sz) {
        super(out);
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.out = out;
        this.cb = new char[sz];
        this.nChars = sz;
        this.nextChar = 0;
        this.lineSeparator = JTranscSystem.lineSeparator();
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    void flushBuffer() throws IOException {
        this.ensureOpen();
        if (this.nextChar == 0) {
            return;
        }
        this.out.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    @Override
    public void write(int value) throws IOException {
        this.ensureOpen();
        if (this.nextChar >= this.nChars) {
            this.flushBuffer();
        }
        this.cb[this.nextChar++] = (char)value;
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    @Override
    public void write(char[] value, int offset, int length) throws IOException {
        this.ensureOpen();
        if (offset < 0 || offset > value.length || length < 0 || offset + length > value.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        if (length >= this.nChars) {
            this.flushBuffer();
            this.out.write(value, offset, length);
            return;
        }
        int b = offset;
        int t = offset + length;
        while (b < t) {
            int d = this.min(this.nChars - this.nextChar, t - b);
            System.arraycopy(value, b, this.cb, this.nextChar, d);
            b += d;
            this.nextChar += d;
            if (this.nextChar < this.nChars) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        this.ensureOpen();
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = this.min(this.nChars - this.nextChar, t - b);
            s.getChars(b, b + d, this.cb, this.nextChar);
            b += d;
            this.nextChar += d;
            if (this.nextChar < this.nChars) continue;
            this.flushBuffer();
        }
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        Writer w = this.out;
        try {
            this.flushBuffer();
        }
        finally {
            w.close();
            this.out = null;
            this.cb = null;
        }
    }
}

