/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.FastStringMap;
import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

@HaxeAddMembers(value={"public var _hxClass:Class<Dynamic> = null;", "public var _hxProxyClass:Class<Dynamic> = null;", "public var _hxFfiClass:Class<Dynamic> = null;", "public var _internalName = '';", "public var _parent:String = null;", "public var _interfaces:Array<String> = [];", "public var _fields = [];", "public var _modifiers = 0;", "public var _methods:Array<{% CLASS java.lang.reflect.Method %}> = [];", "public var _constructors = [];", "public var _annotations = [];", "public var _methodsById = null;", "public function populateMethodsById() {\n  if (_methodsById != null) return;\n  _methodsById = new Map<Int, {% CLASS java.lang.reflect.Method %}>();\n  function populate(clazz:{% CLASS java.lang.Class %}) {\n    for (m in clazz._methods) _methodsById.set(m.{% FIELD java.lang.reflect.Method:id %}, m);\n    if (clazz._parent != null) populate(HaxeNatives.resolveClass(clazz._parent));\n    for (i in clazz._interfaces) populate(HaxeNatives.resolveClass(i));\n  }\n  populate(this);\n}\n", "public function locateMethodById(id:Int) { populateMethodsById(); return _methodsById.get(id); }"})
public final class Class<T>
implements Serializable,
Type,
GenericDeclaration,
AnnotatedElement {
    @JTranscKeep
    private String name;
    @JTranscKeep
    private boolean primitive = false;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int SYNTHETIC = 4096;
    private static FastStringMap<Class<?>> _classCache = new FastStringMap();
    private HashSet<Class<?>> allRelatedClasses = null;
    private volatile transient T[] enumConstants = null;
    private FastStringMap<Field> _fieldsByName;
    private FastStringMap<Field> _declaredFieldsByName;

    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(_fields, '[Ljava.lang.reflect.Field;');")
    public native Field[] getDeclaredFields() throws SecurityException;

    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(_methods, '[Ljava.lang.reflect.Method;');")
    public native Method[] getDeclaredMethods() throws SecurityException;

    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        Constructor<?>[] constructors = this._getDeclaredConstructors();
        return constructors != null ? constructors : new Constructor[]{};
    }

    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(_constructors, '[Ljava.lang.reflect.Constructor;');")
    private native Constructor<?>[] _getDeclaredConstructors() throws SecurityException;

    @HaxeMethodBody(value="return (_parent != null) ? HaxeNatives.resolveClass(_parent) : null;")
    public native Class<? super T> getSuperclass();

    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(Lambda.array(Lambda.map(_interfaces, function(i) { return HaxeNatives.resolveClass(i); })), '[Ljava.lang.Class;');")
    public native Class<?>[] getInterfaces();

    @Override
    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(_annotations, '[Ljava.lang.Annotation;');")
    public native Annotation[] getDeclaredAnnotations();

    @HaxeMethodBody(value="return _modifiers;")
    public native int getModifiers();

    @HaxeMethodBody(value="return HaxeNatives.newInstance(this._internalName);")
    public native T newInstance() throws InstantiationException, IllegalAccessException;

    public native Class<?>[] getDeclaredClasses() throws SecurityException;

    public native Method getEnclosingMethod();

    public native Constructor<?> getEnclosingConstructor() throws SecurityException;

    public native URL getResource(String var1);

    @HaxeMethodBody(value="return Std.is(p0, _hxClass);")
    public native boolean isInstance(Object var1);

    public native InputStream getResourceAsStream(String var1);

    public ClassLoader getClassLoader() {
        return _ClassInternalUtils.getSystemClassLoader();
    }

    public native TypeVariable<Class<T>>[] getTypeParameters();

    public native Type getGenericSuperclass();

    public native Package getPackage();

    public native Type[] getGenericInterfaces();

    public Class<?> getComponentType() {
        if (this.isArray()) {
            try {
                return Class.forName(this.getName().substring(1));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public native Object[] getSigners();

    public native Class<?> getDeclaringClass() throws SecurityException;

    public native Class<?> getEnclosingClass() throws SecurityException;

    public native Class<?>[] getClasses();

    @JTranscKeep
    private Class() {
    }

    @JTranscKeep
    Class(String name) throws ClassNotFoundException {
        this.name = name;
        this.primitive = false;
        if (!this._check()) {
            throw new ClassNotFoundException("Can't find class " + name);
        }
    }

    @JTranscKeep
    Class(String name, boolean primitive) {
        this.name = name;
        this.primitive = primitive;
    }

    @JTranscKeep
    @HaxeMethodBody(value="return R.__initClass(this);")
    private native boolean _check();

    @JTranscKeep
    public String getName() {
        return this.name;
    }

    @JTranscKeep
    static Class<?> getPrimitiveClass(String name) {
        return new Class(name, true);
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public native String toGenericString();

    static Class<?> forName0(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @JTranscKeep
    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class result;
        if (className.length() == 1) {
            switch (className.charAt(0)) {
                case 'V': {
                    return Void.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
            }
        }
        if (className.startsWith("L") && className.endsWith(";")) {
            return Class.forName(className.substring(1, className.length() - 1).replace('/', '.'));
        }
        if (!_classCache.has(className)) {
            _classCache.set(className, new Class(className));
        }
        if ((result = (Class)_classCache.get(className)) == null) {
            System.err.println("Couldn't find class " + className);
        }
        return result;
    }

    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(name);
    }

    private HashSet<Class<?>> getAllRelatedClasses() {
        if (this.allRelatedClasses == null) {
            this.allRelatedClasses = new HashSet();
            this.allRelatedClasses.add(this);
            for (Class<?> i : this.getInterfaces()) {
                this.allRelatedClasses.addAll(super.getAllRelatedClasses());
            }
            Class<T> superclass = this.getSuperclass();
            if (superclass != null) {
                this.allRelatedClasses.addAll(super.getAllRelatedClasses());
            }
        }
        return this.allRelatedClasses;
    }

    public boolean isAssignableFrom(Class<?> cls) {
        return super.getAllRelatedClasses().contains(this);
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isArray() {
        return this.name.startsWith("[");
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    public String getSimpleName() {
        String out = "";
        int separator = this.name.indexOf(36) > 0 ? 36 : 46;
        out = out + this.name.substring(this.name.lastIndexOf(separator) + 1);
        if (this.isArray()) {
            out = out + "[]";
        }
        return out;
    }

    public native String getTypeName();

    public String getCanonicalName() {
        return this.name.replace('$', '.');
    }

    public boolean isAnonymousClass() {
        return "".equals(this.getSimpleName());
    }

    public boolean isLocalClass() {
        return this.isLocalOrAnonymousClass() && !this.isAnonymousClass();
    }

    private boolean isLocalOrAnonymousClass() {
        return this.getEnclosingMethodInfo() != null;
    }

    public boolean isMemberClass() {
        return this.getSimpleBinaryName() != null && !this.isLocalOrAnonymousClass();
    }

    private native Object getEnclosingMethodInfo();

    private String getSimpleBinaryName() {
        Class<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        try {
            return this.getName().substring(enclosingClass.getName().length());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InternalError("Malformed class name", ex);
        }
    }

    public boolean desiredAssertionStatus() {
        return false;
    }

    public T[] getEnumConstants() {
        T[] values = this.getEnumConstantsShared();
        if (values == null) {
            System.out.println("Class " + this + " is not an enum (" + this.isEnum() + ")!");
            try {
                Method valuesMethod = this.getMethod("values", new Class[0]);
                System.out.println("values method:" + valuesMethod);
            }
            catch (NoSuchMethodException e) {
                throw new Error(e);
            }
        }
        return values != null ? (Object[])values.clone() : null;
    }

    T[] getEnumConstantsShared() {
        if (this.enumConstants == null) {
            if (!this.isEnum()) {
                return null;
            }
            try {
                Method valuesMethod = this.getMethod("values", new Class[0]);
                Object[] temporaryConstants = (Object[])valuesMethod.invoke(null, new Object[0]);
                this.enumConstants = temporaryConstants;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return this.enumConstants;
    }

    public T cast(Object obj) {
        if (obj != null && !this.isInstance(obj)) {
            throw new ClassCastException(this.cannotCastMsg(obj));
        }
        return (T)obj;
    }

    private String cannotCastMsg(Object obj) {
        return "Cannot cast " + obj.getClass().getName() + " to " + this.getName();
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (!clazz.isAssignableFrom(this)) {
            throw new ClassCastException(this.toString());
        }
        return this;
    }

    public Field[] getFields() throws SecurityException {
        return this.getDeclaredFields();
    }

    public Field getField(String name) throws NoSuchFieldException, SecurityException {
        if (this._fieldsByName == null) {
            this._fieldsByName = new FastStringMap();
            for (Field f : this.getFields()) {
                this._fieldsByName.set(f.getName(), (Object)f);
            }
        }
        return (Field)this._fieldsByName.get(name);
    }

    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        if (this._declaredFieldsByName == null) {
            this._declaredFieldsByName = new FastStringMap();
            for (Field f : this.getDeclaredFields()) {
                this._declaredFieldsByName.set(f.getName(), (Object)f);
            }
        }
        return (Field)this._declaredFieldsByName.get(name);
    }

    public Method[] getMethods() throws SecurityException {
        return this.getDeclaredMethods();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public Constructor<?>[] getConstructors() throws SecurityException {
        return this.getDeclaredConstructors();
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getDeclaredMethod(name, parameterTypes);
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getDeclaredConstructor(parameterTypes);
    }

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        for (Method m : this.getDeclaredMethods()) {
            if (!Objects.equals(m.getName(), name) || !Arrays.equals(m.getParameterTypes(), parameterTypes)) continue;
            return m;
        }
        throw new NoSuchMethodException(name);
    }

    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Object[] parameterTypes2 = parameterTypes != null ? parameterTypes : new Class[]{};
        for (Constructor<?> c : this.getDeclaredConstructors()) {
            if (!Arrays.equals(c.getParameterTypes(), parameterTypes2)) continue;
            return c;
        }
        throw new NoSuchMethodException();
    }

    @JTranscKeep
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getDeclaredAnnotation(annotationClass) != null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        for (Annotation a : this.getAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            return (A)a;
        }
        return null;
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        ArrayList<Annotation> out = new ArrayList<Annotation>();
        for (Annotation a : this.getAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            out.add(a);
        }
        return out.toArray(new Annotation[0]);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        for (Annotation a : this.getDeclaredAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            return (A)a;
        }
        return null;
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationClass) {
        ArrayList<Annotation> out = new ArrayList<Annotation>();
        for (Annotation a : this.getDeclaredAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            out.add(a);
        }
        return out.toArray(new Annotation[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Class aClass = (Class)o;
        if (this.isPrimitive() != aClass.isPrimitive()) {
            return false;
        }
        return this.name != null ? this.name.equals(aClass.name) : aClass.name == null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

