/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public abstract class IntBuffer
extends Buffer
implements Comparable<IntBuffer> {
    final int[] hb;
    final int offset;
    boolean isReadOnly;

    IntBuffer(int mark, int pos, int lim, int cap, int[] hb, int offset) {
        super(mark, pos, lim, cap);
        this.hb = hb;
        this.offset = offset;
    }

    IntBuffer(int mark, int pos, int lim, int cap) {
        this(mark, pos, lim, cap, null, 0);
    }

    public static native IntBuffer allocate(int var0);

    public static native IntBuffer wrap(int[] var0, int var1, int var2);

    public static IntBuffer wrap(int[] array) {
        return IntBuffer.wrap(array, 0, array.length);
    }

    public abstract IntBuffer slice();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public IntBuffer get(int[] dst, int offset, int length) {
        IntBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public IntBuffer get(int[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public IntBuffer put(IntBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int n = src.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(src.get());
        }
        return this;
    }

    public IntBuffer put(int[] src, int offset, int length) {
        IntBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final IntBuffer put(int[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final int[] array() {
        this.check();
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        this.check();
        return this.offset;
    }

    private void check() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
    }

    public abstract IntBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof IntBuffer)) {
            return false;
        }
        return this.compareTo((IntBuffer)ob) == 0;
    }

    @Override
    public int compareTo(IntBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            int cmp = Integer.compare(this.get(i), that.get(j));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    public abstract ByteOrder order();
}

