/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.jtransc.internal.IntJTranscStrings;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.FormatterClosedException;
import java.util.Locale;
import java.util.Objects;

public final class Formatter
implements Closeable,
Flushable {
    private Appendable a;
    private final Locale l;
    private IOException lastException;

    private static Charset toCharset(String csn) throws UnsupportedEncodingException {
        Objects.requireNonNull(csn, "charsetName");
        try {
            return Charset.forName(csn);
        }
        catch (Throwable unused) {
            throw new UnsupportedEncodingException(csn);
        }
    }

    private static Appendable nonNullAppendable(Appendable a) {
        return a != null ? a : new StringBuilder();
    }

    private Formatter(Locale l, Appendable a) {
        this.a = a;
        this.l = l;
    }

    private Formatter(Charset charset, Locale l, File file) throws FileNotFoundException {
        this(l, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset)));
    }

    public Formatter() {
        this(Locale.getDefault(Locale.Category.FORMAT), new StringBuilder());
    }

    public Formatter(Appendable a) {
        this(Locale.getDefault(Locale.Category.FORMAT), Formatter.nonNullAppendable(a));
    }

    public Formatter(Locale l) {
        this(l, new StringBuilder());
    }

    public Formatter(Appendable a, Locale l) {
        this(l, Formatter.nonNullAppendable(a));
    }

    public Formatter(String fileName) throws FileNotFoundException {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName))));
    }

    public Formatter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(fileName, csn, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(String fileName, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(Formatter.toCharset(csn), l, new File(fileName));
    }

    public Formatter(File file) throws FileNotFoundException {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
    }

    public Formatter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, csn, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(File file, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(Formatter.toCharset(csn), l, file);
    }

    public Formatter(PrintStream ps) {
        this(Locale.getDefault(Locale.Category.FORMAT), Objects.requireNonNull(ps));
    }

    public Formatter(OutputStream os) {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(os)));
    }

    public Formatter(OutputStream os, String csn) throws UnsupportedEncodingException {
        this(os, csn, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(OutputStream os, String csn, Locale l) throws UnsupportedEncodingException {
        this(l, new BufferedWriter(new OutputStreamWriter(os, csn)));
    }

    private void ensureOpen() {
        if (this.a == null) {
            throw new FormatterClosedException();
        }
    }

    public Locale locale() {
        this.ensureOpen();
        return this.l;
    }

    public Appendable out() {
        this.ensureOpen();
        return this.a;
    }

    public String toString() {
        this.ensureOpen();
        return this.a.toString();
    }

    @Override
    public void flush() {
        this.ensureOpen();
        if (this.a instanceof Flushable) {
            try {
                ((Flushable)((Object)this.a)).flush();
            }
            catch (IOException ioe) {
                this.lastException = ioe;
            }
        }
    }

    @Override
    public void close() {
        if (this.a == null) {
            return;
        }
        try {
            if (this.a instanceof Closeable) {
                ((Closeable)((Object)this.a)).close();
            }
        }
        catch (IOException ioe) {
            this.lastException = ioe;
        }
        finally {
            this.a = null;
        }
    }

    public IOException ioException() {
        return this.lastException;
    }

    public Formatter format(String format, Object ... args) {
        return this.format(this.l, format, args);
    }

    public Formatter format(Locale l, String format, Object ... args) {
        try {
            this.a.append(IntJTranscStrings.format(l, format, args));
        }
        catch (IOException e) {
            this.lastException = e;
        }
        return this;
    }
}

