/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private HashMap<K, V> data;

    public Hashtable(int initialCapacity, float loadFactor) {
        this.data = new HashMap(initialCapacity, loadFactor);
    }

    public Hashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public synchronized int size() {
        return this.data.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return Collections.enumeration(this.data.keySet());
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return Collections.enumeration(this.data.values());
    }

    public synchronized boolean contains(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public synchronized V get(Object key) {
        return this.data.get(key);
    }

    protected void rehash() {
    }

    @Override
    public synchronized V put(K key, V value) {
        return this.data.put(key, value);
    }

    @Override
    public synchronized V remove(Object key) {
        return this.data.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        this.data.putAll(t);
    }

    @Override
    public synchronized void clear() {
        this.data.clear();
    }

    public synchronized Object clone() {
        return new Hashtable<K, V>(this.data);
    }

    public synchronized String toString() {
        return this.data.toString();
    }

    @Override
    public Set<K> keySet() {
        return this.data.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.data.values();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (!(o instanceof Hashtable)) {
            return false;
        }
        return Objects.equals(this.data, ((Hashtable)o).data);
    }

    @Override
    public synchronized int hashCode() {
        return this.data.hashCode();
    }
}

