/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.jtransc.internal.GenericMapEntry;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private ArrayList<K> keys = new ArrayList();
    private ArrayList<V> values = new ArrayList();

    public IdentityHashMap() {
    }

    public IdentityHashMap(int expectedMaxSize) {
    }

    public IdentityHashMap(Map<? extends K, ? extends V> m) {
        this.putAll(m);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    private static int hash(Object x, int length) {
        int h = System.identityHashCode(x);
        return (h << 1) - (h << 8) & length - 1;
    }

    private int getKeyIndex(Object key) {
        for (int n = 0; n < this.size(); ++n) {
            if (this.keys.get(n) != key) continue;
            return n;
        }
        return -1;
    }

    private int getValueIndex(Object value) {
        for (int n = 0; n < this.size(); ++n) {
            if (this.values.get(n) != value) continue;
            return n;
        }
        return -1;
    }

    @Override
    public V get(Object key) {
        int index = this.getKeyIndex(key);
        return index >= 0 ? (V)this.values.get(index) : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getKeyIndex(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getValueIndex(value) >= 0;
    }

    @Override
    public V put(K key, V value) {
        int index = this.getKeyIndex(key);
        if (index >= 0) {
            this.values.set(index, value);
            return this.values.get(index);
        }
        this.keys.add(key);
        this.values.add(value);
        return null;
    }

    @Override
    public V remove(Object key) {
        int index = this.getKeyIndex(key);
        V oldValue = null;
        if (index >= 0) {
            oldValue = this.values.get(index);
            this.keys.remove(index);
            this.values.remove(index);
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        if (!(t instanceof IdentityHashMap)) {
            return false;
        }
        IdentityHashMap that = (IdentityHashMap)t;
        return Objects.equals(this.keySet(), that.keySet()) && Objects.equals(this.values(), that.values());
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (int n = 0; n < this.size(); ++n) {
            K key = this.keys.get(n);
            V value = this.values.get(n);
            result += System.identityHashCode(key) ^ System.identityHashCode(value);
        }
        return result;
    }

    @Override
    public Object clone() {
        return new IdentityHashMap<K, V>(this);
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.keys);
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> out = new HashSet<Map.Entry<K, V>>();
        for (K key : this.keys) {
            out.add(new GenericMapEntry(this, key));
        }
        return out;
    }
}

