/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public abstract class ResourceBundle {
    protected ResourceBundle parent = null;

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) {
        return this.handleGetObject(key);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    public static final ResourceBundle getBundle(String baseName) {
        return new ResourceBundle(){

            @Override
            protected Object handleGetObject(String key) {
                return key;
            }

            @Override
            public Enumeration<String> getKeys() {
                return null;
            }
        };
    }

    public static final ResourceBundle getBundle(String baseName, Control control) {
        return ResourceBundle.getBundle(baseName);
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) {
        return ResourceBundle.getBundle(baseName);
    }

    public static final ResourceBundle getBundle(String baseName, Locale targetLocale, Control control) {
        return ResourceBundle.getBundle(baseName);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        return ResourceBundle.getBundle(baseName);
    }

    public static ResourceBundle getBundle(String baseName, Locale targetLocale, ClassLoader loader, Control control) {
        return ResourceBundle.getBundle(baseName);
    }

    public static final void clearCache() {
    }

    public static final void clearCache(ClassLoader loader) {
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration<String> getKeys();

    public boolean containsKey(String key) {
        return this.handleGetObject(key) != null;
    }

    public native Set<String> keySet();

    protected native Set<String> handleKeySet();

    private static class SingleFormatControl
    extends Control {
        private static final Control PROPERTIES_ONLY = new SingleFormatControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY = new SingleFormatControl(FORMAT_CLASS);
        private final List<String> formats;

        protected SingleFormatControl(List<String> formats) {
            this.formats = formats;
        }

        @Override
        public List<String> getFormats(String baseName) {
            Objects.requireNonNull(baseName);
            return this.formats;
        }
    }

    public static class Control {
        public static final List<String> FORMAT_DEFAULT = Collections.unmodifiableList(Arrays.asList("java.class", "java.properties"));
        public static final List<String> FORMAT_CLASS = Collections.unmodifiableList(Arrays.asList("java.class"));
        public static final List<String> FORMAT_PROPERTIES = Collections.unmodifiableList(Arrays.asList("java.properties"));
        public static final long TTL_DONT_CACHE = -1L;
        public static final long TTL_NO_EXPIRATION_CONTROL = -2L;
        private static final Control INSTANCE = new Control();

        protected Control() {
        }

        public static final native Control getControl(List<String> var0);

        public static final native Control getNoFallbackControl(List<String> var0);

        public native List<String> getFormats(String var1);

        public native List<Locale> getCandidateLocales(String var1, Locale var2);

        public native Locale getFallbackLocale(String var1, Locale var2);

        public native ResourceBundle newBundle(String var1, Locale var2, String var3, ClassLoader var4, boolean var5) throws IllegalAccessException, InstantiationException, IOException;

        public native long getTimeToLive(String var1, Locale var2);

        public native boolean needsReload(String var1, Locale var2, String var3, ClassLoader var4, ResourceBundle var5, long var6);

        public native String toBundleName(String var1, Locale var2);

        public final native String toResourceName(String var1, String var2);
    }
}

