/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;

public class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private LinkedList<E> queue = new LinkedList();

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.queue.descendingIterator();
    }

    @Override
    public void push(E e) {
        this.queue.push(e);
    }

    @Override
    public E pop() {
        return this.queue.pop();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.queue.add(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offer(e);
    }

    @Override
    public E take() throws InterruptedException {
        return this.queue.remove();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.poll();
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int transferred = 0;
        while (this.queue.size() > 0 && transferred < maxElements) {
            c.add(this.queue.poll());
        }
        return transferred;
    }

    @Override
    public void addFirst(E e) {
        this.queue.addFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.queue.addLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        return this.queue.offerFirst(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.queue.offerLast(e);
    }

    @Override
    public E removeFirst() {
        return this.queue.removeFirst();
    }

    @Override
    public E removeLast() {
        return this.queue.removeLast();
    }

    @Override
    public E pollFirst() {
        return this.queue.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.queue.pollLast();
    }

    @Override
    public E getFirst() {
        return this.queue.getFirst();
    }

    @Override
    public E getLast() {
        return this.queue.getLast();
    }

    @Override
    public E peekFirst() {
        return this.queue.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.queue.peekLast();
    }

    @Override
    public void putFirst(E e) throws InterruptedException {
        this.queue.addFirst(e);
    }

    @Override
    public void putLast(E e) throws InterruptedException {
        this.queue.addLast(e);
    }

    @Override
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offerFirst(e);
    }

    @Override
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offerLast(e);
    }

    @Override
    public E takeFirst() throws InterruptedException {
        return this.queue.pollFirst();
    }

    @Override
    public E takeLast() throws InterruptedException {
        return this.queue.pollLast();
    }

    @Override
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.pollFirst();
    }

    @Override
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.pollLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.queue.removeFirstOccurrence(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.queue.removeLastOccurrence(o);
    }

    @Override
    public boolean offer(E e) {
        return this.queue.offer(e);
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }
}

