/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscArrays;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EmulatedFields;
import java.io.EmulatedFieldsForLoading;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private InputStream emptyStream;
    private static final Object UNSHARED_OBJ = new Object();
    private boolean hasPushbackTC;
    private byte pushbackTC;
    private int nestedLevels;
    private int nextHandle;
    private DataInputStream input;
    private DataInputStream primitiveTypes;
    private InputStream primitiveData;
    private boolean enableResolve;
    private ArrayList<Object> objectsRead;
    private Object currentObject;
    private ObjectStreamClass currentClass;
    private InputValidationDesc[] validations;
    private boolean subclassOverridingImplementation;
    private ClassLoader callerClassLoader;
    private boolean mustResolve;
    private int descriptorHandle;
    private static final HashMap<String, Class<?>> PRIMITIVE_CLASSES = new HashMap();
    private HashMap<Class<?>, List<Class<?>>> cachedSuperclasses;
    private static final ClassLoader bootstrapLoader;
    private static final ClassLoader systemLoader;

    protected ObjectInputStream() throws IOException {
        this.primitiveData = this.emptyStream = new ByteArrayInputStream(JTranscArrays.EMPTY_BYTE);
        this.mustResolve = true;
        this.descriptorHandle = -1;
        this.cachedSuperclasses = new HashMap();
        this.subclassOverridingImplementation = true;
    }

    public ObjectInputStream(InputStream input) throws StreamCorruptedException, IOException {
        this.primitiveData = this.emptyStream = new ByteArrayInputStream(JTranscArrays.EMPTY_BYTE);
        this.mustResolve = true;
        this.descriptorHandle = -1;
        this.cachedSuperclasses = new HashMap();
        this.input = input instanceof DataInputStream ? (DataInputStream)input : new DataInputStream(input);
        this.primitiveTypes = new DataInputStream(this);
        this.enableResolve = false;
        this.subclassOverridingImplementation = false;
        this.resetState();
        this.nestedLevels = 0;
        this.primitiveData = this.input;
        this.readStreamHeader();
        this.primitiveData = this.emptyStream;
    }

    @Override
    public int available() throws IOException {
        this.checkReadPrimitiveTypes();
        return this.primitiveData.available();
    }

    private void checkReadPrimitiveTypes() throws IOException {
        int next;
        if (this.primitiveData == this.input || this.primitiveData.available() > 0) {
            return;
        }
        block5: while (true) {
            next = 0;
            if (this.hasPushbackTC) {
                this.hasPushbackTC = false;
            } else {
                next = this.input.read();
                this.pushbackTC = (byte)next;
            }
            switch (this.pushbackTC) {
                case 119: {
                    this.primitiveData = new ByteArrayInputStream(this.readBlockData());
                    return;
                }
                case 122: {
                    this.primitiveData = new ByteArrayInputStream(this.readBlockDataLong());
                    return;
                }
                case 121: {
                    this.resetState();
                    continue block5;
                }
            }
            break;
        }
        if (next != -1) {
            this.pushbackTC();
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null && this.mustResolve) {
            throw new NotActiveException();
        }
        this.readFieldValues(this.currentObject, this.currentClass);
    }

    protected boolean enableResolveObject(boolean enable) {
        boolean originalValue = this.enableResolve;
        this.enableResolve = enable;
        return originalValue;
    }

    private int nextHandle() {
        return this.nextHandle++;
    }

    private byte nextTC() throws IOException {
        if (this.hasPushbackTC) {
            this.hasPushbackTC = false;
        } else {
            this.pushbackTC = this.input.readByte();
        }
        return this.pushbackTC;
    }

    private void pushbackTC() {
        this.hasPushbackTC = true;
    }

    @Override
    public int read() throws IOException {
        this.checkReadPrimitiveTypes();
        return this.primitiveData.read();
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        JTranscArrays.checkOffsetAndCount((int)buffer.length, (int)byteOffset, (int)byteCount);
        if (byteCount == 0) {
            return 0;
        }
        this.checkReadPrimitiveTypes();
        return this.primitiveData.read(buffer, byteOffset, byteCount);
    }

    private byte[] readBlockData() throws IOException {
        byte[] result = new byte[this.input.readByte() & 0xFF];
        this.input.readFully(result);
        return result;
    }

    private byte[] readBlockDataLong() throws IOException {
        byte[] result = new byte[this.input.readInt()];
        this.input.readFully(result);
        return result;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.primitiveTypes.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.primitiveTypes.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.primitiveTypes.readChar();
    }

    private void discardData() throws ClassNotFoundException, IOException {
        this.primitiveData = this.emptyStream;
        boolean resolve = this.mustResolve;
        this.mustResolve = false;
        while (true) {
            byte tc;
            if ((tc = this.nextTC()) == 120) {
                this.mustResolve = resolve;
                return;
            }
            this.readContent(tc);
        }
    }

    private ObjectStreamClass readClassDesc() throws ClassNotFoundException, IOException {
        byte tc = this.nextTC();
        switch (tc) {
            case 114: {
                return this.readNewClassDesc(false);
            }
            case 125: {
                Class<?> proxyClass = this.readNewProxyClassDesc();
                ObjectStreamClass streamClass = ObjectStreamClass.lookup(proxyClass);
                streamClass.setLoadFields(ObjectStreamClass.NO_FIELDS);
                this.registerObjectRead(streamClass, this.nextHandle(), false);
                ObjectInputStream.checkedSetSuperClassDesc(streamClass, this.readClassDesc());
                return streamClass;
            }
            case 113: {
                return (ObjectStreamClass)this.readCyclicReference();
            }
            case 112: {
                return null;
            }
        }
        throw this.corruptStream(tc);
    }

    private StreamCorruptedException corruptStream(byte tc) throws StreamCorruptedException {
        throw new StreamCorruptedException("Wrong format: " + Integer.toHexString(tc & 0xFF));
    }

    private Object readContent(byte tc) throws ClassNotFoundException, IOException {
        switch (tc) {
            case 119: {
                return this.readBlockData();
            }
            case 122: {
                return this.readBlockDataLong();
            }
            case 118: {
                return this.readNewClass(false);
            }
            case 114: {
                return this.readNewClassDesc(false);
            }
            case 117: {
                return this.readNewArray(false);
            }
            case 115: {
                return this.readNewObject(false);
            }
            case 116: {
                return this.readNewString(false);
            }
            case 124: {
                return this.readNewLongString(false);
            }
            case 113: {
                return this.readCyclicReference();
            }
            case 112: {
                return null;
            }
            case 123: {
                Exception exc = this.readException();
                throw new WriteAbortedException("Read an exception", exc);
            }
            case 121: {
                this.resetState();
                return null;
            }
        }
        throw this.corruptStream(tc);
    }

    private Object readNonPrimitiveContent(boolean unshared) throws ClassNotFoundException, IOException {
        byte tc;
        this.checkReadPrimitiveTypes();
        if (this.primitiveData.available() > 0) {
            OptionalDataException e = new OptionalDataException();
            e.length = this.primitiveData.available();
            throw e;
        }
        block14: while (true) {
            tc = this.nextTC();
            switch (tc) {
                case 118: {
                    return this.readNewClass(unshared);
                }
                case 114: {
                    return this.readNewClassDesc(unshared);
                }
                case 117: {
                    return this.readNewArray(unshared);
                }
                case 115: {
                    return this.readNewObject(unshared);
                }
                case 116: {
                    return this.readNewString(unshared);
                }
                case 124: {
                    return this.readNewLongString(unshared);
                }
                case 126: {
                    return this.readEnum(unshared);
                }
                case 113: {
                    if (unshared) {
                        this.readNewHandle();
                        throw new InvalidObjectException("Unshared read of back reference");
                    }
                    return this.readCyclicReference();
                }
                case 112: {
                    return null;
                }
                case 123: {
                    Exception exc = this.readException();
                    throw new WriteAbortedException("Read an exception", exc);
                }
                case 121: {
                    this.resetState();
                    continue block14;
                }
                case 120: {
                    this.pushbackTC();
                    OptionalDataException e = new OptionalDataException();
                    e.eof = true;
                    throw e;
                }
            }
            break;
        }
        throw this.corruptStream(tc);
    }

    private Object readCyclicReference() throws InvalidObjectException, IOException {
        return this.registeredObjectRead(this.readNewHandle());
    }

    @Override
    public double readDouble() throws IOException {
        return this.primitiveTypes.readDouble();
    }

    private Exception readException() throws WriteAbortedException, OptionalDataException, ClassNotFoundException, IOException {
        this.resetSeenObjects();
        Exception exc = (Exception)this.readObject();
        this.resetSeenObjects();
        return exc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFieldDescriptors(ObjectStreamClass cDesc) throws ClassNotFoundException, IOException {
        short numFields = this.input.readShort();
        ObjectStreamField[] fields = new ObjectStreamField[numFields];
        cDesc.setLoadFields(fields);
        for (short i = 0; i < numFields; i = (short)(i + 1)) {
            ObjectStreamField f;
            String classSig;
            char typecode = (char)this.input.readByte();
            String fieldName = this.input.readUTF();
            boolean isPrimType = ObjectStreamClass.isPrimitiveType(typecode);
            if (isPrimType) {
                classSig = String.valueOf(typecode);
            } else {
                boolean old = this.enableResolve;
                try {
                    this.enableResolve = false;
                    classSig = (String)this.readObject();
                }
                finally {
                    this.enableResolve = old;
                }
            }
            classSig = ObjectInputStream.formatClassSig(classSig);
            fields[i] = f = new ObjectStreamField(classSig, fieldName);
        }
    }

    private static String formatClassSig(String classSig) {
        int start = 0;
        int end = classSig.length();
        if (end <= 0) {
            return classSig;
        }
        while (classSig.startsWith("[L", start) && classSig.charAt(end - 1) == ';') {
            start += 2;
            --end;
        }
        if (start > 0) {
            return classSig.substring(start -= 2, ++end);
        }
        return classSig;
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null) {
            throw new NotActiveException();
        }
        EmulatedFieldsForLoading result = new EmulatedFieldsForLoading(this.currentClass);
        this.readFieldValues(result);
        return result;
    }

    private void readFieldValues(EmulatedFieldsForLoading emulatedFields) throws OptionalDataException, InvalidClassException, IOException {
        EmulatedFields.ObjectSlot[] slots;
        for (EmulatedFields.ObjectSlot element : slots = emulatedFields.emulatedFields().slots()) {
            element.defaulted = false;
            Class<?> type = element.field.getType();
            if (type == Integer.TYPE) {
                element.fieldValue = this.input.readInt();
                continue;
            }
            if (type == Byte.TYPE) {
                element.fieldValue = this.input.readByte();
                continue;
            }
            if (type == Character.TYPE) {
                element.fieldValue = Character.valueOf(this.input.readChar());
                continue;
            }
            if (type == Short.TYPE) {
                element.fieldValue = this.input.readShort();
                continue;
            }
            if (type == Boolean.TYPE) {
                element.fieldValue = this.input.readBoolean();
                continue;
            }
            if (type == Long.TYPE) {
                element.fieldValue = this.input.readLong();
                continue;
            }
            if (type == Float.TYPE) {
                element.fieldValue = Float.valueOf(this.input.readFloat());
                continue;
            }
            if (type == Double.TYPE) {
                element.fieldValue = this.input.readDouble();
                continue;
            }
            try {
                element.fieldValue = this.readObject();
            }
            catch (ClassNotFoundException cnf) {
                throw new InvalidClassException(cnf.toString());
            }
        }
    }

    private void readFieldValues(Object obj, ObjectStreamClass classDesc) throws OptionalDataException, ClassNotFoundException, IOException {
        ObjectStreamField[] fields = classDesc.getLoadFields();
        fields = fields == null ? ObjectStreamClass.NO_FIELDS : fields;
        Class<?> declaringClass = classDesc.forClass();
        if (declaringClass == null && this.mustResolve) {
            throw new ClassNotFoundException(classDesc.getName());
        }
        for (ObjectStreamField fieldDesc : fields) {
            Field field = classDesc.getReflectionField(fieldDesc);
            if (field != null && Modifier.isTransient(field.getModifiers())) {
                field = null;
            }
            try {
                Class<?> valueType;
                Object toSet;
                Class<?> type = fieldDesc.getTypeInternal();
                if (type == Byte.TYPE) {
                    byte b = this.input.readByte();
                    if (field == null) continue;
                    field.setByte(obj, b);
                    continue;
                }
                if (type == Character.TYPE) {
                    char c = this.input.readChar();
                    if (field == null) continue;
                    field.setChar(obj, c);
                    continue;
                }
                if (type == Double.TYPE) {
                    double d = this.input.readDouble();
                    if (field == null) continue;
                    field.setDouble(obj, d);
                    continue;
                }
                if (type == Float.TYPE) {
                    float f = this.input.readFloat();
                    if (field == null) continue;
                    field.setFloat(obj, f);
                    continue;
                }
                if (type == Integer.TYPE) {
                    int i = this.input.readInt();
                    if (field == null) continue;
                    field.setInt(obj, i);
                    continue;
                }
                if (type == Long.TYPE) {
                    long j = this.input.readLong();
                    if (field == null) continue;
                    field.setLong(obj, j);
                    continue;
                }
                if (type == Short.TYPE) {
                    short s = this.input.readShort();
                    if (field == null) continue;
                    field.setShort(obj, s);
                    continue;
                }
                if (type == Boolean.TYPE) {
                    boolean z = this.input.readBoolean();
                    if (field == null) continue;
                    field.setBoolean(obj, z);
                    continue;
                }
                Object object = toSet = fieldDesc.isUnshared() ? this.readUnshared() : this.readObject();
                if (toSet == null) continue;
                String fieldName = fieldDesc.getName();
                ObjectStreamField localFieldDesc = classDesc.getField(fieldName);
                Class<?> fieldType = localFieldDesc.getTypeInternal();
                if (!fieldType.isAssignableFrom(valueType = toSet.getClass())) {
                    throw new ClassCastException(classDesc.getName() + "." + fieldName + " - " + fieldType + " not compatible with " + valueType);
                }
                if (field == null) continue;
                field.set(obj, toSet);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    @Override
    public float readFloat() throws IOException {
        return this.primitiveTypes.readFloat();
    }

    @Override
    public void readFully(byte[] dst) throws IOException {
        this.primitiveTypes.readFully(dst);
    }

    @Override
    public void readFully(byte[] dst, int offset, int byteCount) throws IOException {
        this.primitiveTypes.readFully(dst, offset, byteCount);
    }

    private void readHierarchy(Object object, ObjectStreamClass classDesc) throws IOException, ClassNotFoundException, NotActiveException {
        if (object == null && this.mustResolve) {
            throw new NotActiveException();
        }
        List<ObjectStreamClass> streamClassList = classDesc.getHierarchy();
        if (object == null) {
            for (ObjectStreamClass objectStreamClass : streamClassList) {
                this.readObjectForClass(null, objectStreamClass);
            }
        } else {
            List<Class<?>> superclasses = this.cachedSuperclasses.get(object.getClass());
            if (superclasses == null) {
                superclasses = this.cacheSuperclassesFor(object.getClass());
            }
            int lastIndex = 0;
            int end = superclasses.size();
            for (int i = 0; i < end; ++i) {
                Class<?> superclass = superclasses.get(i);
                int index = this.findStreamSuperclass(superclass, streamClassList, lastIndex);
                if (index == -1) {
                    this.readObjectNoData(object, superclass, ObjectStreamClass.lookupStreamClass(superclass));
                    continue;
                }
                for (int j = lastIndex; j <= index; ++j) {
                    this.readObjectForClass(object, streamClassList.get(j));
                }
                lastIndex = index + 1;
            }
        }
    }

    private List<Class<?>> cacheSuperclassesFor(Class<?> c) {
        ArrayList result = new ArrayList();
        Class<?> nextClass = c;
        while (nextClass != null) {
            Class<?> testClass = nextClass.getSuperclass();
            if (testClass != null) {
                result.add(0, nextClass);
            }
            nextClass = testClass;
        }
        this.cachedSuperclasses.put(c, result);
        return result;
    }

    private int findStreamSuperclass(Class<?> cl, List<ObjectStreamClass> classList, int lastIndex) {
        int end = classList.size();
        for (int i = lastIndex; i < end; ++i) {
            ObjectStreamClass objCl = classList.get(i);
            String forName = objCl.forClass().getName();
            if (!(objCl.getName().equals(forName) ? cl.getName().equals(objCl.getName()) : cl.getName().equals(forName))) continue;
            return i;
        }
        return -1;
    }

    private void readObjectNoData(Object object, Class<?> cl, ObjectStreamClass classDesc) throws ObjectStreamException {
        if (!classDesc.isSerializable()) {
            return;
        }
        if (classDesc.hasMethodReadObjectNoData()) {
            Method readMethod = classDesc.getMethodReadObjectNoData();
            try {
                readMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                throw (ObjectStreamException)ex;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObjectForClass(Object object, ObjectStreamClass classDesc) throws IOException, ClassNotFoundException, NotActiveException {
        this.currentObject = object;
        this.currentClass = classDesc;
        boolean hadWriteMethod = (classDesc.getFlags() & 1) != 0;
        Class<?> targetClass = classDesc.forClass();
        Method readMethod = targetClass == null || !this.mustResolve ? null : classDesc.getMethodReadObject();
        try {
            if (readMethod != null) {
                readMethod.setAccessible(true);
                try {
                    readMethod.invoke(object, this);
                }
                catch (InvocationTargetException e) {
                    Throwable ex = e.getTargetException();
                    if (ex instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    if (ex instanceof Error) {
                        throw (Error)ex;
                    }
                    throw (IOException)ex;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e.toString());
                }
            } else {
                this.defaultReadObject();
            }
            if (hadWriteMethod) {
                this.discardData();
            }
        }
        finally {
            this.currentObject = null;
            this.currentClass = null;
        }
    }

    @Override
    public int readInt() throws IOException {
        return this.primitiveTypes.readInt();
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.primitiveTypes.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.primitiveTypes.readLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readNewArray(boolean unshared) throws OptionalDataException, ClassNotFoundException, IOException {
        ObjectStreamClass classDesc = this.readClassDesc();
        if (classDesc == null) {
            throw this.missingClassDescriptor();
        }
        int newHandle = this.nextHandle();
        int size = this.input.readInt();
        Class<?> arrayClass = classDesc.forClass();
        Class<?> componentType = arrayClass.getComponentType();
        Object result = Array.newInstance(componentType, size);
        this.registerObjectRead(result, newHandle, unshared);
        if (componentType.isPrimitive()) {
            if (componentType == Integer.TYPE) {
                int[] intArray = (int[])result;
                for (int i = 0; i < size; ++i) {
                    intArray[i] = this.input.readInt();
                }
            } else if (componentType == Byte.TYPE) {
                byte[] byteArray = (byte[])result;
                this.input.readFully(byteArray, 0, size);
            } else if (componentType == Character.TYPE) {
                char[] charArray = (char[])result;
                for (int i = 0; i < size; ++i) {
                    charArray[i] = this.input.readChar();
                }
            } else if (componentType == Short.TYPE) {
                short[] shortArray = (short[])result;
                for (int i = 0; i < size; ++i) {
                    shortArray[i] = this.input.readShort();
                }
            } else if (componentType == Boolean.TYPE) {
                boolean[] booleanArray = (boolean[])result;
                for (int i = 0; i < size; ++i) {
                    booleanArray[i] = this.input.readBoolean();
                }
            } else if (componentType == Long.TYPE) {
                long[] longArray = (long[])result;
                for (int i = 0; i < size; ++i) {
                    longArray[i] = this.input.readLong();
                }
            } else if (componentType == Float.TYPE) {
                float[] floatArray = (float[])result;
                for (int i = 0; i < size; ++i) {
                    floatArray[i] = this.input.readFloat();
                }
            } else {
                if (componentType != Double.TYPE) throw new ClassNotFoundException("Wrong base type in " + classDesc.getName());
                double[] doubleArray = (double[])result;
                for (int i = 0; i < size; ++i) {
                    doubleArray[i] = this.input.readDouble();
                }
            }
        } else {
            Object[] objectArray = (Object[])result;
            for (int i = 0; i < size; ++i) {
                objectArray[i] = this.readObject();
            }
        }
        if (!this.enableResolve) return result;
        result = this.resolveObject(result);
        this.registerObjectRead(result, newHandle, false);
        return result;
    }

    private Class<?> readNewClass(boolean unshared) throws ClassNotFoundException, IOException {
        ObjectStreamClass classDesc = this.readClassDesc();
        if (classDesc == null) {
            throw this.missingClassDescriptor();
        }
        Class<?> localClass = classDesc.forClass();
        if (localClass != null) {
            this.registerObjectRead(localClass, this.nextHandle(), unshared);
        }
        return localClass;
    }

    private ObjectStreamClass readEnumDesc() throws IOException, ClassNotFoundException {
        byte tc = this.nextTC();
        switch (tc) {
            case 114: {
                return this.readEnumDescInternal();
            }
            case 113: {
                return (ObjectStreamClass)this.readCyclicReference();
            }
            case 112: {
                return null;
            }
        }
        throw this.corruptStream(tc);
    }

    private ObjectStreamClass readEnumDescInternal() throws IOException, ClassNotFoundException {
        this.primitiveData = this.input;
        int oldHandle = this.descriptorHandle;
        this.descriptorHandle = this.nextHandle();
        ObjectStreamClass classDesc = this.readClassDescriptor();
        this.registerObjectRead(classDesc, this.descriptorHandle, false);
        this.descriptorHandle = oldHandle;
        this.primitiveData = this.emptyStream;
        classDesc.setClass(this.resolveClass(classDesc));
        this.discardData();
        ObjectStreamClass superClass = this.readClassDesc();
        ObjectInputStream.checkedSetSuperClassDesc(classDesc, superClass);
        if (0L != classDesc.getSerialVersionUID() || 0L != superClass.getSerialVersionUID()) {
            throw new InvalidClassException(superClass.getName(), "Incompatible class (SUID): " + superClass + " but expected " + superClass);
        }
        byte tc = this.nextTC();
        if (tc == 120) {
            superClass.setSuperclass(this.readClassDesc());
        } else {
            this.pushbackTC();
        }
        return classDesc;
    }

    private Object readEnum(boolean unshared) throws OptionalDataException, ClassNotFoundException, IOException {
        Object result;
        String name;
        ObjectStreamClass classDesc = this.readEnumDesc();
        int newHandle = this.nextHandle();
        byte tc = this.nextTC();
        switch (tc) {
            case 113: {
                if (unshared) {
                    this.readNewHandle();
                    throw new InvalidObjectException("Unshared read of back reference");
                }
                name = (String)this.readCyclicReference();
                break;
            }
            case 116: {
                name = (String)this.readNewString(unshared);
                break;
            }
            default: {
                throw this.corruptStream(tc);
            }
        }
        try {
            result = Enum.valueOf(classDesc.forClass(), name);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidObjectException(e.getMessage());
        }
        this.registerObjectRead(result, newHandle, unshared);
        return result;
    }

    private ObjectStreamClass readNewClassDesc(boolean unshared) throws ClassNotFoundException, IOException {
        ObjectStreamClass newClassDesc;
        block3: {
            this.primitiveData = this.input;
            int oldHandle = this.descriptorHandle;
            this.descriptorHandle = this.nextHandle();
            newClassDesc = this.readClassDescriptor();
            this.registerObjectRead(newClassDesc, this.descriptorHandle, unshared);
            this.descriptorHandle = oldHandle;
            this.primitiveData = this.emptyStream;
            try {
                newClassDesc.setClass(this.resolveClass(newClassDesc));
                this.verifyAndInit(newClassDesc);
            }
            catch (ClassNotFoundException e) {
                if (!this.mustResolve) break block3;
                throw e;
            }
        }
        ObjectStreamField[] fields = newClassDesc.getLoadFields();
        fields = fields == null ? ObjectStreamClass.NO_FIELDS : fields;
        ClassLoader loader = newClassDesc.forClass() == null ? this.callerClassLoader : newClassDesc.forClass().getClassLoader();
        for (ObjectStreamField element : fields) {
            element.resolve(loader);
        }
        this.discardData();
        ObjectInputStream.checkedSetSuperClassDesc(newClassDesc, this.readClassDesc());
        return newClassDesc;
    }

    private Class<?> readNewProxyClassDesc() throws ClassNotFoundException, IOException {
        int count = this.input.readInt();
        String[] interfaceNames = new String[count];
        for (int i = 0; i < count; ++i) {
            interfaceNames[i] = this.input.readUTF();
        }
        Class<?> proxy = this.resolveProxyClass(interfaceNames);
        this.discardData();
        return proxy;
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass newClassDesc = new ObjectStreamClass();
        String name = this.input.readUTF();
        if (name.length() == 0) {
            throw new IOException("The stream is corrupted");
        }
        newClassDesc.setName(name);
        newClassDesc.setSerialVersionUID(this.input.readLong());
        newClassDesc.setFlags(this.input.readByte());
        if (this.descriptorHandle == -1) {
            this.descriptorHandle = this.nextHandle();
        }
        this.registerObjectRead(newClassDesc, this.descriptorHandle, false);
        this.readFieldDescriptors(newClassDesc);
        return newClassDesc;
    }

    protected Class<?> resolveProxyClass(String[] interfaceNames) throws IOException, ClassNotFoundException {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        Class[] interfaces = new Class[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaces[i] = Class.forName(interfaceNames[i], false, loader);
        }
        try {
            return Proxy.getProxyClass(loader, interfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(e.toString(), e);
        }
    }

    private int readNewHandle() throws IOException {
        return this.input.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readNewObject(boolean unshared) throws OptionalDataException, ClassNotFoundException, IOException {
        ObjectStreamClass classDesc = this.readClassDesc();
        if (classDesc == null) {
            throw this.missingClassDescriptor();
        }
        int newHandle = this.nextHandle();
        Class<?> objectClass = classDesc.forClass();
        Object result = null;
        Object registeredResult = null;
        if (objectClass != null) {
            result = classDesc.newInstance(objectClass);
            this.registerObjectRead(result, newHandle, unshared);
            registeredResult = result;
        } else {
            result = null;
        }
        try {
            boolean wasExternalizable;
            this.currentObject = result;
            this.currentClass = classDesc;
            boolean bl = wasExternalizable = (classDesc.getFlags() & 4) != 0;
            if (wasExternalizable) {
                boolean blockData;
                boolean bl2 = blockData = (classDesc.getFlags() & 8) != 0;
                if (!blockData) {
                    this.primitiveData = this.input;
                }
                if (this.mustResolve) {
                    Externalizable extern = (Externalizable)result;
                    extern.readExternal(this);
                }
                if (blockData) {
                    this.discardData();
                } else {
                    this.primitiveData = this.emptyStream;
                }
            } else {
                this.readHierarchy(result, classDesc);
            }
        }
        finally {
            this.currentObject = null;
            this.currentClass = null;
        }
        if (objectClass != null && classDesc.hasMethodReadResolve()) {
            Method methodReadResolve = classDesc.getMethodReadResolve();
            try {
                result = methodReadResolve.invoke(result, null);
            }
            catch (IllegalAccessException blockData) {
            }
            catch (InvocationTargetException ite) {
                Throwable target = ite.getTargetException();
                if (target instanceof ObjectStreamException) {
                    throw (ObjectStreamException)target;
                }
                if (target instanceof Error) {
                    throw (Error)target;
                }
                throw (RuntimeException)target;
            }
        }
        if (result != null && this.enableResolve) {
            result = this.resolveObject(result);
        }
        if (registeredResult != result) {
            this.registerObjectRead(result, newHandle, unshared);
        }
        return result;
    }

    private InvalidClassException missingClassDescriptor() throws InvalidClassException {
        throw new InvalidClassException("Read null attempting to read class descriptor for object");
    }

    private Object readNewString(boolean unshared) throws IOException {
        Object result = this.input.readUTF();
        if (this.enableResolve) {
            result = this.resolveObject(result);
        }
        this.registerObjectRead(result, this.nextHandle(), unshared);
        return result;
    }

    private Object readNewLongString(boolean unshared) throws IOException {
        long length = this.input.readLong();
        Object result = this.input.decodeUTF((int)length);
        if (this.enableResolve) {
            result = this.resolveObject(result);
        }
        this.registerObjectRead(result, this.nextHandle(), unshared);
        return result;
    }

    @Override
    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        return this.readObject(false);
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObject(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readObject(boolean unshared) throws OptionalDataException, ClassNotFoundException, IOException {
        Object result;
        boolean restoreInput;
        boolean bl = restoreInput = this.primitiveData == this.input;
        if (restoreInput) {
            this.primitiveData = this.emptyStream;
        }
        if (this.subclassOverridingImplementation && !unshared) {
            return this.readObjectOverride();
        }
        try {
            if (++this.nestedLevels == 1) {
                // empty if block
            }
            result = this.readNonPrimitiveContent(unshared);
            if (restoreInput) {
                this.primitiveData = this.input;
            }
        }
        finally {
            if (--this.nestedLevels == 0) {
                this.callerClassLoader = null;
            }
        }
        if (this.nestedLevels == 0 && this.validations != null) {
            try {
                for (InputValidationDesc element : this.validations) {
                    element.validator.validateObject();
                }
            }
            finally {
                this.validations = null;
            }
        }
        return result;
    }

    protected Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        if (this.input == null) {
            return null;
        }
        throw new IOException();
    }

    @Override
    public short readShort() throws IOException {
        return this.primitiveTypes.readShort();
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (this.input.readShort() == -21267 && this.input.readShort() == 5) {
            return;
        }
        throw new StreamCorruptedException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.primitiveTypes.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.primitiveTypes.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.primitiveTypes.readUTF();
    }

    private Object registeredObjectRead(int handle) throws InvalidObjectException {
        Object res = this.objectsRead.get(handle - 0x7E0000);
        if (res == UNSHARED_OBJ) {
            throw new InvalidObjectException("Cannot read back reference to unshared object");
        }
        return res;
    }

    private void registerObjectRead(Object obj, int handle, boolean unshared) throws IOException {
        int size;
        if (unshared) {
            obj = UNSHARED_OBJ;
        }
        int index = handle - 0x7E0000;
        for (size = this.objectsRead.size(); index > size; ++size) {
            this.objectsRead.add(null);
        }
        if (index == size) {
            this.objectsRead.add(obj);
        } else {
            this.objectsRead.set(index, obj);
        }
    }

    public synchronized void registerValidation(ObjectInputValidation object, int priority) throws NotActiveException, InvalidObjectException {
        Object instanceBeingRead = this.currentObject;
        if (instanceBeingRead == null && this.nestedLevels == 0) {
            throw new NotActiveException();
        }
        if (object == null) {
            throw new InvalidObjectException("Callback object cannot be null");
        }
        InputValidationDesc desc = new InputValidationDesc();
        desc.validator = object;
        desc.priority = priority;
        if (this.validations == null) {
            this.validations = new InputValidationDesc[1];
            this.validations[0] = desc;
        } else {
            int i;
            for (i = 0; i < this.validations.length; ++i) {
                InputValidationDesc validation = this.validations[i];
                if (priority >= validation.priority) break;
            }
            InputValidationDesc[] oldValidations = this.validations;
            int currentSize = oldValidations.length;
            this.validations = new InputValidationDesc[currentSize + 1];
            System.arraycopy(oldValidations, 0, this.validations, 0, i);
            System.arraycopy(oldValidations, i, this.validations, i + 1, currentSize - i);
            this.validations[i] = desc;
        }
    }

    private void resetSeenObjects() {
        this.objectsRead = new ArrayList();
        this.nextHandle = 0x7E0000;
        this.primitiveData = this.emptyStream;
    }

    private void resetState() {
        this.resetSeenObjects();
        this.hasPushbackTC = false;
        this.pushbackTC = 0;
    }

    protected Class<?> resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
        String className;
        Class<?> cls = osClass.forClass();
        if (cls == null && (cls = PRIMITIVE_CLASSES.get(className = osClass.getName())) == null) {
            cls = Class.forName(className, true, this.callerClassLoader);
        }
        return cls;
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    @Override
    public int skipBytes(int length) throws IOException {
        long skipped;
        if (this.input == null) {
            throw new NullPointerException("source stream is null");
        }
        for (int offset = 0; offset < length; offset += (int)skipped) {
            this.checkReadPrimitiveTypes();
            skipped = this.primitiveData.skip(length - offset);
            if (skipped != 0L) continue;
            return offset;
        }
        return length;
    }

    private void verifyAndInit(ObjectStreamClass loadedStreamClass) throws InvalidClassException {
        String localClassBaseName;
        Class<?> localClass = loadedStreamClass.forClass();
        ObjectStreamClass localStreamClass = ObjectStreamClass.lookupStreamClass(localClass);
        if (loadedStreamClass.getSerialVersionUID() != localStreamClass.getSerialVersionUID()) {
            throw new InvalidClassException(loadedStreamClass.getName(), "Incompatible class (SUID): " + loadedStreamClass + " but expected " + localStreamClass);
        }
        String loadedClassBaseName = ObjectInputStream.getBaseName(loadedStreamClass.getName());
        if (!loadedClassBaseName.equals(localClassBaseName = ObjectInputStream.getBaseName(localStreamClass.getName()))) {
            throw new InvalidClassException(loadedStreamClass.getName(), String.format("Incompatible class (base name): %s but expected %s", loadedClassBaseName, localClassBaseName));
        }
        loadedStreamClass.initPrivateFields(localStreamClass);
    }

    private static String getBaseName(String fullName) {
        int k = fullName.lastIndexOf(46);
        if (k == -1 || k == fullName.length() - 1) {
            return fullName;
        }
        return fullName.substring(k + 1);
    }

    private static void checkedSetSuperClassDesc(ObjectStreamClass desc, ObjectStreamClass superDesc) throws StreamCorruptedException {
        if (desc.equals(superDesc)) {
            throw new StreamCorruptedException();
        }
        desc.setSuperclass(superDesc);
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("void", Void.TYPE);
        bootstrapLoader = Object.class.getClassLoader();
        systemLoader = ClassLoader.getSystemClassLoader();
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }

    static class InputValidationDesc {
        ObjectInputValidation validator;
        int priority;

        InputValidationDesc() {
        }
    }
}

