/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.internal.FileHandler;
import java.net.internal.HttpHandler;
import java.net.internal.UrlUtils;
import java.util.Hashtable;

public final class URL
implements Serializable {
    private static URLStreamHandlerFactory streamHandlerFactory;
    private static final Hashtable<String, URLStreamHandler> streamHandlers;
    private String protocol;
    private String authority;
    private String host;
    private int port = -1;
    private String file;
    private String ref;
    private transient String userInfo;
    private transient String path;
    private transient String query;
    transient URLStreamHandler streamHandler;
    private transient int hashCode;

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        if (streamHandlerFactory != null) {
            throw new Error("Factory already set");
        }
        streamHandlers.clear();
        streamHandlerFactory = factory;
    }

    public URL(String spec) throws MalformedURLException {
        this((URL)null, spec, null);
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        int schemeSpecificPartStart;
        if (spec == null) {
            throw new MalformedURLException();
        }
        if (handler != null) {
            this.streamHandler = handler;
        }
        spec = spec.trim();
        this.protocol = UrlUtils.getSchemePrefix(spec);
        int n = schemeSpecificPartStart = this.protocol != null ? this.protocol.length() + 1 : 0;
        if (this.protocol != null && context != null && !this.protocol.equals(context.protocol)) {
            context = null;
        }
        if (context != null) {
            this.set(context.protocol, context.getHost(), context.getPort(), context.getAuthority(), context.getUserInfo(), context.getPath(), context.getQuery(), context.getRef());
            if (this.streamHandler == null) {
                this.streamHandler = context.streamHandler;
            }
        } else if (this.protocol == null) {
            throw new MalformedURLException("Protocol not found: " + spec);
        }
        if (this.streamHandler == null) {
            this.setupStreamHandler();
            if (this.streamHandler == null) {
                throw new MalformedURLException("Unknown protocol: " + this.protocol);
            }
        }
        try {
            this.streamHandler.parseURL(this, spec, schemeSpecificPartStart, spec.length());
        }
        catch (Exception e) {
            throw new MalformedURLException(e.toString());
        }
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file, null);
    }

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        if (port < -1) {
            throw new MalformedURLException("port < -1: " + port);
        }
        if (protocol == null) {
            throw new NullPointerException("protocol == null");
        }
        if (host != null && host.contains(":") && host.charAt(0) != '[') {
            host = "[" + host + "]";
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        int hash = (file = UrlUtils.authoritySafePath(host, file)).indexOf("#");
        if (hash != -1) {
            this.file = file.substring(0, hash);
            this.ref = file.substring(hash + 1);
        } else {
            this.file = file;
        }
        this.fixURL(false);
        if (handler == null) {
            this.setupStreamHandler();
            if (this.streamHandler == null) {
                throw new MalformedURLException("Unknown protocol: " + protocol);
            }
        } else {
            this.streamHandler = handler;
        }
    }

    void fixURL(boolean fixHost) {
        int index;
        if (this.host != null && this.host.length() > 0) {
            this.authority = this.host;
            if (this.port != -1) {
                this.authority = this.authority + ":" + this.port;
            }
        }
        if (fixHost) {
            if (this.host != null && (index = this.host.lastIndexOf(64)) > -1) {
                this.userInfo = this.host.substring(0, index);
                this.host = this.host.substring(index + 1);
            } else {
                this.userInfo = null;
            }
        }
        if (this.file != null && (index = this.file.indexOf(63)) > -1) {
            this.query = this.file.substring(index + 1);
            this.path = this.file.substring(0, index);
        } else {
            this.query = null;
            this.path = this.file;
        }
    }

    protected void set(String protocol, String host, int port, String file, String ref) {
        if (this.protocol == null) {
            this.protocol = protocol;
        }
        this.host = host;
        this.file = file;
        this.port = port;
        this.ref = ref;
        this.hashCode = 0;
        this.fixURL(true);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.streamHandler.equals(this, (URL)o);
    }

    public boolean sameFile(URL otherURL) {
        return this.streamHandler.sameFile(this, otherURL);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.streamHandler.hashCode(this);
        }
        return this.hashCode;
    }

    void setupStreamHandler() {
        this.streamHandler = streamHandlers.get(this.protocol);
        if (this.streamHandler != null) {
            return;
        }
        if (streamHandlerFactory != null) {
            this.streamHandler = streamHandlerFactory.createURLStreamHandler(this.protocol);
            if (this.streamHandler != null) {
                streamHandlers.put(this.protocol, this.streamHandler);
                return;
            }
        }
        String packageList = System.getProperty("java.protocol.handler.pkgs");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (packageList != null && contextClassLoader != null) {
            for (String packageName : packageList.split("\\|")) {
                String className = packageName + "." + this.protocol + ".Handler";
                try {
                    Class<?> c = contextClassLoader.loadClass(className);
                    this.streamHandler = (URLStreamHandler)c.newInstance();
                    if (this.streamHandler != null) {
                        streamHandlers.put(this.protocol, this.streamHandler);
                    }
                    return;
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (this.protocol.equals("file")) {
            this.streamHandler = new FileHandler();
        } else if (this.protocol.equals("http") || this.protocol.equals("https")) {
            this.streamHandler = new HttpHandler();
        }
        if (this.streamHandler != null) {
            streamHandlers.put(this.protocol, this.streamHandler);
        }
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] types) throws IOException {
        return this.openConnection().getContent(types);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public URLConnection openConnection() throws IOException {
        return this.streamHandler.openConnection(this);
    }

    public URLConnection openConnection(Proxy proxy) throws IOException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy == null");
        }
        return this.streamHandler.openConnection(this, proxy);
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.toExternalForm());
    }

    public URI toURILenient() throws URISyntaxException {
        if (this.streamHandler == null) {
            throw new IllegalStateException(this.protocol);
        }
        return new URI(this.streamHandler.toExternalForm(this, true));
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        if (this.streamHandler == null) {
            return "unknown protocol(" + this.protocol + ")://" + this.host + this.file;
        }
        return this.streamHandler.toExternalForm(this);
    }

    public int getEffectivePort() {
        return URI.getEffectivePort(this.protocol, this.port);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.streamHandler.getDefaultPort();
    }

    public String getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRef() {
        return this.ref;
    }

    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        String file = path;
        if (query != null && !query.isEmpty()) {
            file = file + "?" + query;
        }
        this.set(protocol, host, port, file, ref);
        this.authority = authority;
        this.userInfo = userInfo;
        this.path = path;
        this.query = query;
    }

    static {
        streamHandlers = new Hashtable();
    }
}

