/*
 * Decompiled with CFR 0.152.
 */
package java.net.internal;

import com.jtransc.text.internal.IntegralToString;
import java.io.ByteArrayOutputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class UriCodec {
    protected abstract boolean isRetained(char var1);

    public final String validate(String uri, int start, int end, String name) throws URISyntaxException {
        int i = start;
        while (i < end) {
            char ch = uri.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || this.isRetained(ch)) {
                ++i;
                continue;
            }
            if (ch == '%') {
                if (i + 2 >= end) {
                    throw new URISyntaxException(uri, "Incomplete % sequence in " + name, i);
                }
                int d1 = UriCodec.hexToInt(uri.charAt(i + 1));
                int d2 = UriCodec.hexToInt(uri.charAt(i + 2));
                if (d1 == -1 || d2 == -1) {
                    throw new URISyntaxException(uri, "Invalid % sequence: " + uri.substring(i, i + 3) + " in " + name, i);
                }
                i += 3;
                continue;
            }
            throw new URISyntaxException(uri, "Illegal character in " + name, i);
        }
        return uri.substring(start, end);
    }

    public static void validateSimple(String s, String legal) throws URISyntaxException {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || legal.indexOf(ch) > -1) continue;
            throw new URISyntaxException(s, "Illegal character", i);
        }
    }

    private void appendEncoded(StringBuilder builder, String s, Charset charset, boolean isPartiallyEncoded) {
        if (s == null) {
            throw new NullPointerException("s == null");
        }
        int escapeStart = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || this.isRetained(c) || c == '%' && isPartiallyEncoded) {
                if (escapeStart != -1) {
                    UriCodec.appendHex(builder, s.substring(escapeStart, i), charset);
                    escapeStart = -1;
                }
                if (c == '%' && isPartiallyEncoded) {
                    builder.append(s, i, Math.min(i + 3, s.length()));
                    i += 2;
                    continue;
                }
                if (c == ' ') {
                    builder.append('+');
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (escapeStart != -1) continue;
            escapeStart = i;
        }
        if (escapeStart != -1) {
            UriCodec.appendHex(builder, s.substring(escapeStart, s.length()), charset);
        }
    }

    public final String encode(String s, Charset charset) {
        StringBuilder builder = new StringBuilder(s.length() + 16);
        this.appendEncoded(builder, s, charset, false);
        return builder.toString();
    }

    public final void appendEncoded(StringBuilder builder, String s) {
        this.appendEncoded(builder, s, StandardCharsets.UTF_8, false);
    }

    public final void appendPartiallyEncoded(StringBuilder builder, String s) {
        this.appendEncoded(builder, s, StandardCharsets.UTF_8, true);
    }

    public static String decode(String s, boolean convertPlus, Charset charset, boolean throwOnFailure) {
        if (!(s.indexOf(37) != -1 || convertPlus && s.indexOf(43) != -1)) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            int c = s.charAt(i);
            if (c == 37) {
                do {
                    int d2;
                    int d1;
                    if (i + 2 < s.length() && (d1 = UriCodec.hexToInt(s.charAt(i + 1))) != -1 && (d2 = UriCodec.hexToInt(s.charAt(i + 2))) != -1) {
                        out.write((byte)((d1 << 4) + d2));
                        continue;
                    }
                    if (throwOnFailure) {
                        throw new IllegalArgumentException("Invalid % sequence at " + i + ": " + s);
                    }
                    byte[] replacement = "\ufffd".getBytes(charset);
                    out.write(replacement, 0, replacement.length);
                } while ((i += 3) < s.length() && s.charAt(i) == '%');
                result.append(new String(out.toByteArray(), charset));
                out.reset();
                continue;
            }
            if (convertPlus && c == 43) {
                c = 32;
            }
            result.append((char)c);
            ++i;
        }
        return result.toString();
    }

    private static int hexToInt(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return 10 + (c - 97);
        }
        if ('A' <= c && c <= 'F') {
            return 10 + (c - 65);
        }
        return -1;
    }

    public static String decode(String s) {
        return UriCodec.decode(s, false, StandardCharsets.UTF_8, true);
    }

    private static void appendHex(StringBuilder builder, String s, Charset charset) {
        for (byte b : s.getBytes(charset)) {
            UriCodec.appendHex(builder, b);
        }
    }

    private static void appendHex(StringBuilder sb, byte b) {
        sb.append('%');
        sb.append(IntegralToString.byteToHexString((byte)b, (boolean)true));
    }
}

