/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import java.io.Serializable;
import regexodus.Category;
import regexodus.Pattern;
import regexodus.PatternSyntaxException;

class Pretokenizer
implements Serializable {
    private static final long serialVersionUID = 2528136757932720807L;
    private static final int START = 1;
    static final int END = 2;
    static final int PLAIN_GROUP = 3;
    static final int POS_LOOKAHEAD = 4;
    static final int NEG_LOOKAHEAD = 5;
    static final int POS_LOOKBEHIND = 6;
    static final int NEG_LOOKBEHIND = 7;
    static final int INDEPENDENT_REGEX = 8;
    static final int COMMENT = 9;
    static final int CONDITIONAL_GROUP = 10;
    static final int FLAGS = 11;
    static final int CLASS_GROUP = 12;
    static final int NAMED_GROUP = 13;
    int tOffset;
    int tOutside;
    private int skip;
    private int offset;
    private int end;
    int c;
    int ttype = 1;
    private char[] data;
    private int flags;
    private boolean flagsChanged;
    String groupName;
    boolean groupDeclared;

    Pretokenizer(char[] data, int offset, int end) {
        if (offset < 0 || end > data.length) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", end=" + end + ", length=" + data.length);
        }
        this.offset = offset;
        this.end = end;
        this.tOffset = offset;
        this.tOutside = offset;
        this.data = data;
    }

    int flags(int def) {
        return this.flagsChanged ? this.flags : def;
    }

    /*
     * Enabled aggressive block sorting
     */
    void next() throws PatternSyntaxException {
        int tOffset = this.tOutside;
        int skip = this.skip;
        tOffset += skip;
        this.flagsChanged = false;
        int end = this.end;
        char[] data = this.data;
        boolean esc = false;
        int ender = 125;
        int i = tOffset;
        while (true) {
            block51: {
                char c1;
                block54: {
                    block53: {
                        char c;
                        block52: {
                            if (i >= end) {
                                this.ttype = 2;
                                this.tOffset = tOffset;
                                this.tOutside = end;
                                return;
                            }
                            c = data[i];
                            if (!esc) break block52;
                            if (c == 'Q') break block53;
                            esc = false;
                            break block51;
                        }
                        switch (c) {
                            case '\\': {
                                esc = true;
                                break;
                            }
                            case ')': 
                            case '|': {
                                this.ttype = c;
                                this.tOffset = tOffset;
                                this.tOutside = i;
                                this.skip = 1;
                                return;
                            }
                            case '(': {
                                if (i + 2 < end && data[i + 1] == '?') {
                                    c1 = data[i + 2];
                                    block6 : switch (c1) {
                                        case ':': {
                                            this.ttype = 3;
                                            skip = 3;
                                            break;
                                        }
                                        case '=': {
                                            this.ttype = 4;
                                            skip = 3;
                                            break;
                                        }
                                        case '!': {
                                            this.ttype = 5;
                                            skip = 3;
                                            break;
                                        }
                                        case '<': {
                                            c1 = data[i + 3];
                                            switch (c1) {
                                                case '=': {
                                                    this.ttype = 6;
                                                    skip = 4;
                                                    break block6;
                                                }
                                                case '!': {
                                                    this.ttype = 7;
                                                    skip = 4;
                                                    break block6;
                                                }
                                            }
                                            int p = i + 3;
                                            skip = 4;
                                            int nstart = p;
                                            if (Category.N.contains(c1)) {
                                                throw new PatternSyntaxException("number at the start of a named group");
                                            }
                                            while (Category.IdentifierPart.contains(c1)) {
                                                c1 = data[++p];
                                                ++skip;
                                                if (p != end) continue;
                                                throw new PatternSyntaxException("malformed named group");
                                            }
                                            int nend = p;
                                            if (c1 != '>') {
                                                throw new PatternSyntaxException("'>' expected at " + (p - i) + " in " + new String(data, i, end - i));
                                            }
                                            this.groupName = new String(data, nstart, nend - nstart);
                                            this.groupDeclared = true;
                                            this.ttype = 13;
                                            break;
                                        }
                                        case '>': {
                                            this.ttype = 8;
                                            skip = 3;
                                            break;
                                        }
                                        case '#': {
                                            this.ttype = 9;
                                            skip = 3;
                                            break;
                                        }
                                        case '(': {
                                            this.ttype = 10;
                                            skip = 2;
                                            break;
                                        }
                                        case '[': {
                                            this.ttype = 12;
                                            skip = 2;
                                            break;
                                        }
                                        default: {
                                            block31: for (int p = i + 2; p < end; ++p) {
                                                char c2 = data[p];
                                                switch (c2) {
                                                    case '-': 
                                                    case 'X': 
                                                    case 'i': 
                                                    case 'm': 
                                                    case 's': 
                                                    case 'u': 
                                                    case 'x': {
                                                        continue block31;
                                                    }
                                                    case ':': {
                                                        int mOff = i + 2;
                                                        int mLen = p - mOff;
                                                        if (mLen > 0) {
                                                            this.flags = Pattern.parseFlags(data, mOff, mLen);
                                                            this.flagsChanged = true;
                                                        }
                                                        this.ttype = 3;
                                                        skip = mLen + 3;
                                                        break block6;
                                                    }
                                                    case ')': {
                                                        int mOff = i + 2;
                                                        int mLen = p - mOff;
                                                        this.flags = Pattern.parseFlags(data, mOff, mLen);
                                                        this.flagsChanged = true;
                                                        this.ttype = 11;
                                                        skip = mLen + 3;
                                                        break block6;
                                                    }
                                                    default: {
                                                        throw new PatternSyntaxException("wrong char after \"(?\": " + c2);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else if (i + 2 < end && data[i + 1] == '{') {
                                    boolean isDecl;
                                    int p = i + 2;
                                    skip = 3;
                                    c = data[p];
                                    while (Category.Z.contains(c)) {
                                        c = data[++p];
                                        ++skip;
                                        if (p != end) continue;
                                        throw new PatternSyntaxException("malformed named group");
                                    }
                                    if (c == '=') {
                                        isDecl = false;
                                        c = data[++p];
                                        ++skip;
                                        if (p == end) {
                                            throw new PatternSyntaxException("malformed named group");
                                        }
                                    } else {
                                        isDecl = true;
                                    }
                                    int nstart = p;
                                    while (Category.IdentifierPart.contains(c)) {
                                        c = data[++p];
                                        ++skip;
                                        if (p != end) continue;
                                        throw new PatternSyntaxException("malformed named group");
                                    }
                                    int nend = p;
                                    while (Category.Z.contains(c)) {
                                        c = data[++p];
                                        ++skip;
                                        if (p != end) continue;
                                        throw new PatternSyntaxException("malformed named group");
                                    }
                                    if (c != '}') {
                                        throw new PatternSyntaxException("'}' expected at " + (p - i) + " in " + new String(data, i, end - i));
                                    }
                                    this.groupName = new String(data, nstart, nend - nstart);
                                    this.groupDeclared = isDecl;
                                    this.ttype = 13;
                                } else {
                                    this.ttype = 40;
                                    skip = 1;
                                }
                                this.tOffset = tOffset;
                                this.tOutside = i;
                                this.skip = skip;
                                return;
                            }
                            case '[': {
                                break block54;
                            }
                        }
                        break block51;
                    }
                    while (i < end) {
                        c1 = data[i];
                        if (c1 == '\\' && i + 1 < end && data[i + 1] == 'E') {
                            ++i;
                            esc = false;
                            break block51;
                        }
                        ++i;
                    }
                    break block51;
                }
                block36: while (true) {
                    if (i == end) {
                        throw new PatternSyntaxException("malformed character class");
                    }
                    c1 = data[i];
                    switch (c1) {
                        case '\\': {
                            ++i;
                            break;
                        }
                        case ']': {
                            break block36;
                        }
                    }
                    ++i;
                }
            }
            ++i;
        }
    }
}

