/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.text.JTranscStringTools;

public final class Double
extends Number
implements Comparable<Double> {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_NORMAL = 2.2250738585072014E-308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_EXPONENT = -1022;
    public static final int SIZE = 64;
    public static final int BYTES = 8;
    public static final Class<Double> TYPE = Class.getPrimitiveClass("double");
    private final double value;

    public static String toString(double d) {
        return JTranscStringTools.toString((double)d);
    }

    public static native String toHexString(double var0);

    public static Double valueOf(String s) {
        return Double.parseDouble(s);
    }

    @JTranscKeep
    public static Double valueOf(double d) {
        return new Double(d);
    }

    @HaxeMethodBody(value="return Std.parseFloat(p0._str);")
    @JTranscMethodBody(target="js", value={"return parseFloat(N.istr(p0));"})
    public static native double parseDouble(String var0);

    @HaxeMethodBody(value="return Math.isNaN(p0);")
    @JTranscMethodBody(target="js", value={"return isNaN(p0);"})
    public static native boolean isNaN(double var0);

    @HaxeMethodBody(value="return Math.isFinite(p0);")
    @JTranscMethodBody(target="js", value={"return isFinite(p0);"})
    private static native boolean _isFinite(double var0);

    public static boolean isInfinite(double v) {
        return !Double.isNaN(v) && !Double._isFinite(v);
    }

    public static boolean isFinite(double d) {
        return Double._isFinite(d);
    }

    public Double(double value) {
        this.value = value;
    }

    public Double(String s) {
        this.value = Double.parseDouble(s);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Double.hashCode(this);
    }

    public static int hashCode(double value) {
        return (int)Double.doubleToLongBits(value);
    }

    public boolean equals(Object obj) {
        return obj instanceof Double && Double.doubleToLongBits(((Float)obj).doubleValue()) == Double.doubleToLongBits(this);
    }

    @HaxeMethodBody(value="return HaxeNatives.doubleToLongBits(p0);")
    @JTranscMethodBody(target="js", value={"return N.doubleToLongBits(p0);"})
    public static native long doubleToLongBits(double var0);

    @HaxeMethodBody(value="return HaxeNatives.doubleToLongBits(p0);")
    @JTranscMethodBody(target="js", value={"return N.doubleToLongBits(p0);"})
    public static native long doubleToRawLongBits(double var0);

    @HaxeMethodBody(value="return HaxeNatives.longBitsToDouble(p0);")
    @JTranscMethodBody(target="js", value={"return N.longBitsToDouble(p0);"})
    public static native double longBitsToDouble(long var0);

    @Override
    public int compareTo(Double that) {
        return Double.compare(this.value, that.value);
    }

    public static int compare(double d1, double d2) {
        long b2;
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        long b1 = Double.doubleToLongBits(d1);
        return b1 == (b2 = Double.doubleToLongBits(d2)) ? 0 : (b1 < b2 ? -1 : 1);
    }

    public static double sum(double a, double b) {
        return a + b;
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }
}

