/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscInline;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBody;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;

    private Math() {
    }

    @JTranscInline
    @HaxeMethodBody(value="return Math.sin(p0);")
    @JTranscMethodBody(target="js", value={"return Math.sin(p0);"})
    public static native double sin(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.cos(p0);")
    @JTranscMethodBody(target="js", value={"return Math.cos(p0);"})
    public static native double cos(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.tan(p0);")
    @JTranscMethodBody(target="js", value={"return Math.tan(p0);"})
    public static native double tan(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.asin(p0);")
    @JTranscMethodBody(target="js", value={"return Math.asin(p0);"})
    public static native double asin(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.acos(p0);")
    @JTranscMethodBody(target="js", value={"return Math.acos(p0);"})
    public static native double acos(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.atan(p0);")
    @JTranscMethodBody(target="js", value={"return Math.atan(p0);"})
    public static native double atan(double var0);

    @HaxeMethodBody(value="return p0 / 180.0 * Math.PI;")
    @JTranscMethodBody(target="js", value={"return p0 / 180.0 * Math.PI;"})
    public static native double toRadians(double var0);

    @HaxeMethodBody(value="return p0 * 180.0 / Math.PI;")
    @JTranscMethodBody(target="js", value={"return p0 * 180.0 / Math.PI;"})
    public static native double toDegrees(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.exp(p0);")
    @JTranscMethodBody(target="js", value={"return Math.exp(p0);"})
    public static native double exp(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.log(p0);")
    @JTranscMethodBody(target="js", value={"return Math.log(p0);"})
    public static native double log(double var0);

    @HaxeMethodBody(value="return Math.log(p0) / Math.log(10);")
    @JTranscMethodBody(target="js", value={"return Math.log10(p0);"})
    public static native double log10(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.sqrt(p0);")
    @JTranscMethodBody(target="js", value={"return Math.sqrt(p0);"})
    public static native double sqrt(double var0);

    public static double cbrt(double x) {
        double y = Math.pow(Math.abs(x), 0.3333333333333333);
        return x < 0.0 ? -y : y;
    }

    public static native double IEEEremainder(double var0, double var2);

    @JTranscInline
    @HaxeMethodBody(value="return Math.ceil(p0);")
    @JTranscMethodBody(target="js", value={"return Math.ceil(p0);"})
    public static native double ceil(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.floor(p0);")
    @JTranscMethodBody(target="js", value={"return Math.floor(p0);"})
    public static native double floor(double var0);

    public static double rint(double a) {
        double r = (int)a;
        if (a < 0.0 && r == 0.0) {
            return -0.0;
        }
        return r;
    }

    @JTranscInline
    @HaxeMethodBody(value="return Math.atan2(p0, p1);")
    @JTranscMethodBody(target="js", value={"return Math.atan2(p0, p1);"})
    public static native double atan2(double var0, double var2);

    @JTranscInline
    @HaxeMethodBody(value="return Math.pow(p0, p1);")
    @JTranscMethodBody(target="js", value={"return Math.pow(p0, p1);"})
    public static native double pow(double var0, double var2);

    @JTranscInline
    @HaxeMethodBody(value="return Math.round(p0);")
    @JTranscMethodBody(target="js", value={"return Math.round(p0);"})
    public static native int round(float var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.round(p0);")
    public static native long round(double var0);

    @JTranscInline
    @HaxeMethodBody(value="return Math.random();")
    @JTranscMethodBody(target="js", value={"return Math.random();"})
    public static native double random();

    public static native int addExact(int var0, int var1);

    public static native long addExact(long var0, long var2);

    public static native int subtractExact(int var0, int var1);

    public static native long subtractExact(long var0, long var2);

    public static native int multiplyExact(int var0, int var1);

    public static native long multiplyExact(long var0, long var2);

    public static native int incrementExact(int var0);

    public static native long incrementExact(long var0);

    public static native int decrementExact(int var0);

    public static native long decrementExact(long var0);

    public static native int negateExact(int var0);

    public static native long negateExact(long var0);

    public static native int toIntExact(long var0);

    public static native int floorDiv(int var0, int var1);

    public static native long floorDiv(long var0, long var2);

    public static native int floorMod(int var0, int var1);

    public static native long floorMod(long var0, long var2);

    public static int abs(int a) {
        return a >= 0 ? a : -a;
    }

    public static long abs(long a) {
        return a >= 0L ? a : -a;
    }

    public static float abs(float a) {
        return a >= 0.0f ? a : -a;
    }

    public static double abs(double a) {
        return a >= 0.0 ? a : -a;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static double max(double a, double b) {
        return a > b ? a : b;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static long min(long a, long b) {
        return a < b ? a : b;
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static native double ulp(double var0);

    public static native float ulp(float var0);

    @HaxeMethodBody(value="return (p0 == 0) ? 0 : ((p0 < 0) ? -1 : 1);")
    @JTranscMethodBody(target="js", value={"return Math.sign(p0);"})
    public static double signum(double v) {
        if (v < 0.0) {
            return -1.0;
        }
        if (v > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    @HaxeMethodBody(value="return (p0 == 0) ? 0 : ((p0 < 0) ? -1 : 1);")
    @JTranscMethodBody(target="js", value={"return Math.sign(p0);"})
    public static float signum(float v) {
        if (v < 0.0f) {
            return -1.0f;
        }
        if (v > 0.0f) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static native double sinh(double var0);

    public static native double cosh(double var0);

    public static native double tanh(double var0);

    @HaxeMethodBody(value="return Math.sqrt((p0 * p0) + (p1 * p1));")
    @JTranscMethodBody(target="js", value={"return Math.hypot(p0, p1);"})
    public static native double hypot(double var0, double var2);

    public static native double expm1(double var0);

    public static native double log1p(double var0);

    public static double copySign(double magnitude, double sign) {
        long magnitudeBits = Double.doubleToRawLongBits(magnitude);
        long signBits = Double.doubleToRawLongBits(sign);
        magnitudeBits = magnitudeBits & Long.MAX_VALUE | signBits & Long.MIN_VALUE;
        return Double.longBitsToDouble(magnitudeBits);
    }

    public static float copySign(float magnitude, float sign) {
        int magnitudeBits = Float.floatToRawIntBits(magnitude);
        int signBits = Float.floatToRawIntBits(sign);
        magnitudeBits = magnitudeBits & Integer.MAX_VALUE | signBits & Integer.MIN_VALUE;
        return Float.intBitsToFloat(magnitudeBits);
    }

    public static native int getExponent(float var0);

    public static native int getExponent(double var0);

    public static native double nextAfter(double var0, double var2);

    public static native float nextAfter(float var0, double var1);

    public static native double nextUp(double var0);

    public static native float nextUp(float var0);

    public static native double nextDown(double var0);

    public static native float nextDown(float var0);

    public static native double scalb(double var0, int var2);

    public static native float scalb(float var0, int var1);
}

