/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.jtransc.util.JTranscStringReader;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class SimpleDateFormat
extends DateFormat {
    private final List<String> patternChunks;
    private final DateFormatSymbols formatSymbols;

    public SimpleDateFormat() {
        this("", Locale.getDefault());
    }

    public SimpleDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public SimpleDateFormat(String pattern, Locale locale) {
        this(pattern, new DateFormatSymbols(locale));
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatSymbols) {
        this.patternChunks = SimpleDateFormat.compilePattern(pattern);
        this.formatSymbols = formatSymbols;
    }

    private static List<String> compilePattern(String pattern) {
        JTranscStringReader r = new JTranscStringReader(pattern);
        ArrayList<String> out = new ArrayList<String>();
        while (!r.eof()) {
            String result = r.tryRead(new String[]{"YYYY", "yyyy", "MM", "mm", "dd", "HH", "ss", "hh", "M", "m", "s", "z"});
            if (result != null) {
                out.add(result);
                continue;
            }
            out.add(r.read(1));
        }
        return out;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        for (String p : this.patternChunks) {
            String value = null;
            switch (p.charAt(0)) {
                case 'Y': {
                    value = String.valueOf(date.getYear() + 1900);
                    break;
                }
                case 'y': {
                    value = String.valueOf(date.getYear() + 1900);
                    break;
                }
                case 'M': {
                    value = String.valueOf(date.getMonth() + 1);
                    break;
                }
                case 'd': {
                    value = String.valueOf(date.getDate());
                    break;
                }
                case 'H': {
                    value = String.valueOf(date.getHours());
                    break;
                }
                case 'm': {
                    value = String.valueOf(date.getMinutes());
                    break;
                }
                case 's': {
                    value = String.valueOf(date.getSeconds());
                    break;
                }
                case 'z': {
                    value = "CET";
                    break;
                }
            }
            if (value != null) {
                while (value.length() < p.length()) {
                    value = "0" + value;
                }
                toAppendTo.append(value);
                continue;
            }
            toAppendTo.append(p);
        }
        return toAppendTo;
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        int[] fields = new int[17];
        JTranscStringReader r = new JTranscStringReader(source);
        for (String p : this.patternChunks) {
            int field = -1;
            switch (p.charAt(0)) {
                case 'Y': {
                    field = 1;
                    break;
                }
                case 'y': {
                    field = 1;
                    break;
                }
                case 'M': {
                    field = 2;
                    break;
                }
                case 'd': {
                    field = 5;
                    break;
                }
                case 'H': {
                    field = 10;
                    break;
                }
                case 'm': {
                    field = 12;
                    break;
                }
                case 's': {
                    field = 13;
                    break;
                }
                case 'z': {
                    field = 15;
                    break;
                }
            }
            String readed = r.read(p.length());
            if (field < 0) continue;
            try {
                fields[field] = Integer.valueOf(readed);
            }
            catch (NumberFormatException nfe) {}
        }
        pos.setIndex(r.offset);
        return new Date(fields[1] - 1900, fields[2] - 1, fields[5], fields[10], fields[12], fields[13]);
    }
}

