/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import regexodus.Category;
import regexodus.GwtIncompatible;
import regexodus.LAEntry;
import regexodus.MatchIterator;
import regexodus.MatchResult;
import regexodus.MemReg;
import regexodus.Pattern;
import regexodus.PerlSubstitution;
import regexodus.Replacer;
import regexodus.SearchEntry;
import regexodus.Substitution;
import regexodus.Term;
import regexodus.TextBuffer;
import regexodus.ds.IntBitSet;

public class Matcher
implements MatchResult,
Serializable {
    private static final long serialVersionUID = -3628346657932720807L;
    public static final int ANCHOR_START = 1;
    public static final int ANCHOR_LASTMATCH = 2;
    public static final int ANCHOR_END = 4;
    public static final int ACCEPT_INCOMPLETE = 8;
    private static Term startAnchor = new Term(18);
    private static Term lastMatchAnchor = new Term(23);
    private Pattern re;
    private int[] counters;
    private MemReg[] memregs;
    private LAEntry[] lookaheads;
    private int counterCount;
    private int memregCount;
    private int lookaheadCount;
    private char[] data;
    private int offset;
    private int end;
    private int wOffset;
    private int wEnd;
    private boolean shared;
    private SearchEntry top;
    private SearchEntry first;
    private SearchEntry defaultEntry;
    private boolean called;
    private int minQueueLength;
    private CharSequence cache;
    private int cacheOffset;
    private int cacheLength;
    private MemReg prefixBounds;
    private MemReg suffixBounds;
    private MemReg targetBounds;

    public Matcher copy() {
        Matcher m = new Matcher(this.re, this.cache);
        m.wEnd = this.wEnd;
        m.wOffset = this.wOffset;
        m.called = this.called;
        m.offset = this.offset;
        m.end = this.end;
        return m;
    }

    private Matcher() {
    }

    public Matcher(Pattern regex) {
        this.setPattern(regex);
    }

    public Matcher(Pattern regex, CharSequence target) {
        this.setPattern(regex);
        this.setTarget(target);
    }

    public void setPattern(Pattern regex) {
        int lookaheadCount;
        int counterCount;
        int i;
        this.re = regex;
        int memregCount = regex.memregs;
        if (memregCount > 0) {
            MemReg[] memregs = new MemReg[memregCount];
            for (i = 0; i < memregCount; ++i) {
                memregs[i] = new MemReg(-1);
            }
            this.memregs = memregs;
        }
        if ((counterCount = regex.counters) > 0) {
            this.counters = new int[counterCount];
        }
        if ((lookaheadCount = regex.lookaheads) > 0) {
            LAEntry[] lookaheads = new LAEntry[lookaheadCount];
            for (i = 0; i < lookaheadCount; ++i) {
                lookaheads[i] = new LAEntry();
            }
            this.lookaheads = lookaheads;
        }
        this.memregCount = memregCount;
        this.counterCount = counterCount;
        this.lookaheadCount = lookaheadCount;
        this.first = new SearchEntry();
        this.defaultEntry = new SearchEntry();
        this.minQueueLength = regex.stringRepr.length() / 2;
    }

    public final void setTarget(Matcher m, int groupId) {
        MemReg mr = m.bounds(groupId);
        if (mr == null) {
            throw new IllegalArgumentException("group #" + groupId + " is not assigned");
        }
        this.data = m.data;
        this.offset = mr.in;
        this.end = mr.out;
        this.cache = m.cache;
        this.cacheLength = m.cacheLength;
        this.cacheOffset = m.cacheOffset;
        if (m != this) {
            this.shared = true;
            m.shared = true;
        }
        this.init();
    }

    public void setTarget(CharSequence text) {
        this.setTarget(text, 0, text.length());
    }

    public void setTarget(CharSequence text, int start, int len) {
        char[] mychars = this.data;
        if (mychars == null || this.shared || mychars.length < len) {
            this.data = mychars = new char[(int)(1.7f * (float)len)];
            this.shared = false;
        }
        int i = start;
        int p = 0;
        while (i < len) {
            mychars[p] = text.charAt(i);
            ++i;
            ++p;
        }
        this.offset = 0;
        this.end = len;
        this.cache = text;
        this.cacheOffset = -start;
        this.cacheLength = text.length();
        this.init();
    }

    public void setTarget(char[] text, int start, int len) {
        this.setTarget(text, start, len, true);
    }

    public void setTarget(char[] text, int start, int len, boolean shared) {
        this.cache = null;
        this.data = text;
        this.offset = start;
        this.end = start + len;
        this.shared = shared;
        this.init();
    }

    @GwtIncompatible
    public void setTarget(Reader in, int len) throws IOException {
        int c;
        if (len < 0) {
            this.setAll(in);
            return;
        }
        char[] mychars = this.data;
        boolean shared = this.shared;
        if (mychars == null || shared || mychars.length < len) {
            mychars = new char[len];
            shared = false;
        }
        int count = 0;
        while ((c = in.read(mychars, count, len)) >= 0) {
            count += c;
            if ((len -= c) != 0) continue;
        }
        this.setTarget(mychars, 0, count, shared);
    }

    @GwtIncompatible
    public void setAll(Reader in) throws IOException {
        int c;
        int free;
        char[] mychars = this.data;
        if (mychars == null || this.shared) {
            free = 1024;
            mychars = new char[1024];
        } else {
            free = mychars.length;
        }
        int count = 0;
        while ((c = in.read(mychars, count, free)) >= 0) {
            count += c;
            if ((free -= c) != 0) continue;
            int newsize = count * 3;
            char[] newchars = new char[newsize];
            System.arraycopy(mychars, 0, newchars, 0, count);
            mychars = newchars;
            free = newsize - count;
        }
        this.setTarget(mychars, 0, count, false);
    }

    public String getString(int start, int end) {
        if (this.cache != null) {
            int co = this.cacheOffset;
            return this.cache.toString().substring(start - co, end - co);
        }
        int tOffset = this.offset;
        int tLen = this.end - tOffset;
        char[] data = this.data;
        if (end - start >= tLen / 3) {
            this.cache = new String(data);
            String src = new String(data, tOffset, tLen);
            this.cacheOffset = tOffset;
            this.cacheLength = tLen;
            return src.toString();
        }
        return new String(data, start, end - start);
    }

    public final boolean matchesPrefix() {
        this.setPosition(0);
        return this.search(13);
    }

    public final boolean isStart() {
        return this.matchesPrefix();
    }

    public final boolean matches() {
        if (this.called) {
            this.setPosition(0);
        }
        return this.search(5);
    }

    public final boolean matches(String s) {
        this.setTarget(s);
        return this.search(5);
    }

    public void setPosition(int pos) {
        this.wOffset = this.offset + pos;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    public final boolean find() {
        if (this.called) {
            this.skip();
        }
        return this.search(0);
    }

    public boolean find(int anchors) {
        if (this.called) {
            this.skip();
        }
        return this.search(anchors);
    }

    public MatchIterator findAll() {
        return this.findAll(0);
    }

    public MatchIterator findAll(final int options) {
        return new MatchIterator(){
            private boolean checked = false;
            private boolean hasMore = false;

            @Override
            public boolean hasMore() {
                if (!this.checked) {
                    this.check();
                }
                return this.hasMore;
            }

            @Override
            public MatchResult nextMatch() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    throw new NoSuchElementException();
                }
                this.checked = false;
                return Matcher.this;
            }

            private void check() {
                this.hasMore = Matcher.this.find(options);
                this.checked = true;
            }

            @Override
            public int count() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    return 0;
                }
                int c = 1;
                while (Matcher.this.find(options)) {
                    ++c;
                }
                this.checked = false;
                return c;
            }
        };
    }

    public final boolean proceed() {
        return this.proceed(0);
    }

    public boolean proceed(int options) {
        if (this.called && this.top == null) {
            ++this.wOffset;
        }
        return this.search(0);
    }

    public void skip() {
        int we = this.wEnd;
        if (this.wOffset == we) {
            if (this.top == null) {
                ++this.wOffset;
                this.flush();
            }
            return;
        }
        this.wOffset = we < 0 ? 0 : we;
        this.flush();
    }

    private void init() {
        this.wOffset = this.offset;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    public void flush() {
        this.top = null;
        this.defaultEntry.reset(0);
        this.first.reset(this.minQueueLength);
        for (int i = this.memregs.length - 1; i > 0; --i) {
            MemReg mr = this.memregs[i];
            mr.out = -1;
            mr.in = -1;
        }
        this.called = false;
    }

    private void rflush() {
        SearchEntry entry = this.top;
        this.top = null;
        MemReg[] memregs = this.memregs;
        int[] counters = this.counters;
        while (entry != null) {
            SearchEntry next = entry.sub;
            SearchEntry.popState(entry, memregs, counters);
            entry = next;
        }
        SearchEntry.popState(this.defaultEntry, memregs, counters);
    }

    public String toString() {
        return this.toString_d();
    }

    @Override
    public Pattern pattern() {
        return this.re;
    }

    @Override
    public String target() {
        return this.getString(this.offset, this.end);
    }

    @Override
    public char[] targetChars() {
        this.shared = true;
        return this.data;
    }

    @Override
    public int targetStart() {
        return this.offset;
    }

    @Override
    public int targetEnd() {
        return this.end;
    }

    public int dataStart() {
        return 0;
    }

    public int dataEnd() {
        return this.data.length;
    }

    @Override
    public char charAt(int i) {
        int in = this.wOffset;
        int out = this.wEnd;
        if (in < 0 || out < in) {
            throw new IllegalStateException("unassigned");
        }
        return this.data[in + i];
    }

    @Override
    public char charAt(int i, int groupId) {
        MemReg mr = this.bounds(groupId);
        if (mr == null) {
            throw new IllegalStateException("group #" + groupId + " is not assigned");
        }
        int in = mr.in;
        if (i < 0 || i > mr.out - in) {
            throw new StringIndexOutOfBoundsException("" + i);
        }
        return this.data[in + i];
    }

    @Override
    public final int length() {
        return this.wEnd - this.wOffset;
    }

    @Override
    public final int start() {
        return this.wOffset - this.offset;
    }

    @Override
    public final int end() {
        return this.wEnd - this.offset;
    }

    @Override
    public String prefix() {
        return this.getString(this.offset, this.wOffset);
    }

    @Override
    public String suffix() {
        return this.getString(this.wEnd, this.end);
    }

    @Override
    public int groupCount() {
        return this.memregs.length - 1;
    }

    @Override
    public String group(int group) {
        MemReg mr = this.bounds(group);
        if (mr == null) {
            return null;
        }
        return this.getString(mr.in, mr.out);
    }

    @Override
    public String group() {
        return this.group(0);
    }

    @Override
    public String group(String name) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("<" + name + "> isn't defined");
        }
        return this.group(id);
    }

    @Override
    public boolean getGroup(int group, TextBuffer tb) {
        return this.getGroup(group, tb, 0);
    }

    @Override
    public boolean getGroup(int group, TextBuffer tb, int modes) {
        MemReg mr = this.bounds(group);
        if (mr == null) {
            return false;
        }
        int in = mr.in;
        if (modes == 0) {
            tb.append(this.data, in, mr.out - in);
        } else {
            char[] working = new char[mr.out - in];
            if ((modes & 2) > 0) {
                int i = working.length - 1;
                int j = in;
                while (i >= 0) {
                    char t = this.data[j];
                    if ((modes & 1) > 0) {
                        t = Category.caseFold(t);
                    }
                    if ((modes & 4) > 0) {
                        t = Category.matchBracket(t);
                    }
                    working[i] = t;
                    --i;
                    ++j;
                }
            } else {
                int i = 0;
                int j = in;
                while (i < working.length) {
                    char t = this.data[j];
                    if ((modes & 1) > 0) {
                        t = Category.caseFold(t);
                    }
                    if ((modes & 4) > 0) {
                        t = Category.matchBracket(t);
                    }
                    working[i] = t;
                    ++i;
                    ++j;
                }
            }
            tb.append(working, 0, working.length);
        }
        return true;
    }

    @Override
    public boolean getGroup(String name, TextBuffer tb) {
        return this.getGroup(name, tb, 0);
    }

    @Override
    public boolean getGroup(String name, TextBuffer tb, int modes) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("unknown group: \"" + name + "\"");
        }
        return this.getGroup((int)id, tb);
    }

    @Override
    public boolean getGroup(int group, StringBuilder sb) {
        return this.getGroup(group, sb, 0);
    }

    @Override
    public boolean getGroup(int group, StringBuilder sb, int modes) {
        MemReg mr = this.bounds(group);
        if (mr == null) {
            return false;
        }
        int in = mr.in;
        if (modes == 0) {
            sb.append(this.data, in, mr.out - in);
        } else {
            char[] working = new char[mr.out - in];
            if ((modes & 2) > 0) {
                int i = working.length - 1;
                int j = in;
                while (i >= 0) {
                    char t = this.data[j];
                    if ((modes & 1) > 0) {
                        t = Category.caseFold(t);
                    }
                    if ((modes & 4) > 0) {
                        t = Category.matchBracket(t);
                    }
                    working[i] = t;
                    --i;
                    ++j;
                }
            } else {
                int i = 0;
                int j = in;
                while (i < working.length) {
                    char t = this.data[j];
                    if ((modes & 1) > 0) {
                        t = Category.caseFold(t);
                    }
                    if ((modes & 4) > 0) {
                        t = Category.matchBracket(t);
                    }
                    working[i] = t;
                    ++i;
                    ++j;
                }
            }
            sb.append(working);
        }
        return true;
    }

    @Override
    public boolean getGroup(String name, StringBuilder sb) {
        return this.getGroup(name, sb, 0);
    }

    @Override
    public boolean getGroup(String name, StringBuilder sb, int modes) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("unknown group: \"" + name + "\"");
        }
        return this.getGroup((int)id, sb);
    }

    public String[] groups() {
        MemReg[] memregs = this.memregs;
        String[] groups = new String[memregs.length];
        for (int i = 0; i < memregs.length; ++i) {
            MemReg mr = memregs[i];
            int out = mr.out;
            int in = mr.in;
            if (in < 0 || mr.out < in) continue;
            groups[i] = this.getString(in, out);
        }
        return groups;
    }

    public ArrayList<String> groupv() {
        MemReg[] memregs = this.memregs;
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < memregs.length; ++i) {
            MemReg mr = this.bounds(i);
            if (mr == null) {
                v.add("empty");
                continue;
            }
            String s = this.getString(mr.in, mr.out);
            v.add(s);
        }
        return v;
    }

    private MemReg bounds(int id) {
        MemReg mr;
        if (id >= this.memregs.length) {
            return null;
        }
        if (id >= 0) {
            mr = this.memregs[id];
        } else {
            switch (id) {
                case -1: {
                    mr = this.prefixBounds;
                    if (mr == null) {
                        this.prefixBounds = mr = new MemReg(-1);
                    }
                    mr.in = this.offset;
                    mr.out = this.wOffset;
                    break;
                }
                case -2: {
                    mr = this.suffixBounds;
                    if (mr == null) {
                        this.suffixBounds = mr = new MemReg(-2);
                    }
                    mr.in = this.wEnd;
                    mr.out = this.end;
                    break;
                }
                case -3: {
                    mr = this.targetBounds;
                    if (mr == null) {
                        this.targetBounds = mr = new MemReg(-3);
                    }
                    mr.in = this.offset;
                    mr.out = this.end;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal group id: " + id + "; must either nonnegative int, or MatchResult.PREFIX, or MatchResult.SUFFIX");
                }
            }
        }
        int in = mr.in;
        if (in < 0 || mr.out < in) {
            return null;
        }
        return mr;
    }

    @Override
    public final boolean isCaptured() {
        return this.wOffset >= 0 && this.wEnd >= this.wOffset;
    }

    @Override
    public final boolean isCaptured(int id) {
        return this.bounds(id) != null;
    }

    @Override
    public final boolean isCaptured(String groupName) {
        Integer id = this.re.groupId(groupName);
        if (id == null) {
            throw new IllegalArgumentException("unknown group: \"" + groupName + "\"");
        }
        return this.isCaptured(id);
    }

    @Override
    public final int length(int id) {
        MemReg mr = this.bounds(id);
        if (mr != null) {
            return mr.out - mr.in;
        }
        return 0;
    }

    @Override
    public final int start(int id) {
        MemReg b = this.bounds(id);
        if (b == null) {
            return -1;
        }
        return b.in - this.offset;
    }

    @Override
    public int start(String name) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("<" + name + "> isn't defined");
        }
        return this.start(id);
    }

    @Override
    public int end(String name) {
        Integer id = this.re.groupId(name);
        if (id == null) {
            throw new IllegalArgumentException("<" + name + "> isn't defined");
        }
        return this.end(id);
    }

    @Override
    public final int end(int id) {
        MemReg b = this.bounds(id);
        if (b == null) {
            return -1;
        }
        return b.out - this.offset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean search(int anchors) {
        SearchEntry actual;
        int i;
        Term term;
        this.called = true;
        int end = this.end;
        int offset = this.offset;
        char[] data = this.data;
        int wOffset = this.wOffset;
        int wEnd = this.wEnd;
        MemReg[] memregs = this.memregs;
        int[] counters = this.counters;
        LAEntry[] lookaheads = this.lookaheads;
        SearchEntry defaultEntry = this.defaultEntry;
        SearchEntry first = this.first;
        SearchEntry top = this.top;
        boolean matchEnd = (anchors & 4) > 0;
        boolean allowIncomplete = (anchors & 8) > 0;
        Pattern re = this.re;
        Term root = re.root;
        if (top == null) {
            if ((anchors & 1) > 0) {
                term = re.root0;
                root = startAnchor;
            } else if ((anchors & 2) > 0) {
                term = re.root0;
                root = lastMatchAnchor;
            } else {
                term = root;
            }
            i = wOffset;
            actual = first;
            SearchEntry.popState(defaultEntry, memregs, counters);
        } else {
            actual = top;
            top = actual.sub;
            term = actual.term;
            i = actual.index;
            SearchEntry.popState(actual, memregs, counters);
        }
        int cnt = actual.cnt;
        int regLen = actual.regLen;
        block55: while (wOffset <= end) {
            block117: {
                block56: while (true) {
                    if (term == null) {
                        this.wOffset = memregs[0].in = wOffset;
                        this.wEnd = memregs[0].out = i;
                        this.top = top;
                        return true;
                    }
                    switch (term.type) {
                        case 8: {
                            int jump = Matcher.find(data, i + term.distance, end, term.target);
                            if (jump < 0) break block55;
                            wOffset = i += jump;
                            if (term.eat) {
                                if (i == end) break;
                                ++i;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 9: {
                            MemReg mr = memregs[term.target.memreg];
                            int sampleOff = mr.in;
                            int sampleLen = mr.out - sampleOff;
                            if (sampleOff < 0 || sampleLen < 0) break;
                            if (sampleLen == 0) {
                                term = term.next;
                                continue block56;
                            }
                            int jump = Matcher.findReg(data, i + term.distance, sampleOff, sampleLen, term.target, end);
                            if (jump < 0) break block55;
                            wOffset = i += jump;
                            if (term.eat && (i += sampleLen) > end) break;
                            term = term.next;
                            continue block56;
                        }
                        case 17: {
                            term = term.next;
                            continue block56;
                        }
                        case 0: {
                            if (i >= end || (re.caseless ? Category.caseFold(data[i]) : data[i]) != term.c) break;
                            ++i;
                            term = term.next;
                            continue block56;
                        }
                        case 4: {
                            if (i >= end) break;
                            ++i;
                            term = term.next;
                            continue block56;
                        }
                        case 5: {
                            char c;
                            if (i >= end || (c = data[i]) == '\r' || c == '\n') break;
                            ++i;
                            term = term.next;
                            continue block56;
                        }
                        case 19: {
                            if (i < end) break;
                            term = term.next;
                            continue block56;
                        }
                        case 20: {
                            if (i >= end) {
                                term = term.next;
                                continue block56;
                            }
                            boolean matches = i >= end | (i + 1 == end && data[i] == '\n') | (i + 2 == end && data[i] == '\r' && data[i + 1] == '\n');
                            if (!matches) break;
                            term = term.next;
                            continue block56;
                        }
                        case 22: {
                            if (i >= end) {
                                term = term.next;
                                continue block56;
                            }
                            char c = data[i];
                            if (c != '\n' && c != '\u0085' && c != '\u2028' && c != '\u2029' && (i >= data.length - 1 || data[i + 1] != '\n' || c != '\r') && c != '\r') break;
                            term = term.next;
                            continue block56;
                        }
                        case 18: {
                            if (i == offset) {
                                term = term.next;
                                continue block56;
                            }
                            if (top == null && term == startAnchor) break block55;
                            break;
                        }
                        case 23: {
                            if (i != wEnd) break block55;
                            term = term.next;
                            continue block56;
                        }
                        case 21: {
                            char c;
                            if (i == offset) {
                                term = term.next;
                                continue block56;
                            }
                            if (i >= end || (c = data[i - 1]) != '\n' && c != '\u0085' && c != '\u2028' && c != '\u2029' && (data[i] != '\n' || c != '\r') && c != '\r') break;
                            term = term.next;
                            continue block56;
                        }
                        case 1: {
                            char c;
                            if (i >= end || ((c = re.caseless ? Category.caseFold(data[i]) : data[i]) > '\u00ff' || !term.bitset.get(c)) ^ term.inverse) break;
                            ++i;
                            term = term.next;
                            continue block56;
                        }
                        case 2: {
                            IntBitSet arr;
                            char c;
                            if (i >= end || (arr = term.bitset2[(c = re.caseless ? Category.caseFold(data[i]) : data[i]) >> 8]) == null || !arr.get(c & 0xFF) ^ term.inverse) break;
                            ++i;
                            term = term.next;
                            continue block56;
                        }
                        case 11: {
                            char c;
                            boolean ch1Meets = false;
                            boolean ch2Meets = false;
                            IntBitSet bitset = term.bitset;
                            int j = i - 1;
                            if (j >= offset) {
                                c = re.caseless ? Category.caseFold(data[j]) : data[j];
                                boolean bl = ch1Meets = c < '\u0100' && bitset.get(c);
                            }
                            if (i < end) {
                                c = re.caseless ? Category.caseFold(data[i]) : data[i];
                                boolean bl = ch2Meets = c < '\u0100' && bitset.get(c);
                            }
                            if (!(ch1Meets ^ ch2Meets ^ term.inverse)) break;
                            term = term.next;
                            continue block56;
                        }
                        case 13: {
                            char c;
                            boolean ch1Meets = false;
                            boolean ch2Meets = false;
                            IntBitSet[] bitset2 = term.bitset2;
                            int j = i - 1;
                            if (j >= offset) {
                                c = re.caseless ? Category.caseFold(data[j]) : data[j];
                                IntBitSet bits = bitset2[c >> 8];
                                boolean bl = ch1Meets = bits != null && bits.get(c & 0xFF);
                            }
                            if (i < end) {
                                c = re.caseless ? Category.caseFold(data[i]) : data[i];
                                IntBitSet bits = bitset2[c >> 8];
                                boolean bl = ch2Meets = bits != null && bits.get(c & 0xFF);
                            }
                            if (!(ch1Meets ^ ch2Meets ^ term.inverse)) break;
                            term = term.next;
                            continue block56;
                        }
                        case 12: {
                            char c;
                            boolean ch1Meets = false;
                            boolean ch2Meets = false;
                            IntBitSet bitset = term.bitset;
                            boolean inv = term.inverse;
                            int j = i - 1;
                            if (j >= offset) {
                                c = re.caseless ? Category.caseFold(data[j]) : data[j];
                                boolean bl = ch1Meets = c < '\u0100' && bitset.get(c);
                            }
                            if (ch1Meets ^ inv) break;
                            if (i < end) {
                                c = re.caseless ? Category.caseFold(data[i]) : data[i];
                                ch2Meets = c < '\u0100' && bitset.get(c);
                            }
                            if (!ch2Meets ^ inv) break;
                            term = term.next;
                            continue block56;
                        }
                        case 14: {
                            IntBitSet bits;
                            char c;
                            boolean ch1Meets = false;
                            boolean ch2Meets = false;
                            IntBitSet[] bitset2 = term.bitset2;
                            boolean inv = term.inverse;
                            int j = i - 1;
                            if (j >= offset) {
                                c = re.caseless ? Category.caseFold(data[j]) : data[j];
                                bits = bitset2[c >> 8];
                                boolean bl = ch1Meets = bits != null && bits.get(c & 0xFF);
                            }
                            if (ch1Meets ^ inv) break;
                            if (i < end) {
                                c = re.caseless ? Category.caseFold(data[i]) : data[i];
                                bits = bitset2[c >> 8];
                                ch2Meets = bits != null && bits.get(c & 0xFF);
                            }
                            if (!ch2Meets ^ inv) break;
                            term = term.next;
                            continue block56;
                        }
                        case 6: 
                        case 7: {
                            int rLen;
                            if (term.memreg >= memregs.length) break;
                            MemReg mr = memregs[term.memreg];
                            int sampleOffset = mr.in;
                            int sampleOutside = mr.out;
                            if (sampleOffset < 0 || (rLen = sampleOutside - sampleOffset) < 0) break;
                            if (rLen == 0) {
                                term = term.next;
                                continue block56;
                            }
                            if (i + rLen > end || !Matcher.compareRegions(data, sampleOffset, i, rLen, end, term)) break;
                            i += rLen;
                            term = term.next;
                            continue block56;
                        }
                        case 45: {
                            cnt = Matcher.repeat(data, i, end, term.target);
                            if (cnt <= 0) {
                                term = term.next;
                                continue block56;
                            }
                            actual.cnt = cnt;
                            actual.term = term.failNext;
                            actual.index = i += cnt;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 46: {
                            cnt = Matcher.repeat(data, i, end, term.target);
                            if (cnt < term.minCount) break;
                            actual.cnt = cnt;
                            actual.term = term.failNext;
                            actual.index = i += cnt;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 47: {
                            int out2 = i + term.maxCount;
                            cnt = Matcher.repeat(data, i, end < out2 ? end : out2, term.target);
                            if (cnt < term.minCount) break;
                            actual.cnt = cnt;
                            actual.term = term.failNext;
                            actual.index = i += cnt;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 48: {
                            int bitset;
                            MemReg mr = memregs[term.memreg];
                            int sampleOffset = mr.in;
                            int sampleOutside = mr.out;
                            if (sampleOffset < 0 || (bitset = sampleOutside - sampleOffset) < 0) break;
                            if (bitset == 0) {
                                term = term.next;
                                continue block56;
                            }
                            cnt = 0;
                            while (Matcher.compareRegions(data, i, sampleOffset, bitset, end, term)) {
                                ++cnt;
                                i += bitset;
                            }
                            if (cnt < term.minCount) break;
                            actual.cnt = cnt;
                            actual.term = term.failNext;
                            actual.index = i;
                            actual.regLen = bitset;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 49: {
                            int bitset;
                            MemReg mr = memregs[term.memreg];
                            int sampleOffset = mr.in;
                            int sampleOutside = mr.out;
                            if (sampleOffset < 0 || (bitset = sampleOutside - sampleOffset) < 0) break;
                            if (bitset == 0) {
                                term = term.next;
                                continue block56;
                            }
                            cnt = 0;
                            for (int countBack = term.maxCount; countBack > 0 && Matcher.compareRegions(data, i, sampleOffset, bitset, end, term); ++cnt, i += bitset, --countBack) {
                            }
                            if (cnt < term.minCount) break;
                            actual.cnt = cnt;
                            actual.term = term.failNext;
                            actual.index = i;
                            actual.regLen = bitset;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 50: {
                            cnt = actual.cnt;
                            if (cnt <= 0) break;
                            actual.cnt = --cnt;
                            actual.index = --i;
                            actual.term = term;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 51: {
                            cnt = actual.cnt;
                            if (cnt <= term.minCount) break;
                            actual.cnt = --cnt;
                            actual.index = --i;
                            actual.term = term;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 52: {
                            int back;
                            cnt = actual.cnt;
                            int minCnt = term.minCount;
                            if (cnt <= minCnt) break;
                            int start = i + term.distance;
                            if (start > end) {
                                int exceed = start - end;
                                if ((cnt -= exceed) <= minCnt) break;
                                i -= exceed;
                            }
                            if ((back = Matcher.findBack(data, i + term.distance, cnt - minCnt, term.target)) < 0) break;
                            if ((cnt -= back) <= minCnt) {
                                i -= back;
                                if (term.eat) {
                                    ++i;
                                }
                                term = term.next;
                                continue block56;
                            }
                            i -= back;
                            actual.cnt = cnt;
                            actual.index = i++;
                            if (term.eat) {
                                // empty if block
                            }
                            actual.term = term;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 53: {
                            int back;
                            cnt = actual.cnt;
                            int minCnt = term.minCount;
                            if (cnt <= minCnt) break;
                            int start = i + term.distance;
                            if (start > end) {
                                int exceed = start - end;
                                if ((cnt -= exceed) <= minCnt) break;
                                i -= exceed;
                            }
                            MemReg mr = memregs[term.target.memreg];
                            int sampleOff = mr.in;
                            int sampleLen = mr.out - sampleOff;
                            if (sampleOff < 0 || sampleLen < 0) {
                                actual.cnt = --cnt;
                                actual.index = --i;
                                actual.term = term;
                                top = actual;
                                actual = top.on;
                                if (actual == null) {
                                    top.on = actual = new SearchEntry();
                                    actual.sub = top;
                                }
                                term = term.next;
                                continue block56;
                            }
                            if (sampleLen == 0) {
                                back = -1;
                            } else {
                                back = Matcher.findBackReg(data, i + term.distance, sampleOff, sampleLen, cnt - minCnt, term.target, end);
                                if (back < 0) break;
                            }
                            actual.cnt = cnt -= back;
                            actual.index = i -= back;
                            if (term.eat) {
                                i += sampleLen;
                            }
                            actual.term = term;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 54: {
                            cnt = actual.cnt;
                            if (cnt <= term.minCount) break;
                            regLen = actual.regLen;
                            actual.cnt = --cnt;
                            actual.index = i -= regLen;
                            actual.term = term;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 15: {
                            int memreg = term.memreg;
                            if (memreg > 0) {
                                memregs[memreg].tmp = i;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 16: {
                            int memreg = term.memreg;
                            if (memreg > 0) {
                                MemReg mr = memregs[memreg];
                                SearchEntry.saveMemregState(top != null ? top : defaultEntry, memreg, mr);
                                mr.in = mr.tmp;
                                mr.out = i;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 39: {
                            int tmp = i - term.distance;
                            if (tmp < offset) break;
                            LAEntry le = lookaheads[term.lookaheadId];
                            le.index = i;
                            i = tmp;
                            le.actual = actual;
                            le.top = top;
                            term = term.next;
                            continue block56;
                        }
                        case 35: 
                        case 43: {
                            LAEntry le = lookaheads[term.lookaheadId];
                            le.index = i;
                            le.actual = actual;
                            le.top = top;
                            term = term.next;
                            continue block56;
                        }
                        case 36: 
                        case 40: 
                        case 57: 
                        case 59: {
                            LAEntry le = lookaheads[term.lookaheadId];
                            i = le.index;
                            actual = le.actual;
                            top = le.top;
                            term = term.next;
                            continue block56;
                        }
                        case 44: {
                            LAEntry le = lookaheads[term.lookaheadId];
                            actual = le.actual;
                            top = le.top;
                            term = term.next;
                            continue block56;
                        }
                        case 41: {
                            int tmp = i - term.distance;
                            if (tmp < offset) {
                                term = term.failNext;
                                continue block56;
                            }
                            LAEntry le = lookaheads[term.lookaheadId];
                            le.actual = actual;
                            le.top = top;
                            actual.term = term.failNext;
                            actual.index = i;
                            i = tmp;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 37: {
                            LAEntry le = lookaheads[term.lookaheadId];
                            le.actual = actual;
                            le.top = top;
                            actual.term = term.failNext;
                            actual.index = i;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 38: 
                        case 42: {
                            LAEntry le = lookaheads[term.lookaheadId];
                            actual = le.actual;
                            top = le.top;
                            break;
                        }
                        case 58: {
                            int tmp = i - term.distance;
                            if (tmp < offset) {
                                term = term.failNext;
                                continue block56;
                            }
                            LAEntry le = lookaheads[term.lookaheadId];
                            le.index = i;
                            le.actual = actual;
                            le.top = top;
                            actual.term = term.failNext;
                            actual.index = i;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            i = tmp;
                            term = term.next;
                            continue block56;
                        }
                        case 56: {
                            LAEntry le = lookaheads[term.lookaheadId];
                            le.index = i;
                            le.actual = actual;
                            le.top = top;
                            actual.term = term.failNext;
                            actual.index = i;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 55: {
                            MemReg mr = memregs[term.memreg];
                            int sampleOffset = mr.in;
                            int sampleOutside = mr.out;
                            if (sampleOffset >= 0 && sampleOutside >= 0 && sampleOutside >= sampleOffset) {
                                term = term.next;
                                continue block56;
                            }
                            term = term.failNext;
                            continue block56;
                        }
                        case 34: {
                            actual.regLen = regLen;
                        }
                        case 33: {
                            actual.cnt = cnt;
                        }
                        case 32: {
                            actual.term = term.failNext;
                            actual.index = i;
                            top = actual;
                            actual = top.on;
                            if (actual == null) {
                                top.on = actual = new SearchEntry();
                                actual.sub = top;
                            }
                            term = term.next;
                            continue block56;
                        }
                        case 10: {
                            if (matchEnd && i != end) break;
                            this.wOffset = memregs[0].in = wOffset;
                            this.wEnd = memregs[0].out = i;
                            this.top = top;
                            return true;
                        }
                        case 24: {
                            cnt = 0;
                            term = term.next;
                            continue block56;
                        }
                        case 25: {
                            ++cnt;
                            term = term.next;
                            continue block56;
                        }
                        case 26: {
                            if (cnt < term.maxCount) break;
                            term = term.next;
                            continue block56;
                        }
                        case 27: {
                            cnt = actual.cnt;
                            if (cnt >= term.maxCount) break;
                            term = term.next;
                            continue block56;
                        }
                        case 28: {
                            int cntreg = term.cntreg;
                            int cntvalue = counters[cntreg];
                            SearchEntry.saveCntState(top != null ? top : defaultEntry, cntreg, cntvalue);
                            counters[cntreg] = ++cntvalue;
                            term = term.next;
                            continue block56;
                        }
                        case 29: {
                            counters[term.cntreg] = 0;
                            term = term.next;
                            continue block56;
                        }
                        case 30: {
                            if (counters[term.cntreg] >= term.maxCount) break;
                            term = term.next;
                            continue block56;
                        }
                        case 31: {
                            if (counters[term.cntreg] < term.maxCount) break;
                            term = term.next;
                            continue block56;
                        }
                        default: {
                            throw new Error("unknown term type: " + term.type);
                        }
                    }
                    if (allowIncomplete && i == end) {
                        this.wOffset = memregs[0].in = wOffset;
                        this.wEnd = memregs[0].out = i;
                        this.top = top;
                        return true;
                    }
                    if (top == null) {
                        if (defaultEntry.isState) {
                            break;
                        }
                        break block117;
                    }
                    actual = top;
                    top = actual.sub;
                    term = actual.term;
                    i = actual.index;
                    if (!actual.isState) continue;
                    SearchEntry.popState(actual, memregs, counters);
                }
                SearchEntry.popState(defaultEntry, memregs, counters);
            }
            term = root;
            i = ++wOffset;
        }
        this.wOffset = wOffset;
        this.top = top;
        return false;
    }

    private static boolean compareRegions(char[] arr, int off1, int off2, int len, int out, Term opts) {
        if (opts.mode_reverse) {
            return Matcher.compareRegionsReverse(arr, off1, off2, len, out, opts.mode_insensitive, opts.mode_bracket);
        }
        return Matcher.compareRegionsForward(arr, off1, off2, len, out, opts.mode_insensitive, opts.mode_bracket);
    }

    private static boolean compareRegionsForward(char[] arr, int off1, int off2, int len, int out, boolean insensitive, boolean bracket) {
        int p1 = off1 + len - 1;
        int p2 = off2 + len - 1;
        if (p1 >= out || p2 >= out) {
            return false;
        }
        int c = len;
        while (c > 0) {
            char a = arr[p1];
            char b = arr[p2];
            if (insensitive) {
                a = Category.caseFold(a);
                b = Category.caseFold(b);
            }
            if (bracket) {
                b = Category.matchBracket(b);
            }
            if (a != b) {
                return false;
            }
            --c;
            --p1;
            --p2;
        }
        return true;
    }

    private static boolean compareRegionsReverse(char[] arr, int off1, int off2, int len, int out, boolean insensitive, boolean bracket) {
        int p1 = off1 + len - 1;
        int p2 = off2;
        if (p1 >= out || p2 >= out) {
            return false;
        }
        int c = len;
        while (c > 0 && p2 < out) {
            char a = arr[p1];
            char b = arr[p2];
            if (insensitive) {
                a = Category.caseFold(a);
                b = Category.caseFold(b);
            }
            if (bracket) {
                b = Category.matchBracket(b);
            }
            if (a != b) {
                return false;
            }
            --c;
            --p1;
            ++p2;
        }
        return true;
    }

    private static boolean compareRegionsI(char[] arr, int off1, int off2, int len, int out) {
        int p1 = off1 + len - 1;
        int p2 = off2 + len - 1;
        if (p1 >= out || p2 >= out) {
            return false;
        }
        int c = len;
        while (c > 0) {
            if (Category.caseFold(arr[p1]) != Category.caseFold(arr[p2])) {
                return false;
            }
            --c;
            --p1;
            --p2;
        }
        return true;
    }

    private static int repeat(char[] data, int off, int out, Term term) {
        switch (term.type) {
            case 0: {
                int i;
                char c = term.c;
                for (i = off; i < out && data[i] == c; ++i) {
                }
                return i - off;
            }
            case 4: {
                return out - off;
            }
            case 5: {
                char c;
                int i;
                for (i = off; i < out && (c = data[i]) != '\r' && c != '\n'; ++i) {
                }
                return i - off;
            }
            case 1: {
                int i;
                IntBitSet arr = term.bitset;
                if (term.inverse) {
                    char c;
                    for (i = off; !(i >= out || (c = data[i]) <= '\u00ff' && arr.get(c)); ++i) {
                    }
                } else {
                    char c;
                    while (i < out && (c = data[i]) <= '\u00ff' && arr.get(c)) {
                        ++i;
                    }
                }
                return i - off;
            }
            case 2: {
                int i;
                IntBitSet[] bitset2 = term.bitset2;
                if (term.inverse) {
                    char c;
                    IntBitSet arr;
                    for (i = off; !(i >= out || (arr = bitset2[(c = data[i]) >> 8]) != null && arr.get(c & 0xFF)); ++i) {
                    }
                } else {
                    char c;
                    IntBitSet arr;
                    while (i < out && (arr = bitset2[(c = data[i]) >> 8]) != null && arr.get(c & 0xFF)) {
                        ++i;
                    }
                }
                return i - off;
            }
        }
        throw new Error("this kind of term can't be quantified:" + term.type);
    }

    private static int find(char[] data, int off, int out, Term term) {
        if (off >= out) {
            return -1;
        }
        switch (term.type) {
            case 0: {
                int i;
                char c = term.c;
                for (i = off; i < out && data[i] != c; ++i) {
                }
                return i - off;
            }
            case 1: {
                int i;
                IntBitSet arr = term.bitset;
                if (!term.inverse) {
                    char c;
                    for (i = off; !(i >= out || (c = data[i]) <= '\u00ff' && arr.get(c)); ++i) {
                    }
                } else {
                    char c;
                    while (i < out && (c = data[i]) <= '\u00ff' && arr.get(c)) {
                        ++i;
                    }
                }
                return i - off;
            }
            case 2: {
                int i;
                IntBitSet[] bitset2 = term.bitset2;
                if (!term.inverse) {
                    char c;
                    IntBitSet arr;
                    for (i = off; !(i >= out || (arr = bitset2[(c = data[i]) >> 8]) != null && arr.get(c & 0xFF)); ++i) {
                    }
                } else {
                    char c;
                    IntBitSet arr;
                    while (i < out && (arr = bitset2[(c = data[i]) >> 8]) != null && arr.get(c & 0xFF)) {
                        ++i;
                    }
                }
                return i - off;
            }
        }
        throw new IllegalArgumentException("can't seek this kind of term:" + term.type);
    }

    private static int findReg(char[] data, int off, int regOff, int regLen, Term term, int out) {
        int i;
        if (off >= out) {
            return -1;
        }
        if (term.type == 6 || term.type == 7) {
            for (i = off; i < out && !Matcher.compareRegions(data, i, regOff, regLen, out, term); ++i) {
            }
        } else {
            throw new IllegalArgumentException("wrong findReg() target:" + term.type);
        }
        return off - i;
    }

    private static int findBack(char[] data, int off, int maxCount, Term term) {
        switch (term.type) {
            case 0: {
                char c = term.c;
                int i = off;
                int iMin = off - maxCount;
                while (data[--i] != c) {
                    if (i > iMin) continue;
                    return -1;
                }
                return off - i;
            }
            case 1: {
                IntBitSet arr = term.bitset;
                int i = off;
                int iMin = off - maxCount;
                if (!term.inverse) {
                    char c;
                    while ((c = data[--i]) > '\u00ff' || !arr.get(c)) {
                        if (i > iMin) continue;
                        return -1;
                    }
                } else {
                    char c;
                    while ((c = data[--i]) <= '\u00ff' && arr.get(c)) {
                        if (i > iMin) continue;
                        return -1;
                    }
                }
                return off - i;
            }
            case 2: {
                IntBitSet[] bitset2 = term.bitset2;
                int i = off;
                int iMin = off - maxCount;
                if (!term.inverse) {
                    char c;
                    IntBitSet arr;
                    while ((arr = bitset2[(c = data[--i]) >> 8]) == null || !arr.get(c & 0xFF)) {
                        if (i > iMin) continue;
                        return -1;
                    }
                } else {
                    char c;
                    IntBitSet arr;
                    while ((arr = bitset2[(c = data[--i]) >> 8]) != null && !arr.get(c & 0xFF)) {
                        if (i > iMin) continue;
                        return -1;
                    }
                }
                return off - i;
            }
        }
        throw new IllegalArgumentException("can't find this kind of term:" + term.type);
    }

    private static int findBackReg(char[] data, int off, int regOff, int regLen, int maxCount, Term term, int out) {
        int i = off;
        int iMin = off - maxCount;
        if (term.type == 6 || term.type == 7) {
            char first = data[regOff];
            ++regOff;
            --regLen;
            while (data[--i] != first || !Matcher.compareRegions(data, i + 1, regOff, regLen, out, term)) {
                if (i > iMin) continue;
                return -1;
            }
        } else {
            throw new IllegalArgumentException("wrong findBackReg() target type :" + term.type);
        }
        return off - i;
    }

    private String toString_d() {
        StringBuilder s = new StringBuilder();
        s.append("counters: ");
        s.append(this.counters == null ? 0 : this.counters.length);
        s.append("\r\nmemregs: ");
        s.append(this.memregs.length);
        for (int i = 0; i < this.memregs.length; ++i) {
            if (this.memregs[i].in < 0 || this.memregs[i].out < 0) {
                s.append("\r\n #").append(i).append(": [INVALID]");
                continue;
            }
            s.append("\r\n #").append(i).append(": [").append(this.memregs[i].in).append(",").append(this.memregs[i].out).append("](\"").append(this.getString(this.memregs[i].in, this.memregs[i].out)).append("\")");
        }
        s.append("\r\ndata: ");
        if (this.data != null) {
            s.append(this.data.length);
        } else {
            s.append("[none]");
        }
        s.append("\r\noffset: ");
        s.append(this.offset);
        s.append("\r\nend: ");
        s.append(this.end);
        s.append("\r\nwOffset: ");
        s.append(this.wOffset);
        s.append("\r\nwEnd: ");
        s.append(this.wEnd);
        s.append("\r\nregex: ");
        s.append(this.re);
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Matcher matcher = (Matcher)o;
        if (this.counterCount != matcher.counterCount) {
            return false;
        }
        if (this.memregCount != matcher.memregCount) {
            return false;
        }
        if (this.lookaheadCount != matcher.lookaheadCount) {
            return false;
        }
        if (this.offset != matcher.offset) {
            return false;
        }
        if (this.end != matcher.end) {
            return false;
        }
        if (this.wOffset != matcher.wOffset) {
            return false;
        }
        if (this.wEnd != matcher.wEnd) {
            return false;
        }
        if (this.shared != matcher.shared) {
            return false;
        }
        if (this.called != matcher.called) {
            return false;
        }
        if (this.minQueueLength != matcher.minQueueLength) {
            return false;
        }
        if (this.cacheOffset != matcher.cacheOffset) {
            return false;
        }
        if (this.cacheLength != matcher.cacheLength) {
            return false;
        }
        if (this.re != null ? !this.re.equals(matcher.re) : matcher.re != null) {
            return false;
        }
        if (!Arrays.equals(this.counters, matcher.counters)) {
            return false;
        }
        if (!Arrays.equals(this.memregs, matcher.memregs)) {
            return false;
        }
        if (!Arrays.equals(this.lookaheads, matcher.lookaheads)) {
            return false;
        }
        if (!Arrays.equals(this.data, matcher.data)) {
            return false;
        }
        if (this.top != null ? !this.top.equals(matcher.top) : matcher.top != null) {
            return false;
        }
        if (this.first != null ? !this.first.equals(matcher.first) : matcher.first != null) {
            return false;
        }
        if (this.defaultEntry != null ? !this.defaultEntry.equals(matcher.defaultEntry) : matcher.defaultEntry != null) {
            return false;
        }
        if (this.cache != null ? !this.cache.equals(matcher.cache) : matcher.cache != null) {
            return false;
        }
        return this.prefixBounds != null ? this.prefixBounds.equals(matcher.prefixBounds) : matcher.prefixBounds == null && (this.suffixBounds != null ? this.suffixBounds.equals(matcher.suffixBounds) : matcher.suffixBounds == null && (this.targetBounds != null ? this.targetBounds.equals(matcher.targetBounds) : matcher.targetBounds == null));
    }

    public int hashCode() {
        int result = this.re != null ? this.re.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.counters);
        result = 31 * result + Arrays.hashCode(this.memregs);
        result = 31 * result + Arrays.hashCode(this.lookaheads);
        result = 31 * result + this.counterCount;
        result = 31 * result + this.memregCount;
        result = 31 * result + this.lookaheadCount;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.offset;
        result = 31 * result + this.end;
        result = 31 * result + this.wOffset;
        result = 31 * result + this.wEnd;
        result = 31 * result + (this.shared ? 1 : 0);
        result = 31 * result + (this.top != null ? this.top.hashCode() : 0);
        result = 31 * result + (this.first != null ? this.first.hashCode() : 0);
        result = 31 * result + (this.defaultEntry != null ? this.defaultEntry.hashCode() : 0);
        result = 31 * result + (this.called ? 1 : 0);
        result = 31 * result + this.minQueueLength;
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        result = 31 * result + this.cacheOffset;
        result = 31 * result + this.cacheLength;
        result = 31 * result + (this.prefixBounds != null ? this.prefixBounds.hashCode() : 0);
        result = 31 * result + (this.suffixBounds != null ? this.suffixBounds.hashCode() : 0);
        result = 31 * result + (this.targetBounds != null ? this.targetBounds.hashCode() : 0);
        return result;
    }

    public String replaceFirst(String replacement) {
        Replacer.StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(this.data.length));
        Replacer.replace(this, new PerlSubstitution(replacement), tb, 1);
        return ((Object)tb).toString();
    }

    public String replaceAmount(String replacement, int amount) {
        Replacer.StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(this.data.length));
        Replacer.replace(this, new PerlSubstitution(replacement), tb, amount);
        return ((Object)tb).toString();
    }

    public String replaceAll(String replacement) {
        Replacer.StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(this.data.length));
        Replacer.replace(this, (Substitution)new PerlSubstitution(replacement), tb);
        return ((Object)tb).toString();
    }

    public String replaceFirst(Substitution replacement) {
        Replacer.StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(this.data.length));
        Replacer.replace(this, replacement, tb, 1);
        return ((Object)tb).toString();
    }

    public String replaceAmount(Substitution replacement, int amount) {
        Replacer.StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(this.data.length));
        Replacer.replace(this, replacement, tb, amount);
        return ((Object)tb).toString();
    }

    public String replaceAll(Substitution replacement) {
        Replacer.StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(this.data.length));
        Replacer.replace(this, replacement, tb);
        return ((Object)tb).toString();
    }
}

