/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.text.JTranscStringTools;

public final class Float
extends Number
implements Comparable<Float> {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_NORMAL = 1.1754944E-38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    public static final Class<Float> TYPE = Class.getPrimitiveClass("float");
    private final float value;

    @HaxeMethodBody(value="return Std.parseFloat(p0._str);")
    @JTranscMethodBody(target="js", value={"return parseFloat(N.istr(p0));"})
    public static native float parseFloat(String var0) throws NumberFormatException;

    public static String toString(float v) {
        return JTranscStringTools.toString((float)v);
    }

    public static String toHexString(float value) {
        return Double.toHexString(value);
    }

    public static Float valueOf(String value) throws NumberFormatException {
        return Float.valueOf(Float.parseFloat(value));
    }

    @JTranscKeep
    public static Float valueOf(float value) {
        return new Float(value);
    }

    @HaxeMethodBody(value="return Math.isNaN(p0);")
    @JTranscMethodBody(target="js", value={"return isNaN(p0);"})
    public static native boolean isNaN(float var0);

    @HaxeMethodBody(value="return Math.isFinite(p0);")
    @JTranscMethodBody(target="js", value={"return isFinite(p0);"})
    private static native boolean _isFinite(float var0);

    public static boolean isInfinite(float v) {
        return !Float.isNaN(v) && !Float._isFinite(v);
    }

    public static boolean isFinite(float d) {
        return Float._isFinite(d);
    }

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(String s) throws NumberFormatException {
        this.value = Float.parseFloat(s);
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    public boolean equals(Object obj) {
        return obj instanceof Float && Float.floatToIntBits(((Float)obj).value) == Float.floatToIntBits(this.value);
    }

    @HaxeMethodBody(value="return HaxeNatives.floatToIntBits(p0);")
    @JTranscMethodBody(target="js", value={"return N.floatToIntBits(p0);"})
    public static native int floatToIntBits(float var0);

    @HaxeMethodBody(value="return HaxeNatives.floatToIntBits(p0);")
    @JTranscMethodBody(target="js", value={"return N.floatToIntBits(p0);"})
    public static native int floatToRawIntBits(float var0);

    @HaxeMethodBody(value="return HaxeNatives.intBitsToFloat(p0);")
    @JTranscMethodBody(target="js", value={"return N.intBitsToFloat(p0);"})
    public static native float intBitsToFloat(int var0);

    @Override
    public int compareTo(Float that) {
        return Float.compare(this.value, that.value);
    }

    public static int compare(float f1, float f2) {
        int b2;
        if (f1 < f2) {
            return -1;
        }
        if (f1 > f2) {
            return 1;
        }
        int b1 = Float.floatToIntBits(f1);
        return b1 == (b2 = Float.floatToIntBits(f2)) ? 0 : (b1 < b2 ? -1 : 1);
    }

    public static float sum(float l, float r) {
        return l + r;
    }

    public static float max(float l, float r) {
        return Math.max(l, r);
    }

    public static float min(float l, float r) {
        return Math.min(l, r);
    }
}

