/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    public static final int UNICODE_CHARACTER_CLASS = 256;
    public regexodus.Pattern internal;
    private String pattern;
    private int flags;

    public static Pattern compile(String regex) {
        return new Pattern(regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        return new Pattern(regex, flags);
    }

    private Pattern(String pattern, int flags) {
        this.pattern = pattern;
        this.flags = flags;
        this.internal = regexodus.Pattern.compile(pattern, Pattern.convertFlags(flags));
    }

    private static int convertFlags(int flags) {
        int fm = 0;
        fm |= (flags & 2) != 0 ? 1 : 0;
        fm |= (flags & 0x20) != 0 ? 4 : 0;
        fm |= (flags & 4) != 0 ? 8 : 0;
        fm |= (flags & 8) != 0 ? 2 : 0;
        return fm |= (flags & 0x100) != 0 ? 16 : 0;
    }

    public String pattern() {
        return this.pattern;
    }

    public int flags() {
        return this.flags;
    }

    public String toString() {
        return this.pattern;
    }

    public Matcher matcher(CharSequence input) {
        return new Matcher(this, input);
    }

    public static boolean matches(String regex, CharSequence input) {
        return Pattern.compile(regex).matcher(input).matches();
    }

    public String[] split(CharSequence input, int limit) {
        int resultSize;
        int index = 0;
        boolean matchLimited = limit > 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = this.matcher(input);
        while (m.find()) {
            String match;
            if (!matchLimited || matchList.size() < limit - 1) {
                if (index == 0 && index == m.start() && m.start() == m.end()) continue;
                match = input.subSequence(index, m.start()).toString();
                matchList.add(match);
                index = m.end();
                continue;
            }
            if (matchList.size() != limit - 1) continue;
            match = input.subSequence(index, input.length()).toString();
            matchList.add(match);
            index = m.end();
        }
        if (index == 0) {
            return new String[]{input.toString()};
        }
        if (!matchLimited || matchList.size() < limit) {
            matchList.add(input.subSequence(index, input.length()).toString());
        }
        if (limit == 0) {
            for (resultSize = matchList.size(); resultSize > 0 && ((String)matchList.get(resultSize - 1)).equals(""); --resultSize) {
            }
        }
        String[] result = new String[resultSize];
        return matchList.subList(0, resultSize).toArray(result);
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public static String quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }
}

