/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import regexodus.BackReference;
import regexodus.Branch;
import regexodus.Category;
import regexodus.CharacterClass;
import regexodus.ConditionalExpr;
import regexodus.Group;
import regexodus.IndependentGroup;
import regexodus.Lookahead;
import regexodus.Lookbehind;
import regexodus.Optimizer;
import regexodus.Pattern;
import regexodus.PatternSyntaxException;
import regexodus.Pretokenizer;
import regexodus.REFlags;
import regexodus.TermIterator;
import regexodus.ds.IntBitSet;

public class Term
implements REFlags,
Serializable {
    private static final long serialVersionUID = 2528136757932720807L;
    static final int CHAR = 0;
    static final int BITSET = 1;
    static final int BITSET2 = 2;
    static final int ANY_CHAR = 4;
    static final int ANY_CHAR_NE = 5;
    static final int REG = 6;
    static final int REG_I = 7;
    static final int FIND = 8;
    static final int FINDREG = 9;
    static final int SUCCESS = 10;
    static final int BOUNDARY = 11;
    static final int DIRECTION = 12;
    static final int UBOUNDARY = 13;
    static final int UDIRECTION = 14;
    static final int GROUP_IN = 15;
    static final int GROUP_OUT = 16;
    static final int VOID = 17;
    static final int START = 18;
    static final int END = 19;
    static final int END_EOL = 20;
    static final int LINE_START = 21;
    static final int LINE_END = 22;
    static final int LAST_MATCH_END = 23;
    static final int CNT_SET_0 = 24;
    static final int CNT_INC = 25;
    static final int CNT_GT_EQ = 26;
    static final int READ_CNT_LT = 27;
    static final int CRSTORE_CRINC = 28;
    static final int CR_SET_0 = 29;
    static final int CR_LT = 30;
    static final int CR_GT_EQ = 31;
    static final int LITERAL_START = 60;
    static final int LITERAL_END = 61;
    static final int BRANCH = 32;
    static final int BRANCH_STORE_CNT = 33;
    static final int BRANCH_STORE_CNT_AUX1 = 34;
    static final int PLOOKAHEAD_IN = 35;
    static final int PLOOKAHEAD_OUT = 36;
    static final int NLOOKAHEAD_IN = 37;
    static final int NLOOKAHEAD_OUT = 38;
    static final int PLOOKBEHIND_IN = 39;
    static final int PLOOKBEHIND_OUT = 40;
    static final int NLOOKBEHIND_IN = 41;
    static final int NLOOKBEHIND_OUT = 42;
    static final int INDEPENDENT_IN = 43;
    static final int INDEPENDENT_OUT = 44;
    static final int REPEAT_0_INF = 45;
    static final int REPEAT_MIN_INF = 46;
    static final int REPEAT_MIN_MAX = 47;
    static final int REPEAT_REG_MIN_INF = 48;
    static final int REPEAT_REG_MIN_MAX = 49;
    static final int BACKTRACK_0 = 50;
    static final int BACKTRACK_MIN = 51;
    static final int BACKTRACK_FIND_MIN = 52;
    static final int BACKTRACK_FINDREG_MIN = 53;
    static final int BACKTRACK_REG_MIN = 54;
    static final int MEMREG_CONDITION = 55;
    static final int LOOKAHEAD_CONDITION_IN = 56;
    static final int LOOKAHEAD_CONDITION_OUT = 57;
    static final int LOOKBEHIND_CONDITION_IN = 58;
    static final int LOOKBEHIND_CONDITION_OUT = 59;
    static final int FIRST_TRANSPARENT = 11;
    static final int LAST_TRANSPARENT = 31;
    private static final int VARS_LENGTH = 4;
    private static final int MEMREG_COUNT = 0;
    private static final int CNTREG_COUNT = 1;
    private static final int DEPTH = 2;
    private static final int LOOKAHEAD_COUNT = 3;
    private static final int LIMITS_LENGTH = 3;
    private static final int LIMITS_PARSE_RESULT_INDEX = 2;
    private static final int LIMITS_OK = 1;
    private static final int LIMITS_FAILURE = 2;
    private static final int LITERAL_FLAG = 64;
    Term next;
    Term failNext;
    int type = 17;
    boolean inverse;
    char c;
    int distance;
    boolean eat;
    IntBitSet bitset;
    IntBitSet[] bitset2;
    private boolean[] categoryBitset;
    boolean mode_insensitive;
    boolean mode_reverse;
    boolean mode_bracket;
    int weight;
    int memreg = -1;
    int minCount;
    int maxCount;
    Term target;
    int cntreg = 0;
    int lookaheadId;
    Term prev;
    Term in;
    Term out;
    Term out1;
    protected Term first;
    Term current;
    Term branchOut;
    private static int instances;
    private int instanceNum = instances++;

    Term() {
        this.in = this.out = this;
    }

    Term(int type) {
        this();
        this.type = type;
    }

    static void makeTree(String s, int[] flags, Pattern re) throws PatternSyntaxException {
        instances = 0;
        char[] data = s.toCharArray();
        Term.makeTree(data, 0, data.length, flags, re);
    }

    private static void makeTree(char[] data, int offset, int end, int[] flags, Pattern re) throws PatternSyntaxException {
        Term first;
        int[] vars = new int[]{1, 0, 0, 0};
        ArrayList<TermIterator> iterators = new ArrayList<TermIterator>();
        HashMap<String, Integer> groupNames = new HashMap<String, Integer>();
        Pretokenizer t = new Pretokenizer(data, offset, end);
        Term term = Term.makeTree(t, data, vars, flags, new Group(), iterators, groupNames);
        term.out.type = 10;
        Term optimized = first = term.next;
        Optimizer opt = Optimizer.find(first);
        if (opt != null) {
            optimized = opt.makeFirst(first);
        }
        for (TermIterator i : iterators) {
            i.optimize();
        }
        re.root = optimized;
        re.root = first;
        re.root0 = first;
        re.memregs = vars[0];
        re.counters = vars[1];
        re.lookaheads = vars[3];
        re.namedGroupMap = groupNames;
    }

    /*
     * Unable to fully structure code
     */
    private static Term makeTree(Pretokenizer t, char[] data, int[] vars, int[] flags, Term term, ArrayList<TermIterator> iterators, HashMap<String, Integer> groupNames) throws PatternSyntaxException {
        if (vars.length != 4) {
            throw new IllegalArgumentException("vars.length should be 4, not " + vars.length);
        }
        block26: while (true) {
            t.next();
            term.append(t.tOffset, t.tOutside, data, vars, flags, iterators, groupNames);
            switch (t.ttype) {
                case 11: {
                    flags[0] = t.flags(flags[0]);
                    continue block26;
                }
                case 12: {
                    t.next();
                    clg = new Term();
                    CharacterClass.parseGroup(data, t.tOffset, t.tOutside, clg, (flags[0] & 1) > 0, (flags[0] & 8) > 0, (flags[0] & 16) > 0, (flags[0] & 32) > 0);
                    term.append(clg);
                    continue block26;
                }
                case 3: {
                    vars[2] = vars[2] + 1;
                    term.append(Term.makeTree(t, data, vars, new int[]{t.flags(flags[0])}, new Group(), iterators, groupNames));
                    continue block26;
                }
                case 13: {
                    gname = t.groupName;
                    if (Character.isDigit(gname.charAt(0))) {
                        try {
                            id = Integer.parseInt(gname);
                        }
                        catch (NumberFormatException e) {
                            throw new PatternSyntaxException("group name starts with digit but is not a number");
                        }
                        if (groupNames.containsValue(id) && t.groupDeclared) {
                            throw new PatternSyntaxException("group redeclaration: " + gname + "; use ({=id}...) for multiple group assignments");
                        }
                        if (vars[0] <= id) {
                            vars[0] = id + 1;
                        }
                    } else {
                        no = groupNames.get(gname);
                        if (no == null) {
                            vars[0] = vars[0] + 1;
                            groupNames.put(t.groupName, id);
                        } else {
                            if (t.groupDeclared) {
                                throw new PatternSyntaxException("group redeclaration " + gname + "; use ({=name}...) for group reassignments");
                            }
                            id = no;
                        }
                    }
                    vars[2] = vars[2] + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Group(id), iterators, groupNames));
                    continue block26;
                }
                case 40: {
                    vars[2] = vars[2] + 1;
                    v0 = vars[0];
                    vars[0] = v0 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Group(v0), iterators, groupNames));
                    continue block26;
                }
                case 4: {
                    vars[2] = vars[2] + 1;
                    v1 = vars[3];
                    vars[3] = v1 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookahead(v1, true), iterators, groupNames));
                    continue block26;
                }
                case 5: {
                    vars[2] = vars[2] + 1;
                    v2 = vars[3];
                    vars[3] = v2 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookahead(v2, false), iterators, groupNames));
                    continue block26;
                }
                case 6: {
                    vars[2] = vars[2] + 1;
                    v3 = vars[3];
                    vars[3] = v3 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookbehind(v3, true), iterators, groupNames));
                    continue block26;
                }
                case 7: {
                    vars[2] = vars[2] + 1;
                    v4 = vars[3];
                    vars[3] = v4 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookbehind(v4, false), iterators, groupNames));
                    continue block26;
                }
                case 8: {
                    vars[2] = vars[2] + 1;
                    v5 = vars[3];
                    vars[3] = v5 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new IndependentGroup(v5), iterators, groupNames));
                    continue block26;
                }
                case 10: {
                    vars[2] = vars[2] + 1;
                    t.next();
                    positive = true;
                    switch (t.ttype) {
                        case 5: {
                            positive = false;
                        }
                        case 4: {
                            vars[2] = vars[2] + 1;
                            v6 = vars[3];
                            vars[3] = v6 + 1;
                            la = new Lookahead(v6, positive);
                            Term.makeTree(t, data, vars, flags, la, iterators, groupNames);
                            fork = new ConditionalExpr(la);
                            break;
                        }
                        case 7: {
                            positive = false;
                        }
                        case 6: {
                            vars[2] = vars[2] + 1;
                            v7 = vars[3];
                            vars[3] = v7 + 1;
                            lb = new Lookbehind(v7, positive);
                            Term.makeTree(t, data, vars, flags, lb, iterators, groupNames);
                            fork = new ConditionalExpr(lb);
                            break;
                        }
                        case 40: {
                            t.next();
                            if (t.ttype != 41) {
                                throw new PatternSyntaxException("malformed condition");
                            }
                            if (Character.isDigit(data[t.tOffset])) {
                                memregNo = Term.makeNumber(t.tOffset, t.tOutside, data);
                            } else {
                                gn = new String(data, t.tOffset, t.tOutside - t.tOffset);
                                gno = groupNames.get(gn);
                                if (gno == null) {
                                    throw new PatternSyntaxException("unknown group name in conditional expr.: " + gn);
                                }
                                memregNo = gno;
                            }
                            fork = new ConditionalExpr(memregNo);
                            break;
                        }
                        default: {
                            throw new PatternSyntaxException("malformed conditional expression: " + t.ttype + " '" + (char)t.ttype + "'");
                        }
                    }
                    term.append(Term.makeTree(t, data, vars, flags, fork, iterators, groupNames));
                    continue block26;
                }
                case 124: {
                    term.newBranch();
                    continue block26;
                }
                case 2: {
                    if (vars[2] > 0) {
                        throw new PatternSyntaxException("unbalanced parenthesis");
                    }
                    term.close();
                    return term;
                }
                case 41: {
                    if (vars[2] <= 0) {
                        throw new PatternSyntaxException("unbalanced parenthesis");
                    }
                    term.close();
                    vars[2] = vars[2] - 1;
                    return term;
                }
                case 9: {
                    while (true) {
                        if (t.ttype != 41) ** break;
                        continue block26;
                        t.next();
                    }
                }
            }
            break;
        }
        throw new PatternSyntaxException("unknown token type: " + t.ttype);
    }

    private static int makeNumber(int off, int out, char[] data) {
        int n = 0;
        for (int i = off; i < out; ++i) {
            int d = data[i] - 48;
            if (d < 0 || d > 9) {
                return -1;
            }
            n *= 10;
            n += d;
        }
        return n;
    }

    private void append(int offset, int end, char[] data, int[] vars, int[] flags, ArrayList<TermIterator> iterators, HashMap<String, Integer> gmap) throws PatternSyntaxException {
        int[] limits = new int[3];
        int i = offset;
        Term current = this.current;
        block18: while (i < end) {
            Term tmp;
            char c = data[i];
            boolean greedy = true;
            if ((flags[0] & 0x40) != 64) {
                switch (c) {
                    case '*': {
                        if (current == null) {
                            throw new PatternSyntaxException("missing term before *");
                        }
                        if (++i < end && data[i] == '?') {
                            greedy = false;
                            ++i;
                        }
                        tmp = greedy ? Term.makeGreedyStar(vars, current, iterators) : Term.makeLazyStar(vars, current);
                        current = this.replaceCurrent(tmp);
                        break;
                    }
                    case '+': {
                        if (current == null) {
                            throw new PatternSyntaxException("missing term before +");
                        }
                        if (++i < end && data[i] == '?') {
                            greedy = false;
                            ++i;
                        }
                        tmp = greedy ? Term.makeGreedyPlus(vars, current, iterators) : Term.makeLazyPlus(vars, current);
                        current = this.replaceCurrent(tmp);
                        break;
                    }
                    case '?': {
                        if (current == null) {
                            throw new PatternSyntaxException("missing term before ?");
                        }
                        if (++i < end && data[i] == '?') {
                            greedy = false;
                            ++i;
                        }
                        tmp = greedy ? Term.makeGreedyQMark(vars, current) : Term.makeLazyQMark(vars, current);
                        current = this.replaceCurrent(tmp);
                        break;
                    }
                    case '{': {
                        BackReference br;
                        boolean mr;
                        boolean mb;
                        boolean mi;
                        char cp;
                        int p;
                        limits[0] = 0;
                        limits[1] = -1;
                        int le = Term.parseLimits(i + 1, end, data, limits);
                        if (limits[2] == 1) {
                            if (current == null) {
                                throw new PatternSyntaxException("missing term before {}");
                            }
                            i = le;
                            if (i < end && data[i] == '?') {
                                greedy = false;
                                ++i;
                            }
                            tmp = greedy ? Term.makeGreedyLimits(vars, current, limits, iterators) : Term.makeLazyLimits(vars, current, limits);
                            current = this.replaceCurrent(tmp);
                            break;
                        }
                        if (data[i + 1] == '\\') {
                            p = i + 2;
                            if (p == end) {
                                throw new PatternSyntaxException("'group_id' expected");
                            }
                            cp = data[p];
                            mi = false;
                            mb = false;
                            mr = false;
                            while (Category.Z.contains(cp) || Category.Po.contains(cp)) {
                                if (++p == end) {
                                    throw new PatternSyntaxException("'group_id' expected");
                                }
                                switch (cp) {
                                    case '@': {
                                        mi = !mi;
                                        break;
                                    }
                                    case '/': {
                                        mr = !mr;
                                        break;
                                    }
                                    case ':': {
                                        mb = !mb;
                                    }
                                }
                                cp = data[p];
                            }
                            br = new BackReference(-1, mi || (flags[0] & 1) > 0, mr, mb);
                            i = Term.parseGroupId(data, p, end, br, gmap, '}');
                            current = this.append(br);
                            continue block18;
                        }
                        Term t = new Term();
                        i = CharacterClass.parseName(data, i, end, t, false, (flags[0] & 8) > 0);
                        current = this.append(t);
                        continue block18;
                    }
                    case '\\': {
                        BackReference br;
                        boolean mr;
                        boolean mb;
                        boolean mi;
                        char cp;
                        int p;
                        if (i + 4 < end && data[i + 1] == 'k' && data[i + 2] == '<') {
                            p = i + 3;
                            if (p == end) {
                                throw new PatternSyntaxException("'group_id' expected");
                            }
                            cp = data[p];
                            mi = false;
                            mb = false;
                            mr = false;
                            while (Category.Z.contains(cp) || Category.Po.contains(cp)) {
                                if (++p == end) {
                                    throw new PatternSyntaxException("'group_id' expected");
                                }
                                switch (cp) {
                                    case '@': {
                                        mi = !mi;
                                        break;
                                    }
                                    case '/': {
                                        mr = !mr;
                                        break;
                                    }
                                    case ':': {
                                        mb = !mb;
                                    }
                                }
                                cp = data[p];
                            }
                            br = new BackReference(-1, mi || (flags[0] & 1) > 0, mr, mb);
                            i = Term.parseGroupId(data, p, end, br, gmap, '>');
                            current = this.append(br);
                            continue block18;
                        }
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if ((flags[0] & 8) > 0) {
                            ++i;
                            continue block18;
                        }
                    }
                    default: {
                        tmp = new Term();
                        i = this.parseTerm(data, i, end, tmp, flags[0]);
                        if (tmp.type == 60) {
                            flags[0] = flags[0] | 0x40;
                            continue block18;
                        }
                        if (tmp.type == 61) {
                            flags[0] = flags[0] & 0xFFFFFFBF;
                            continue block18;
                        }
                        if (tmp.type == 19 && i < end) {
                            throw new PatternSyntaxException("'$' is not a last term in the group: <" + new String(data, offset, end - offset) + ">");
                        }
                        current = this.append(tmp);
                        break;
                    }
                }
                continue;
            }
            tmp = new Term();
            i = this.parseTerm(data, i, end, tmp, flags[0]);
            if (tmp.type == 60) {
                flags[0] = flags[0] | 0x40;
                continue;
            }
            if (tmp.type == 61) {
                flags[0] = flags[0] & 0xFFFFFFBF;
                continue;
            }
            if (tmp.type == 19 && i < end) {
                throw new PatternSyntaxException("'$' is not a last term in the group: <" + new String(data, offset, end - offset) + ">");
            }
            current = this.append(tmp);
        }
    }

    private static int parseGroupId(char[] data, int i, int end, Term term, HashMap<String, Integer> gmap, char closer) throws PatternSyntaxException {
        char c;
        int id;
        int nstart = i;
        if (Character.isDigit(data[i])) {
            while (Character.isDigit(data[i])) {
                if (++i != end) continue;
                throw new PatternSyntaxException("group_id expected");
            }
            id = Term.makeNumber(nstart, i, data);
        } else {
            while (Category.IdentifierPart.contains(data[i])) {
                if (++i != end) continue;
                throw new PatternSyntaxException("group_id expected");
            }
            String s = new String(data, nstart, i - nstart);
            Integer no = gmap.get(s);
            if (no == null) {
                throw new PatternSyntaxException("backreference to unknown group: " + s);
            }
            id = no;
        }
        while (Category.Z.contains(data[i])) {
            if (++i != end) continue;
            throw new PatternSyntaxException("'" + closer + "' expected");
        }
        if ((c = data[i++]) != closer) {
            throw new PatternSyntaxException("'" + closer + "' expected");
        }
        term.memreg = id;
        return i;
    }

    Term append(Term term) throws PatternSyntaxException {
        Term current = this.current;
        if (current == null) {
            this.in.next = term;
            term.prev = this.in;
            this.current = term;
            return term;
        }
        Term.link(current, term);
        this.current = term;
        return term;
    }

    Term replaceCurrent(Term term) throws PatternSyntaxException {
        Term prev = this.current.prev;
        if (prev != null) {
            Term in = this.in;
            if (prev == in) {
                in.next = term.in;
                term.in.prev = in;
            } else {
                Term.link(prev, term);
            }
        }
        this.current = term;
        return term;
    }

    private void newBranch() throws PatternSyntaxException {
        this.close();
        this.startNewBranch();
    }

    void close() throws PatternSyntaxException {
        Term current = this.current;
        if (current != null) {
            Term.linkd(current, this.out);
        } else {
            this.in.next = this.out;
        }
    }

    private static void link(Term term, Term next) {
        Term.linkd(term, next.in);
        next.prev = term;
    }

    private static void linkd(Term term, Term next) {
        Term prev_branch;
        Term prev_out1;
        Term prev_out = term.out;
        if (prev_out != null) {
            prev_out.next = next;
        }
        if ((prev_out1 = term.out1) != null) {
            prev_out1.next = next;
        }
        if ((prev_branch = term.branchOut) != null) {
            prev_branch.failNext = next;
        }
    }

    void startNewBranch() throws PatternSyntaxException {
        Term tmp = this.in.next;
        Branch b = new Branch();
        this.in.next = b;
        b.next = tmp;
        b.in = null;
        b.out = null;
        b.out1 = null;
        b.branchOut = b;
        this.current = b;
    }

    private static Term makeGreedyStar(int[] vars, Term term, ArrayList<TermIterator> iterators) throws PatternSyntaxException {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                b.next = term.in;
                term.out.next = b;
                b.in = b;
                b.out = null;
                b.out1 = null;
                b.branchOut = b;
                return b;
            }
        }
        return new TermIterator(term, 0, -1, iterators);
    }

    private static Term makeLazyStar(int[] vars, Term term) {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                b.failNext = term.in;
                term.out.next = b;
                b.in = b;
                b.out = b;
                b.out1 = null;
                b.branchOut = null;
                return b;
            }
        }
        Branch b = new Branch();
        b.failNext = term;
        term.next = b;
        b.in = b;
        b.out = b;
        b.out1 = null;
        b.branchOut = null;
        return b;
    }

    private static Term makeGreedyPlus(int[] vars, Term term, ArrayList<TermIterator> iterators) throws PatternSyntaxException {
        switch (term.type) {
            case 15: 
            case 43: {
                Branch b = new Branch();
                b.next = term.in;
                term.out.next = b;
                b.in = term.in;
                b.out = null;
                b.out1 = null;
                b.branchOut = b;
                return b;
            }
        }
        return new TermIterator(term, 1, -1, iterators);
    }

    private static Term makeLazyPlus(int[] vars, Term term) {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                term.out.next = b;
                b.failNext = term.in;
                b.in = term.in;
                b.out = b;
                b.out1 = null;
                b.branchOut = null;
                return b;
            }
        }
        Branch b = new Branch();
        term.next = b;
        b.failNext = term;
        b.in = term;
        b.out = b;
        b.out1 = null;
        b.branchOut = null;
        return b;
    }

    private static Term makeGreedyQMark(int[] vars, Term term) {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                b.next = term.in;
                b.in = b;
                b.out = term.out;
                b.out1 = null;
                b.branchOut = b;
                return b;
            }
        }
        Branch b = new Branch();
        b.next = term;
        b.in = b;
        b.out = term;
        b.out1 = null;
        b.branchOut = b;
        return b;
    }

    private static Term makeLazyQMark(int[] vars, Term term) {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                b.failNext = term.in;
                b.in = b;
                b.out = b;
                b.out1 = term.out;
                b.branchOut = null;
                return b;
            }
        }
        Branch b = new Branch();
        b.failNext = term;
        b.in = b;
        b.out = b;
        b.out1 = term;
        b.branchOut = null;
        return b;
    }

    private static Term makeGreedyLimits(int[] vars, Term term, int[] limits, ArrayList<TermIterator> iterators) throws PatternSyntaxException {
        int m = limits[0];
        int n = limits[1];
        switch (term.type) {
            case 15: {
                int n2 = vars[1];
                vars[1] = n2 + 1;
                int cntreg = n2;
                Term reset = new Term(29);
                reset.cntreg = cntreg;
                Term b = new Term(32);
                Term inc = new Term(28);
                inc.cntreg = cntreg;
                reset.next = b;
                if (n >= 0) {
                    Term lt = new Term(30);
                    lt.cntreg = cntreg;
                    lt.maxCount = n;
                    b.next = lt;
                    lt.next = term.in;
                } else {
                    b.next = term.in;
                }
                term.out.next = inc;
                inc.next = b;
                if (m >= 0) {
                    Term gt = new Term(31);
                    gt.cntreg = cntreg;
                    gt.maxCount = m;
                    b.failNext = gt;
                    reset.in = reset;
                    reset.out = gt;
                    reset.out1 = null;
                    reset.branchOut = null;
                } else {
                    reset.in = reset;
                    reset.out = null;
                    reset.out1 = null;
                    reset.branchOut = b;
                }
                return reset;
            }
        }
        return new TermIterator(term, limits[0], limits[1], iterators);
    }

    private static Term makeLazyLimits(int[] vars, Term term, int[] limits) {
        int m = limits[0];
        int n = limits[1];
        switch (term.type) {
            case 15: {
                int n2 = vars[1];
                vars[1] = n2 + 1;
                int cntreg = n2;
                Term reset = new Term(29);
                reset.cntreg = cntreg;
                Term b = new Term(32);
                Term inc = new Term(28);
                inc.cntreg = cntreg;
                reset.next = b;
                if (n >= 0) {
                    Term lt = new Term(30);
                    lt.cntreg = cntreg;
                    lt.maxCount = n;
                    b.failNext = lt;
                    lt.next = term.in;
                } else {
                    b.failNext = term.in;
                }
                term.out.next = inc;
                inc.next = b;
                if (m >= 0) {
                    Term gt = new Term(31);
                    gt.cntreg = cntreg;
                    gt.maxCount = m;
                    b.next = gt;
                    reset.in = reset;
                    reset.out = gt;
                    reset.out1 = null;
                    reset.branchOut = null;
                    return reset;
                }
                reset.in = reset;
                reset.out = b;
                reset.out1 = null;
                reset.branchOut = null;
                return reset;
            }
        }
        Term reset = new Term(24);
        Branch b = new Branch(33);
        Term inc = new Term(25);
        reset.next = b;
        if (n >= 0) {
            Term lt = new Term(27);
            lt.maxCount = n;
            b.failNext = lt;
            lt.next = term;
            term.next = inc;
            inc.next = b;
        } else {
            b.next = term;
            term.next = inc;
            inc.next = term;
        }
        if (m >= 0) {
            Term gt = new Term(26);
            gt.maxCount = m;
            b.next = gt;
            reset.in = reset;
            reset.out = gt;
            reset.out1 = null;
            reset.branchOut = null;
            return reset;
        }
        reset.in = reset;
        reset.out = b;
        reset.out1 = null;
        reset.branchOut = null;
        return reset;
    }

    private int parseTerm(char[] data, int i, int out, Term term, int flags) throws PatternSyntaxException {
        int c = data[i++];
        boolean inv = false;
        if ((flags & 0x40) == 64) {
            switch (c) {
                case 92: {
                    if (i >= out + 1 || data[i] != 'E') break;
                    term.type = 61;
                    return i + 1;
                }
            }
            term.type = 0;
            term.c = (flags & 1) == 0 ? c : Category.caseFold((char)c);
            return i;
        }
        switch (c) {
            case 91: {
                return CharacterClass.parseClass(data, i, out, term, (flags & 1) > 0, (flags & 8) > 0, (flags & 0x10) > 0, (flags & 0x20) > 0);
            }
            case 46: {
                term.type = (flags & 4) > 0 ? 4 : 5;
                break;
            }
            case 36: {
                term.type = (flags & 2) > 0 ? 22 : 20;
                break;
            }
            case 94: {
                term.type = (flags & 2) > 0 ? 21 : 18;
                break;
            }
            case 92: {
                if (i >= out) {
                    throw new PatternSyntaxException("Escape without a character");
                }
                c = data[i++];
                switch (c) {
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 117: {
                        if (i < out - 3) {
                            c = (char)((CharacterClass.toHexDigit(data[i++]) << 12) + (CharacterClass.toHexDigit(data[i++]) << 8) + (CharacterClass.toHexDigit(data[i++]) << 4) + CharacterClass.toHexDigit(data[i++]));
                            break;
                        }
                        c = 0;
                        i = out;
                        break;
                    }
                    case 120: {
                        int hex = 0;
                        char d = data[i++];
                        if (d == '{') {
                            while (i < out && (d = data[i++]) != '}') {
                                if ((hex = (hex << 4) + CharacterClass.toHexDigit(d)) <= 65535 && i != out) continue;
                                throw new PatternSyntaxException("\\x{<out of range or incomplete>}");
                            }
                        } else {
                            hex = (CharacterClass.toHexDigit(d) << 4) + CharacterClass.toHexDigit(data[i++]);
                        }
                        c = (char)hex;
                        break;
                    }
                    case 48: 
                    case 111: {
                        char d;
                        int oct = 0;
                        while (i < out && (d = data[i++]) >= '0' && d <= '7') {
                            oct *= 8;
                            if ((oct += d - 48) <= 65535) continue;
                            oct -= d - 48;
                            oct /= 8;
                            break;
                        }
                        c = (char)oct;
                        break;
                    }
                    case 109: {
                        char d;
                        int dec = 0;
                        while (i < out && (d = data[i++]) >= '0' && d <= '9') {
                            dec *= 10;
                            if ((dec += d - 48) <= 65535) continue;
                            dec -= d - 48;
                            dec /= 10;
                            break;
                        }
                        c = (char)dec;
                        break;
                    }
                    case 99: {
                        c = (char)(data[i++] & 0x1F);
                        break;
                    }
                    case 68: {
                        inv = true;
                    }
                    case 100: {
                        CharacterClass.makeDigit(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 83: {
                        inv = true;
                    }
                    case 115: {
                        CharacterClass.makeSpace(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 87: {
                        inv = true;
                    }
                    case 119: {
                        CharacterClass.makeWordChar(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 72: {
                        inv = true;
                    }
                    case 104: {
                        CharacterClass.makeHSpace(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 86: {
                        inv = true;
                    }
                    case 118: {
                        CharacterClass.makeVSpace(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 66: {
                        inv = true;
                    }
                    case 98: {
                        CharacterClass.makeWordBoundary(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 60: {
                        CharacterClass.makeWordStart(term, (flags & 0x10) > 0);
                        return i;
                    }
                    case 62: {
                        CharacterClass.makeWordEnd(term, (flags & 0x10) > 0);
                        return i;
                    }
                    case 65: {
                        term.type = 18;
                        return i;
                    }
                    case 90: {
                        term.type = 20;
                        return i;
                    }
                    case 122: {
                        term.type = 19;
                        return i;
                    }
                    case 71: {
                        term.type = 23;
                        return i;
                    }
                    case 80: {
                        inv = true;
                    }
                    case 112: {
                        i = CharacterClass.parseName(data, i, out, term, inv, (flags & 8) > 0);
                        return i;
                    }
                    case 81: {
                        term.type = 60;
                        return i;
                    }
                    default: {
                        if (c < 49 || c > 57) break;
                        int n = c - 48;
                        while (i < out && (c = data[i]) >= 48 && c <= 57) {
                            n = n * 10 + c - 48;
                            ++i;
                        }
                        term.type = (flags & 1) > 0 ? 7 : 6;
                        term.memreg = n;
                        return i;
                    }
                }
                term.type = 0;
                term.c = (char)c;
                break;
            }
            default: {
                if ((flags & 1) == 0) {
                    term.type = 0;
                    term.c = c;
                    break;
                }
                term.type = 0;
                term.c = Category.caseFold((char)c);
            }
        }
        return i;
    }

    private static int parseLimits(int i, int end, char[] data, int[] limits) throws PatternSyntaxException {
        if (limits.length != 3) {
            throw new IllegalArgumentException("limits.length=" + limits.length + ", should be " + 3);
        }
        limits[2] = 1;
        int ind = 0;
        int v = 0;
        block5: while (i < end) {
            char c = data[i++];
            switch (c) {
                case ' ': {
                    continue block5;
                }
                case ',': {
                    if (ind > 0) {
                        throw new PatternSyntaxException("illegal construction: {.. , , ..}");
                    }
                    limits[ind++] = v;
                    v = -1;
                    continue block5;
                }
                case '}': {
                    limits[ind] = v;
                    if (ind == 0) {
                        limits[1] = v;
                    }
                    return i;
                }
            }
            if (c > '9' || c < '0') {
                limits[2] = 2;
                return i;
            }
            if (v < 0) {
                v = 0;
            }
            v = v * 10 + (c - 48);
        }
        throw new PatternSyntaxException("malformed quantifier");
    }

    static String termLookup(int t) {
        switch (t) {
            case 0: {
                return "CHAR";
            }
            case 1: {
                return "BITSET";
            }
            case 2: {
                return "BITSET2";
            }
            case 4: {
                return "ANY_CHAR";
            }
            case 5: {
                return "ANY_CHAR_NE";
            }
            case 6: {
                return "REG";
            }
            case 7: {
                return "REG_I";
            }
            case 8: {
                return "FIND";
            }
            case 9: {
                return "FINDREG";
            }
            case 10: {
                return "SUCCESS";
            }
            case 11: {
                return "BOUNDARY";
            }
            case 12: {
                return "DIRECTION";
            }
            case 13: {
                return "UBOUNDARY";
            }
            case 14: {
                return "UDIRECTION";
            }
            case 15: {
                return "GROUP_IN";
            }
            case 16: {
                return "GROUP_OUT";
            }
            case 17: {
                return "VOID";
            }
            case 18: {
                return "START";
            }
            case 19: {
                return "END";
            }
            case 20: {
                return "END_EOL";
            }
            case 21: {
                return "LINE_START";
            }
            case 22: {
                return "LINE_END";
            }
            case 23: {
                return "LAST_MATCH_END";
            }
            case 24: {
                return "CNT_SET_0";
            }
            case 25: {
                return "CNT_INC";
            }
            case 26: {
                return "CNT_GT_EQ";
            }
            case 27: {
                return "READ_CNT_LT";
            }
            case 28: {
                return "CRSTORE_CRINC";
            }
            case 29: {
                return "CR_SET_0";
            }
            case 30: {
                return "CR_LT";
            }
            case 31: {
                return "CR_GT_EQ";
            }
            case 32: {
                return "BRANCH";
            }
            case 33: {
                return "BRANCH_STORE_CNT";
            }
            case 34: {
                return "BRANCH_STORE_CNT_AUX1";
            }
            case 35: {
                return "PLOOKAHEAD_IN";
            }
            case 36: {
                return "PLOOKAHEAD_OUT";
            }
            case 37: {
                return "NLOOKAHEAD_IN";
            }
            case 38: {
                return "NLOOKAHEAD_OUT";
            }
            case 39: {
                return "PLOOKBEHIND_IN";
            }
            case 40: {
                return "PLOOKBEHIND_OUT";
            }
            case 41: {
                return "NLOOKBEHIND_IN";
            }
            case 42: {
                return "NLOOKBEHIND_OUT";
            }
            case 43: {
                return "INDEPENDENT_IN";
            }
            case 44: {
                return "INDEPENDENT_OUT";
            }
            case 45: {
                return "REPEAT_0_INF";
            }
            case 46: {
                return "REPEAT_MIN_INF";
            }
            case 47: {
                return "REPEAT_MIN_MAX";
            }
            case 48: {
                return "REPEAT_REG_MIN_INF";
            }
            case 49: {
                return "REPEAT_REG_MIN_MAX";
            }
            case 50: {
                return "BACKTRACK_0";
            }
            case 51: {
                return "BACKTRACK_MIN";
            }
            case 52: {
                return "BACKTRACK_FIND_MIN";
            }
            case 53: {
                return "BACKTRACK_FINDREG_MIN";
            }
            case 54: {
                return "BACKTRACK_REG_MIN";
            }
            case 55: {
                return "MEMREG_CONDITION";
            }
            case 56: {
                return "LOOKAHEAD_CONDITION_IN";
            }
            case 57: {
                return "LOOKAHEAD_CONDITION_OUT";
            }
            case 58: {
                return "LOOKBEHIND_CONDITION_IN";
            }
            case 59: {
                return "LOOKBEHIND_CONDITION_OUT";
            }
        }
        return "UNKNOWN_TERM";
    }

    public String toString() {
        StringBuilder b = new StringBuilder(100);
        b.append(this.instanceNum);
        b.append(' ');
        b.append(Term.termLookup(this.type));
        b.append(": ");
        if (this.inverse) {
            b.append('^');
        }
        switch (this.type) {
            case 17: {
                b.append("[]");
                b.append(" , ");
                break;
            }
            case 0: {
                b.append(CharacterClass.stringValue(this.c));
                b.append(" , ");
                break;
            }
            case 4: {
                b.append("dotall, ");
                break;
            }
            case 5: {
                b.append("dot-eols, ");
                break;
            }
            case 1: {
                b.append('[');
                b.append(CharacterClass.stringValue0(this.bitset));
                b.append(']');
                b.append(" , weight=");
                b.append(this.weight);
                b.append(" , ");
                break;
            }
            case 2: {
                b.append('[');
                b.append(CharacterClass.stringValue2(this.bitset2));
                b.append(']');
                b.append(" , weight2=");
                b.append(this.weight);
                b.append(" , ");
                break;
            }
            case 18: {
                b.append("abs.start");
                break;
            }
            case 19: {
                b.append("abs.end");
                break;
            }
            case 20: {
                b.append("abs.end-eol");
                break;
            }
            case 21: {
                b.append("line start");
                break;
            }
            case 22: {
                b.append("line end");
                break;
            }
            case 23: {
                if (this.inverse) {
                    b.append("non-");
                }
                b.append("BOUNDARY");
                break;
            }
            case 11: {
                if (this.inverse) {
                    b.append("non-");
                }
                b.append("BOUNDARY");
                break;
            }
            case 13: {
                if (this.inverse) {
                    b.append("non-");
                }
                b.append("UBOUNDARY");
                break;
            }
            case 12: {
                b.append("DIRECTION");
                break;
            }
            case 14: {
                b.append("UDIRECTION");
                break;
            }
            case 9: {
                b.append('%');
            }
            case 8: {
                b.append(">>>{");
                b.append(this.target);
                b.append("}, <<");
                b.append(this.distance);
                if (this.eat) {
                    b.append(",eat");
                }
                b.append(", ");
                break;
            }
            case 45: {
                b.append("rpt{");
                b.append(this.target);
                b.append(",0,inf}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 46: {
                b.append("rpt{");
                b.append(this.target);
                b.append(",");
                b.append(this.minCount);
                b.append(",inf}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 47: {
                b.append("rpt{");
                b.append(this.target);
                b.append(",");
                b.append(this.minCount);
                b.append(",");
                b.append(this.maxCount);
                b.append("}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 48: {
                b.append("rpt{$");
                b.append(this.memreg);
                b.append(',');
                b.append(this.minCount);
                b.append(",inf}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 49: {
                b.append("rpt{$");
                b.append(this.memreg);
                b.append(',');
                b.append(this.minCount);
                b.append(',');
                b.append(this.maxCount);
                b.append("}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 50: {
                b.append("back(0)");
                break;
            }
            case 51: {
                b.append("back(");
                b.append(this.minCount);
                b.append(")");
                break;
            }
            case 54: {
                b.append("back");
                b.append("_$");
                b.append(this.memreg);
                b.append("(");
                b.append(this.minCount);
                b.append(")");
                break;
            }
            case 15: {
                b.append('(');
                if (this.memreg > 0) {
                    b.append(this.memreg);
                }
                b.append('-');
                b.append(" , ");
                break;
            }
            case 16: {
                b.append('-');
                if (this.memreg > 0) {
                    b.append(this.memreg);
                }
                b.append(')');
                b.append(" , ");
                break;
            }
            case 35: {
                b.append('(');
                b.append("=");
                b.append(this.lookaheadId);
                b.append(" , ");
                break;
            }
            case 36: {
                b.append('=');
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case 37: {
                b.append("(!");
                b.append(this.lookaheadId);
                b.append(" , ");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 38: {
                b.append('!');
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case 39: {
                b.append('(');
                b.append("<=");
                b.append(this.lookaheadId);
                b.append(" , dist=");
                b.append(this.distance);
                b.append(" , ");
                break;
            }
            case 40: {
                b.append("<=");
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case 41: {
                b.append("(<!");
                b.append(this.lookaheadId);
                b.append(" , dist=");
                b.append(this.distance);
                b.append(" , ");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 42: {
                b.append("<!");
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case 55: {
                b.append("(reg");
                b.append(this.memreg);
                b.append("?)");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 56: {
                b.append("(cond");
                b.append(this.lookaheadId);
                b.append(((Lookahead)this).isPositive ? (char)'=' : '!');
                b.append(" , ");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 57: {
                b.append("cond");
                b.append(this.lookaheadId);
                b.append(")");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 6: {
                b.append("$");
                b.append(this.memreg);
                b.append(", ");
                break;
            }
            case 10: {
                b.append("END");
                break;
            }
            case 34: {
                b.append("(aux1)");
            }
            case 33: {
                b.append("(cnt)");
            }
            case 32: {
                b.append("=>");
                if (this.failNext != null) {
                    b.append(this.failNext.instanceNum);
                } else {
                    b.append("null");
                }
                b.append(" , ");
                break;
            }
            default: {
                b.append('[');
                switch (this.type) {
                    case 24: {
                        b.append("cnt=0");
                        break;
                    }
                    case 25: {
                        b.append("cnt++");
                        break;
                    }
                    case 26: {
                        b.append("cnt>=").append(this.maxCount);
                        break;
                    }
                    case 27: {
                        b.append("->cnt<").append(this.maxCount);
                        break;
                    }
                    case 28: {
                        b.append("M(").append(this.memreg).append(")->,Cr(").append(this.cntreg).append(")->,Cr(").append(this.cntreg).append(")++");
                        break;
                    }
                    case 29: {
                        b.append("Cr(").append(this.cntreg).append(")=0");
                        break;
                    }
                    case 30: {
                        b.append("Cr(").append(this.cntreg).append(")<").append(this.maxCount);
                        break;
                    }
                    case 31: {
                        b.append("Cr(").append(this.cntreg).append(")>=").append(this.maxCount);
                        break;
                    }
                    default: {
                        b.append("unknown type: ").append(this.type);
                    }
                }
                b.append("] , ");
            }
        }
        if (this.next != null) {
            b.append("->");
            b.append(this.next.instanceNum);
            b.append(", ");
        }
        return b.toString();
    }

    public String toStringAll() {
        return this.toStringAll(new ArrayList<Integer>());
    }

    private String toStringAll(ArrayList<Integer> v) {
        v.add(this.instanceNum);
        String s = this.toString();
        if (this.next != null && !v.contains(this.next.instanceNum)) {
            s = s + "\r\n";
            s = s + this.next.toStringAll(v);
        }
        if (this.failNext != null && !v.contains(this.failNext.instanceNum)) {
            s = s + "\r\n";
            s = s + this.failNext.toStringAll(v);
        }
        return s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Term term = (Term)o;
        if (this.type != term.type) {
            return false;
        }
        if (this.inverse != term.inverse) {
            return false;
        }
        if (this.c != term.c) {
            return false;
        }
        if (this.distance != term.distance) {
            return false;
        }
        if (this.eat != term.eat) {
            return false;
        }
        if (this.weight != term.weight) {
            return false;
        }
        if (this.memreg != term.memreg) {
            return false;
        }
        if (this.minCount != term.minCount) {
            return false;
        }
        if (this.maxCount != term.maxCount) {
            return false;
        }
        if (this.cntreg != term.cntreg) {
            return false;
        }
        if (this.lookaheadId != term.lookaheadId) {
            return false;
        }
        if (this.next != null ? !this.next.equals(term.next) : term.next != null) {
            return false;
        }
        if (this.bitset != null ? !this.bitset.equals(term.bitset) : term.bitset != null) {
            return false;
        }
        return Arrays.equals(this.bitset2, term.bitset2) && Arrays.equals(this.categoryBitset, term.categoryBitset);
    }

    public int hashCode() {
        int result = this.next != null ? this.next.hashCode() : 0;
        result = 31 * result + this.type;
        result = 31 * result + (this.inverse ? 1 : 0);
        result = 31 * result + this.c;
        result = 31 * result + this.distance;
        result = 31 * result + (this.eat ? 1 : 0);
        result = 31 * result + (this.bitset != null ? this.bitset.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.bitset2);
        result = 31 * result + Arrays.hashCode(this.categoryBitset);
        result = 31 * result + this.weight;
        result = 31 * result + this.memreg;
        result = 31 * result + this.minCount;
        result = 31 * result + this.maxCount;
        result = 31 * result + this.cntreg;
        result = 31 * result + this.lookaheadId;
        return result;
    }
}

