/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private final RandomAccessFile rf;
    private volatile boolean closed = false;

    public FileInputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        this.fd = new FileDescriptor();
        this.rf = new RandomAccessFile(file, "r");
    }

    public FileInputStream(FileDescriptor fdObj) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int read() throws IOException {
        return this.rf.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.rf.read(b);
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        return this.rf.read(data, offset, length);
    }

    @Override
    public long skip(long n) throws IOException {
        this.rf.seek(this.rf.getFilePointer() + n);
        return this.rf.getFilePointer();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.rf.length() - this.rf.getFilePointer());
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rf.close();
    }

    public final FileDescriptor getFD() throws IOException {
        throw new IOException();
    }

    protected void finalize() throws IOException {
        if (this.fd != FileDescriptor.in) {
            this.close();
        }
    }
}

